/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.business.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.dto.UpPSeqParam;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.base.util.SequenceUtil;
import cn.com.yusys.yusp.pay.common.base.util.TradeUtils;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.func.FlowFlagService;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.FlowField;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TradeInitService {
    @Autowired
    private FlowFlagService flowFlagService;
    @Autowired
    private SequenceUtil sequenceUtil;

    public YuinResult initSequence(JavaDict request) {
        if (this.flowFlagService.chkMsgidFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u62a5\u6587\u6807\u8bc6\u53f7", "__msgidflag__")).success()) {
            if ("BEPS".equals(request.getString("appid"))) {
                YuinResult result = TradeUtils.P_Trade_LocalSynComp((String)"getBepsSeqMsgid", (String)"BepsGetService", (Object[])new Object[]{request});
                if (!result.success()) {
                    return result;
                }
            } else {
                String msgidkey = request.getString("__msgidkeyname__", "crtmsgid");
                String msgidvalue = this.getInitMsgid(request.getString("appid"), request.getString("busidate", request.getString("__busidate__")), request.getString("sendclearbank"), request.getString("workseqid"));
                request.set(msgidkey, (Object)msgidvalue);
                LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316\u62a5\u6587\u6807\u8bc6\u53f7[{}][{}]", (Object[])new Object[]{msgidkey, msgidvalue});
            }
        }
        if (this.flowFlagService.chkDetailnoFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u660e\u7ec6\u6807\u8bc6\u53f7", "__detailnoflag__")).success()) {
            request.set("detailno", (Object)this.getInitDetailno(request.getString("appid"), request.getString("busidate", request.getString("__busidate__")), request.getString("sendclearbank"), request.getString("workseqid")));
            LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316\u660e\u7ec6\u6807\u8bc6\u53f7[{}][{}]", (Object[])new Object[]{"detailno", request.getString("detailno")});
        }
        if (this.flowFlagService.chkCommsgidFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u901a\u4fe1\u7ea7\u62a5\u6587\u6807\u8bc6\u53f7", "__commsgidflag__")).success()) {
            request.set("commsgid", (Object)this.getInitComMsgid(request.getString("workdate"), request.getString("workseqid")));
            LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316\u901a\u4fe1\u7ea7\u62a5\u6587\u6807\u8bc6\u53f7[{}][{}]", (Object[])new Object[]{"commsgid", request.getString("commsgid")});
        }
        if (this.flowFlagService.chkEndtoendidFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u7aef\u5bf9\u7aef\u6807\u8bc6\u53f7", "__endtoendidflag__")).success()) {
            request.set("endtoendid", (Object)this.getInitEndtoendid(request.getString("sendclearbank"), request.getString("chnlcode"), request.getString("chnldate"), request.getString("chnlseqno")));
            LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316\u7aef\u5bf9\u7aef\u6807\u8bc6\u53f7[{}][{}]", (Object[])new Object[]{"endtoendid", request.getString("endtoendid")});
        }
        if (this.flowFlagService.chkBankseqnoFlag(request, String.format("%s[%s]", "\u5224\u65ad\u662f\u5426\u83b7\u53d6\u8bf7\u6c42\u6838\u5fc3\u6d41\u6c34\u4fe1\u606f", "__bankseqnoflag__")).success()) {
            request.set("bankdate", (Object)request.getString("busidate", request.getString("__busidate__")));
            request.set("bankseqno", (Object)this.getInitBankseqno(request.getString("workseqid")));
            LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316\u8bf7\u6c42\u6838\u5fc3\u65e5\u671f[{}][{}]", (Object[])new Object[]{"bankdate", request.getString("bankdate")});
            LogUtils.printInfo((Object)this, (String)"\u521d\u59cb\u5316\u8bf7\u6c42\u6838\u5fc3\u6d41\u6c34[{}][{}]", (Object[])new Object[]{"bankseqno", request.getString("bankseqno")});
        }
        return YuinResult.newSuccessResult(null);
    }

    public String getSequence(String seqid, String length) {
        return this.getSequence(seqid, length, '0');
    }

    public String getSequence(String seqid, String length, char fillString) {
        UpPSeqParam upPSeqParam = new UpPSeqParam();
        upPSeqParam.setSeqid(seqid);
        upPSeqParam.setSeqlen(length);
        upPSeqParam.setFillString(fillString);
        return this.sequenceUtil.getSequence(upPSeqParam);
    }

    public String getSequence(JavaDict request, String seqid, String length, char fillString, String[] formate) {
        UpPSeqParam upPSeqParam = new UpPSeqParam();
        HashMap<String, String> map = new HashMap<String, String>();
        String formatestr = "";
        for (int i = 0; i < formate.length; ++i) {
            formatestr = formatestr + '{' + formate[i] + '}';
            map.put(formate[i], request.getString(formate[i], ""));
        }
        formatestr = formatestr + '{' + "SEQ" + '}';
        upPSeqParam.setSeqid(seqid);
        upPSeqParam.setSeqlen(length);
        upPSeqParam.setFillString(fillString);
        upPSeqParam.setFormate(formatestr);
        upPSeqParam.setParamMap(map);
        return this.sequenceUtil.getSequence(upPSeqParam);
    }

    public String getSeqWorkSeqid() {
        return this.getSequence("workseqid", "8");
    }

    public String getSeqWorkSeqid(String workseqid) {
        if (StringUtils.isBlank((CharSequence)workseqid)) {
            return this.getSequence("workseqid", "8");
        }
        return workseqid;
    }

    public String getSeqComMsgid(String workdate) {
        JavaDict javaDict = new JavaDict();
        javaDict.set("workdate", (Object)workdate);
        return this.getSequence(javaDict, "workseqid", "8", '0', new String[]{"workdate"});
    }

    public String getSeqMsgid(String appid, String busidate, String sendclearbank, String detailno) {
        if (FlowField.CNAPS_APPID_LIST.contains(appid)) {
            return String.format("%s%s", busidate, this.getSequence("workseqid", "8"));
        }
        if (FlowField.IBPS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)detailno)) {
                return detailno;
            }
            if (!StringUtils.isEmpty((CharSequence)sendclearbank)) {
                return String.format("%s%s%s", sendclearbank, busidate, this.getSequence("workseqid", "8"));
            }
            LogUtils.printWarn((Object)this, (String)"\u8d85\u7f51\u7cfb\u7edf\u5e8f\u5217\u53f7\u672a\u914d\u7f6e\u884c\u53f7\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u201c0\u201d\u8fdb\u884c\u586b\u5145\uff01", (Object[])new Object[0]);
            return String.format("%s%s%s", "000000000000", busidate, this.getSequence("workseqid", "8"));
        }
        if (FlowField.NCS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)detailno)) {
                return detailno;
            }
            return String.format("%s00%s", busidate, this.getSequence("workseqid", "8"));
        }
        LogUtils.printWarn((Object)this, (String)"\u672a\u914d\u7f6e\u5f53\u524d\u5e94\u7528\u6807\u8bc6\u3010{}\u3011\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4eba\u884c\u89c4\u5219\u751f\u6210", (Object[])new Object[]{appid});
        return String.format("%s%s", busidate, this.getSequence("workseqid", "8"));
    }

    public String getSeqDetailno(String appid, String busidate, String sendclearbank, String msgid) {
        if (FlowField.CNAPS_APPID_LIST.contains(appid)) {
            return String.format("%s%s", busidate, this.getSequence("workseqid", "8"));
        }
        if (FlowField.IBPS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)msgid)) {
                return msgid;
            }
            if (!StringUtils.isEmpty((CharSequence)sendclearbank)) {
                return String.format("%s%s%s", sendclearbank, busidate, this.getSequence("workseqid", "8"));
            }
            LogUtils.printWarn((Object)this, (String)"\u8d85\u7f51\u7cfb\u7edf\u5e8f\u5217\u53f7\u672a\u914d\u7f6e\u884c\u53f7\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u201c0\u201d\u8fdb\u884c\u586b\u5145\uff01", (Object[])new Object[0]);
            return String.format("%s%s%s", "000000000000", busidate, this.getSequence("workseqid", "8"));
        }
        if (FlowField.NCS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)msgid)) {
                return msgid;
            }
            return String.format("%s00%s", busidate, this.getSequence("workseqid", "8"));
        }
        LogUtils.printWarn((Object)this, (String)"\u672a\u914d\u7f6e\u5f53\u524d\u5e94\u7528\u6807\u8bc6\u3010{}\u3011\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4eba\u884c\u89c4\u5219\u751f\u6210", (Object[])new Object[]{appid});
        return String.format("%s%s", busidate, this.getSequence("workseqid", "8"));
    }

    public String getSeqEndtoendid(String sendclearbank, String chnlcode, String chnldate, String chnlseqno) {
        return sendclearbank + chnlcode + chnldate + chnlseqno;
    }

    public String getSeqBankseqno() {
        return this.getSequence("workseqid", "8");
    }

    private String getInitComMsgid(String workdate, String workseqid) {
        return String.format("%s%s", workdate, workseqid);
    }

    private String getInitMsgid(String appid, String busidate, String sendclearbank, String workseqid) {
        if (FlowField.CNAPS_APPID_LIST.contains(appid)) {
            return String.format("%s%s", busidate, workseqid);
        }
        if (FlowField.IBPS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)sendclearbank)) {
                return String.format("%s%s%s", sendclearbank, busidate, workseqid);
            }
            LogUtils.printWarn((Object)this, (String)"\u8d85\u7f51\u7cfb\u7edf\u5e8f\u5217\u53f7\u672a\u914d\u7f6e\u884c\u53f7\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u201c0\u201d\u8fdb\u884c\u586b\u5145\uff01", (Object[])new Object[0]);
            return String.format("%s%s%s", "000000000000", busidate, workseqid);
        }
        if (FlowField.NCS_APPID_LIST.contains(appid)) {
            return String.format("%s00%s", busidate, workseqid);
        }
        LogUtils.printWarn((Object)this, (String)"\u672a\u914d\u7f6e\u5f53\u524d\u5e94\u7528\u6807\u8bc6\u3010{}\u3011\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4eba\u884c\u89c4\u5219\u751f\u6210", (Object[])new Object[]{appid});
        return String.format("%s%s", busidate, workseqid);
    }

    private String getInitDetailno(String appid, String busidate, String sendclearbank, String workseqid) {
        if (FlowField.CNAPS_APPID_LIST.contains(appid)) {
            return String.format("%s%s", busidate, this.getSequence("workseqid", "8"));
        }
        if (FlowField.IBPS_APPID_LIST.contains(appid)) {
            if (!StringUtils.isEmpty((CharSequence)sendclearbank)) {
                return String.format("%s%s%s", sendclearbank, busidate, workseqid);
            }
            LogUtils.printWarn((Object)this, (String)"\u8d85\u7f51\u7cfb\u7edf\u5e8f\u5217\u53f7\u672a\u914d\u7f6e\u884c\u53f7\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u201c0\u201d\u8fdb\u884c\u586b\u5145\uff01", (Object[])new Object[0]);
            return String.format("%s%s%s", "000000000000", busidate, workseqid);
        }
        if (FlowField.NCS_APPID_LIST.contains(appid)) {
            return String.format("%s00%s", busidate, workseqid);
        }
        LogUtils.printWarn((Object)this, (String)"\u672a\u914d\u7f6e\u5f53\u524d\u5e94\u7528\u6807\u8bc6\u3010{}\u3011\uff0c\u9ed8\u8ba4\u4f7f\u7528\u4eba\u884c\u89c4\u5219\u751f\u6210", (Object[])new Object[]{appid});
        return String.format("%s%s", busidate, this.getSequence("workseqid", "8"));
    }

    private String getInitEndtoendid(String sendclearbank, String chnlcode, String chnldate, String chnlseqno) {
        return sendclearbank + chnlcode + chnldate + chnlseqno;
    }

    private String getInitBankseqno(String workseqid) {
        return workseqid;
    }
}

