/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.busideal.component.business.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.component.fieldmap.service.UpPDictService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ErrorCode;
import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class OrigInfoService {
    @Resource
    private UpPDictService upPDictService;
    @Resource
    private TradeOperDbService tradeOperDbService;

    public YuinResult getOrigInfoMap(JavaDict request, JavaDict originfo) {
        String selactionkey = request.getString("__sel_originfo__");
        String mapactionkey = request.getString("__map_originfo__");
        return this.getOrigInfoMap(request, originfo, selactionkey, mapactionkey);
    }

    public YuinResult getOrigInfoMap(JavaDict request, JavaDict originfo, String selactionkey, String mapactionkey) {
        LogUtils.printInfo((Object)this, (String)"\u67e5\u8be2\u5e76\u6620\u5c04 selactionkey[{}] mapactionkey[{}]", (Object[])new Object[]{selactionkey, mapactionkey});
        try {
            if (StringUtils.isEmpty((CharSequence)selactionkey) || StringUtils.isEmpty((CharSequence)mapactionkey)) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u539f\u4e1a\u52a1\u67e5\u8be2\u6620\u5c04key\u4e0d\u5408\u6cd5");
            }
            ArrayList<String> sellist = new ArrayList<String>();
            sellist.add(selactionkey);
            YuinResultDto selresult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), sellist);
            if (!selresult.isSuccess()) {
                return YuinResult.newFailureResult((String)selresult.getHead().getResponseCode(), (String)selresult.getHead().getResponseMsg());
            }
            List originfolist = (List)selresult.getBody();
            if (originfolist.size() == 0) {
                return YuinResult.newFailureResult((String)"E1412", (String)ErrorCode.getErrmsg((String)"E1412"));
            }
            if (originfolist.size() > 1) {
                return YuinResult.newFailureResult((String)"E1418", (String)ErrorCode.getErrmsg((String)"E1418"));
            }
            originfo.setMap((Map)originfolist.get(0));
            request.set("__originfo__", (Object)originfo);
            ArrayList<String> maplist = new ArrayList<String>();
            maplist.add(mapactionkey);
            YuinResultDto mapresult = this.tradeOperDbService.operDbaction(originfo, request.getString("sysid"), request.getString("appid"), maplist);
            if (!mapresult.isSuccess()) {
                return YuinResult.newFailureResult((String)mapresult.getHead().getResponseCode(), (String)mapresult.getHead().getResponseMsg());
            }
            request.setMap((Map)mapresult.getBody());
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"E9999", (String)String.format("\u67e5\u8be2\u539f\u4e1a\u52a1\u4fe1\u606f\u5e76\u6620\u5c04\u5f02\u5e38: %s", e.getMessage()));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getOrigAddMap(JavaDict request, JavaDict mapDict) {
        YuinResult result = null;
        try {
            if (!request.hasKey("__sel_originfo__") || !request.hasKey("__map_originfo__")) {
                return YuinResult.newFailureResult((String)"E9010", (String)ErrorCode.getErrmsg((String)"E9010"));
            }
            String selKey = request.getString("__sel_originfo__");
            String mapKey = request.getString("__map_originfo__");
            YuinResultDto selMainResult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), selKey);
            if (!selMainResult.isSuccess()) {
                return YuinResult.newFailureResult((String)selMainResult.getHead().getResponseCode(), (String)selMainResult.getHead().getResponseMsg());
            }
            List origMainList = (List)selMainResult.getBody();
            if (CollectionUtil.isEmpty((Collection)origMainList)) {
                return YuinResult.newFailureResult((String)"E1412", (String)ErrorCode.getErrmsg((String)"E1412"));
            }
            Map origInfo = (Map)origMainList.get(0);
            String dictInfo = String.format("sysid,appid,#getTranjnlAddInfo,#S,#tranjnlAddInfo,#%s", origInfo.get("msgtype"));
            result = this.upPDictService.getDictValue2ByKey(request, dictInfo);
            if (!result.success()) {
                return result;
            }
            String actionKey = (String)result.getOutputParams().get(0);
            YuinResultDto selAddResult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), actionKey);
            if (!selAddResult.isSuccess()) {
                return YuinResult.newFailureResult((String)selAddResult.getHead().getResponseCode(), (String)selAddResult.getHead().getResponseMsg());
            }
            List origAddList = (List)selAddResult.getBody();
            if (CollectionUtil.isEmpty((Collection)origAddList)) {
                return YuinResult.newFailureResult((String)"E1412", (String)ErrorCode.getErrmsg((String)"E1412"));
            }
            Map addInfo = (Map)origAddList.get(0);
            mapDict.setMap(addInfo);
            YuinResultDto mapResult = this.tradeOperDbService.operDbaction(mapDict, request.getString("sysid"), request.getString("appid"), mapKey);
            if (!mapResult.isSuccess()) {
                return YuinResult.newFailureResult((String)mapResult.getHead().getResponseCode(), (String)mapResult.getHead().getResponseMsg());
            }
            request.setMap((Map)mapResult.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)"\u539f\u4e1a\u52a1\u83b7\u53d6\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }
}

