/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.util;

import cn.com.yusys.yusp.pay.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.pay.common.base.dto.YuinRequestHead;
import com.alibaba.fastjson.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.cglib.beans.BeanMap;

public class YuinBeanUtil {
    public static Map<String, Object> convertRequest(YuinRequestDto requestDto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        YuinRequestHead head = requestDto.getSysHead();
        Map<String, Object> headMap = YuinBeanUtil.transBean2Map(head);
        result.putAll(headMap);
        Map<String, Object> bodyMap = YuinBeanUtil.transBean2Map(requestDto.getBody());
        result.putAll(bodyMap);
        return result;
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj == null) {
            return map;
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                Object value;
                String key = property.getName();
                if (key.equals("class") || !Objects.nonNull(value = (getter = property.getReadMethod()).invoke(obj, new Object[0]))) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        return (T)JSON.parseObject((String)JSON.toJSONString(map), clazz);
    }

    public static <T> List<T> listMapToBean(List<Map<String, Object>> listMap, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map<String, Object> map : listMap) {
            T t = YuinBeanUtil.mapToBean(map, clazz);
            result.add(t);
        }
        return result;
    }

    public static void mergeMap(Map<String, Object> toMap, Map<String, Object> fromMap) {
        Set<String> keys = fromMap.keySet();
        for (String key : keys) {
            Object toValue = toMap.get(key);
            Object fromValue = fromMap.get(key);
            if (!(toMap.containsKey(key) && toValue instanceof Map && fromValue instanceof Map)) {
                toMap.put(key, fromValue);
                continue;
            }
            YuinBeanUtil.mergeMap((Map)toValue, (Map)fromValue);
        }
    }
}

