/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.util;

import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtilEx {
    private static final char CHAR_QUOT = '&';
    private static final byte[][] esc = new byte[][]{"&lt;".getBytes(), "&gt;".getBytes(), "&quot;".getBytes(), "&apos;".getBytes(), "&amp;".getBytes(), "&#xA;".getBytes()};
    private static final byte[] destChar = new byte[]{60, 62, 34, 39, 38, 10};

    public static String join(String[] strArr, String split) {
        if (strArr == null) {
            return "";
        }
        String _str = "";
        for (int i = 0; i < strArr.length; ++i) {
            _str = _str.equals("") ? strArr[i] : String.format("%s%s%s", _str, split, strArr[i]);
        }
        return _str;
    }

    public static String fill(String sSrc, char ch, int nLen, boolean bLeft) {
        byte[] bTmp = StringUtilEx.trimnull(sSrc.getBytes());
        if ((sSrc = new String(bTmp)) == null || sSrc.equals("")) {
            StringBuilder sbRet = new StringBuilder();
            for (int i = 0; i < nLen; ++i) {
                sbRet.append(ch);
            }
            return sbRet.toString();
        }
        byte[] bySrc = sSrc.getBytes();
        int nSrcLen = bySrc.length;
        if (nSrcLen >= nLen) {
            return sSrc;
        }
        byte[] byRet = new byte[nLen];
        if (bLeft) {
            int i;
            int n = nLen - nSrcLen;
            for (i = 0; i < n; ++i) {
                byRet[i] = (byte)ch;
            }
            n = nLen;
            for (i = nLen - nSrcLen; i < n; ++i) {
                byRet[i] = bySrc[i - nLen + nSrcLen];
            }
        } else {
            int i;
            int n = nSrcLen;
            for (i = 0; i < n; ++i) {
                byRet[i] = bySrc[i];
            }
            n = nLen;
            for (i = nSrcLen; i < n; ++i) {
                byRet[i] = (byte)ch;
            }
        }
        return new String(byRet);
    }

    public static String delete(String sSrc, char ch, int nLen, boolean bLeft) {
        byte[] bySrc = sSrc.getBytes();
        if (bLeft) {
            int i = 0;
            while (bySrc[i] == ch && (nLen < 0 || bySrc.length - i > nLen)) {
                if (++i != bySrc.length) continue;
                return "";
            }
            byte[] bt = new byte[bySrc.length - i];
            System.arraycopy(bySrc, i, bt, 0, bySrc.length - i);
            return new String(bt);
        }
        int i = bySrc.length - 1;
        while (bySrc[i] == ch && (nLen < 0 || i != nLen - 1)) {
            if (--i >= 0) continue;
            return "";
        }
        byte[] bt = new byte[i + 1];
        System.arraycopy(bySrc, 0, bt, 0, i + 1);
        return new String(bt);
    }

    public static String cut(String sSrc, char ch, boolean bLeft) {
        byte[] bySrc = sSrc.getBytes();
        byte[] bt = null;
        if (bLeft) {
            for (int i = 0; i < bySrc.length; ++i) {
                if (bySrc[i] != ch) continue;
                bt = new byte[i];
                System.arraycopy(bySrc, 0, bt, 0, i);
                break;
            }
        } else {
            for (int i = bySrc.length - 1; i >= 0; --i) {
                if (bySrc[i] != ch) continue;
                bt = new byte[bySrc.length - i - 1];
                System.arraycopy(bySrc, i + 1, bt, 0, bySrc.length - i - 1);
                break;
            }
        }
        if (bt == null) {
            return sSrc;
        }
        return new String(bt);
    }

    public static String replaceString(String sSrc, int start, int end, String signString) {
        byte[] bySrc = sSrc.getBytes();
        if (start <= 0) {
            start = 1;
        }
        int len1 = bySrc.length;
        if (end <= 0 || end > len1) {
            end = len1;
        }
        if (start > len1 || start > end) {
            return sSrc;
        }
        int len2 = signString.length();
        byte[] b = signString.getBytes();
        byte[] bb = new byte[len1 + len2 - end + start - 1];
        System.arraycopy(bySrc, 0, bb, 0, start - 1);
        System.arraycopy(b, 0, bb, start - 1, len2);
        System.arraycopy(bySrc, end, bb, start + len2 - 1, len1 - end);
        return new String(bb);
    }

    public static String translateChar(String sSrc) {
        byte[] bySrc = sSrc.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        for (int i = 0; i < bySrc.length; ++i) {
            if (bySrc[i] == 38) {
                int index = -1;
                for (int j = 0; j < esc.length; ++j) {
                    boolean flag = true;
                    if (i + esc[j].length <= bySrc.length) {
                        for (int k = 1; k < esc[j].length; ++k) {
                            if (esc[j][k] == bySrc[i + k]) continue;
                            flag = false;
                            break;
                        }
                    } else {
                        flag = false;
                    }
                    if (!flag) continue;
                    index = j;
                    break;
                }
                if (index != -1) {
                    baos.write(destChar[index]);
                    i += esc[index].length - 1;
                    continue;
                }
                baos.write(bySrc[i]);
                continue;
            }
            baos.write(bySrc[i]);
        }
        byte[] result = baos.toByteArray();
        return new String(result);
    }

    public static byte[] trimnull(byte[] byRet) {
        int i;
        int startPos = 0;
        int endPos = byRet.length - 1;
        for (i = 0; i < byRet.length; ++i) {
            if (byRet[i] != 0) {
                startPos = i;
                break;
            }
            if (i != byRet.length - 1 || byRet[i] != 0) continue;
            return null;
        }
        for (i = byRet.length - 1; i >= 0; --i) {
            if (byRet[i] == 0) continue;
            endPos = i;
            break;
        }
        byte[] byTmp = new byte[endPos - startPos + 1];
        System.arraycopy(byRet, startPos, byTmp, 0, endPos - startPos + 1);
        return byTmp;
    }

    public static boolean isNullOrWhiteSpace(String str) {
        if (StringUtilEx.isNullOrEmpty(str)) {
            return true;
        }
        return str.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }

    public static boolean equalsNotCL(String str1, String str2) {
        return str1.regionMatches(true, 0, str2, 0, str2.length());
    }

    public static boolean CheckBcontentA(String stringA, String stringB, String split) {
        boolean flag = false;
        String[] typesA = stringA.split(split);
        String[] typesB = stringB.split(split);
        int count = 0;
        for (int i = 0; i < typesA.length; ++i) {
            for (int j = 0; j < typesB.length; ++j) {
                if (!typesA[i].equals(typesB[j])) continue;
                flag = true;
                flag = flag && typesA[i].equals(typesB[j]);
                ++count;
            }
        }
        if (count == 0) {
            flag = true;
        }
        return flag;
    }

    public static String getSubstringBybyte(String s, int beginindex, int length, String enconding) throws Exception {
        if (StringUtilEx.isNullOrEmpty(enconding)) {
            enconding = "GBK";
        }
        String retStr = "";
        byte[] srcbyte = s.getBytes(enconding);
        byte[] dest = new byte[length];
        System.arraycopy(srcbyte, beginindex, dest, 0, length);
        retStr = new String(dest, enconding);
        return retStr;
    }

    public static String chineseSubstring(String s, int length) {
        try {
            int i;
            byte[] bytes = s.getBytes("GBK");
            int n = 0;
            for (i = 2; i < bytes.length && n < length; ++i) {
                if (i % 2 == 1) {
                    ++n;
                    continue;
                }
                if (bytes[i] == 0) continue;
                ++n;
            }
            if (i % 2 == 1) {
                ++i;
            }
            return new String(bytes, 0, i, "GBK");
        }
        catch (Exception e) {
            return s;
        }
    }

    public static String[] chineseSubstring2args(String s, int length) {
        try {
            int i;
            byte[] bytes = s.getBytes("GBK");
            if (bytes.length < length) {
                return new String[]{s};
            }
            int n = 0;
            for (i = 2; i < bytes.length && n < length; ++i) {
                if (i % 2 == 1) {
                    ++n;
                    continue;
                }
                if (bytes[i] == 0) continue;
                ++n;
            }
            if (i % 2 == 1) {
                ++i;
            }
            String a1 = new String(bytes, 0, i, "GBK");
            return new String[]{a1, new String(bytes, i, bytes.length - i, "GBK")};
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getInteger(String vlaue) {
        if (StringUtilEx.isNullOrEmpty(vlaue)) {
            return -1;
        }
        return Integer.parseInt(vlaue);
    }

    public static boolean isArrayequle(String str, String[] array) {
        if (array.length <= 0 || array == null) {
            return false;
        }
        for (String isstr : array) {
            if (!str.equals(isstr)) continue;
            return true;
        }
        return false;
    }

    public static Object getMapValue(Map<String, Object> reqMap, String key) {
        if (!reqMap.containsKey(key) || reqMap.get(key) == null) {
            return "";
        }
        return reqMap.get(key);
    }

    public static Object getDictValue(JavaDict reqMap, String key) {
        if (!reqMap.hasKey(key) || reqMap.get(key) == null) {
            return "";
        }
        return reqMap.get(key);
    }

    public static String getLastNum(String str) {
        String dest;
        if (!StringUtilEx.isNullOrWhiteSpace(str) && (dest = str.replaceAll("[^0-9]", "")).length() > 0) {
            return dest.substring(dest.length() - 1);
        }
        return "";
    }

    public static boolean boolContainChinese(String str) {
        if (StringUtilEx.isNullOrEmpty(str)) {
            return Boolean.FALSE;
        }
        Pattern p = Pattern.compile("[\u4e00-\u9fa5|\\\uff01|\\\uff0c|\\\u3002|\\\uff08|\\\uff09|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\uff1f|\\\uff1a|\\\uff1b|\\\u3010|\\\u3011]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

