/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.component.sequence.service.SequenceService;
import cn.com.yusys.yusp.pay.common.base.dto.UpPSeqParam;
import cn.com.yusys.yusp.pay.common.base.util.DateUtils;
import java.net.InetAddress;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SequenceUtil {
    @Autowired
    private SequenceService sequenceService;
    @Value(value="${spring.application.name}")
    private String servicename;

    public String getSequence(UpPSeqParam upPSeqParam) {
        return this.sequenceService.getSequence(upPSeqParam);
    }

    public String getGlobalSequence(String appid, String curtdate) {
        UpPSeqParam upPSeqParam = new UpPSeqParam();
        upPSeqParam.setSeqid("globalseq");
        upPSeqParam.setSeqlen("8");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("curtdate", curtdate);
        param.put("appid", appid);
        upPSeqParam.setParamMap(param);
        upPSeqParam.setFillString('0');
        upPSeqParam.setFormate("{appid}{curtdate}{SEQ}");
        return this.sequenceService.getSequence(upPSeqParam);
    }

    public String getGlobalSequence() {
        String serflag = StringUtils.fill((String)this.servicename.substring(this.servicename.lastIndexOf("-") + 1), (String)"0", (int)5, (int)2);
        if (serflag.length() > 5) {
            serflag = serflag.substring(0, 5);
        }
        String terip = "000000";
        try {
            String[] ipadd = InetAddress.getLocalHost().getHostAddress().split("\\.");
            terip = String.format("%03d", Integer.valueOf(ipadd[1])) + String.format("%03d", Integer.valueOf(ipadd[2])) + String.format("%03d", Integer.valueOf(ipadd[3]));
        }
        catch (Exception e) {
            terip = "000000";
        }
        String datetime = DateUtils.getSysDate("yyyyMMddHHmmss");
        UpPSeqParam upPSeqParam = new UpPSeqParam();
        upPSeqParam.setSeqid("globalseq");
        upPSeqParam.setSeqlen("8");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serflag", serflag);
        param.put("terip", terip);
        param.put("datetime", datetime);
        upPSeqParam.setParamMap(param);
        upPSeqParam.setFillString('0');
        upPSeqParam.setFormate("{serflag}{terip}{datetime}{SEQ}");
        return this.sequenceService.getSequence(upPSeqParam);
    }
}

