/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;

public class JSONUtil {
    public static JSONObject getJson(String jsonStr, boolean isReturnDefault) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            if (isReturnDefault) {
                return new JSONObject();
            }
            return null;
        }
        return JSONObject.parseObject((String)jsonStr);
    }

    public static Object getJsonValue(JSONObject json, String key) {
        if (null != json && !StringUtils.isEmpty((CharSequence)key) && json.containsKey((Object)key)) {
            return json.get((Object)key);
        }
        return null;
    }

    public static Object getJsonValue(String jsonStr, String key) {
        if (!StringUtils.isEmpty((CharSequence)jsonStr) && !StringUtils.isEmpty((CharSequence)key)) {
            JSONObject json = JSONObject.parseObject((String)jsonStr);
            return JSONUtil.getJsonValue(json, key);
        }
        return null;
    }

    public static String getJsonString(JSONObject json, String key) {
        if (null != json && !StringUtils.isEmpty((CharSequence)key) && json.containsKey((Object)key)) {
            return json.getString(key);
        }
        return null;
    }

    public static Integer getJsonInteger(JSONObject json, String key) {
        if (null != json && !StringUtils.isEmpty((CharSequence)key) && json.containsKey((Object)key)) {
            return json.getInteger(key);
        }
        return null;
    }

    public static Boolean getJsonBoolean(JSONObject json, String key) {
        if (null != json && !StringUtils.isEmpty((CharSequence)key) && json.containsKey((Object)key)) {
            return json.getBoolean(key);
        }
        return null;
    }

    public static Double getJsonDouble(JSONObject json, String key) {
        if (null != json && !StringUtils.isEmpty((CharSequence)key) && json.containsKey((Object)key)) {
            return json.getDouble(key);
        }
        return null;
    }

    public static Float getJsonFloat(JSONObject json, String key) {
        if (null != json && !StringUtils.isEmpty((CharSequence)key) && json.containsKey((Object)key)) {
            return json.getFloat(key);
        }
        return null;
    }

    public static JSONObject getJsonTrim(String jsonStr, boolean isReturnDefault) {
        JSONObject json = JSONUtil.getJson(JSONUtil.trim(jsonStr, 1), isReturnDefault);
        return json;
    }

    public static String trim(String jsonStr, int type) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        if (type == 1) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            JSONObject jsonObjectTrim = new JSONObject();
            for (String str : jsonObject.keySet()) {
                int ctype = JSONUtil.testIsArrayORObject(jsonObject.getString(str));
                String value = JSONUtil.trim(jsonObject.getString(str), ctype);
                JSONUtil.parseJsonByType(jsonObjectTrim, str, value, ctype);
            }
            return jsonObjectTrim.toJSONString();
        }
        if (type == 2) {
            if (!jsonStr.equals("null")) {
                JSONArray jsonArray = JSONObject.parseArray((String)jsonStr);
                JSONArray jsonArrayTrim = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    JSONObject jsonObjectTrim = new JSONObject();
                    for (String str : jsonObject.keySet()) {
                        int ctype = JSONUtil.testIsArrayORObject(jsonObject.getString(str));
                        String value = JSONUtil.trim(jsonObject.getString(str), ctype);
                        JSONUtil.parseJsonByType(jsonObjectTrim, str, value, ctype);
                    }
                    jsonArrayTrim.add((Object)jsonObjectTrim);
                }
                return jsonArrayTrim.toJSONString();
            }
            return jsonStr;
        }
        return jsonStr.trim();
    }

    public static void parseJsonByType(JSONObject json, String key, String value, int type) {
        if (type == 1) {
            json.put(key, (Object)JSON.parseObject((String)value));
        } else if (type == 2) {
            json.put(key, (Object)JSON.parseArray((String)value));
        } else {
            json.put(key, (Object)value);
        }
    }

    public static int testIsArrayORObject(String sJSON) {
        if (StringUtils.isBlank((CharSequence)sJSON)) {
            return 0;
        }
        try {
            JSONArray array = JSONObject.parseArray((String)sJSON);
            return 2;
        }
        catch (JSONException e) {
            try {
                JSONObject object = JSONObject.parseObject((String)sJSON);
                return 1;
            }
            catch (JSONException e2) {
                return 0;
            }
        }
    }

    public static JSONObject dataToJSONObject(Object data) throws Exception {
        try {
            return (JSONObject)JSON.toJSON((Object)data);
        }
        catch (JSONException e) {
            throw new Exception("\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e0d\u662fjson\u5bf9\u8c61");
        }
    }

    public static JSONArray dataToJSONArray(Object data) throws Exception {
        try {
            return (JSONArray)JSON.toJSON((Object)data);
        }
        catch (JSONException e) {
            throw new Exception("\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e0d\u662fjson\u6570\u7ec4");
        }
    }
}

