/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.util;

import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtils {
    public static String getSysDate(String dateFormatStr) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        return df.format(new Date());
    }

    public static Boolean isInSectionTime(String time, String startTime, String endTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        Date timeD = sdf.parse(time);
        Date startTimeD = sdf.parse(startTime);
        Date endTimeD = sdf.parse(endTime);
        if (timeD.getTime() == startTimeD.getTime() || timeD.getTime() == endTimeD.getTime()) {
            return Boolean.TRUE;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(timeD);
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(startTimeD);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(endTimeD);
        return date.after(startDate) && date.before(endDate);
    }

    public static String getWeek(String dateFormatStr, String datestr) {
        String week = "";
        try {
            Date date = new SimpleDateFormat(dateFormatStr).parse(datestr);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int weekday = cal.get(7);
            if (cal.getFirstDayOfWeek() == 1 && --weekday == 0) {
                weekday = 7;
            }
            week = String.valueOf(weekday);
        }
        catch (Exception e) {
            LogUtils.printWarn(DateUtils.class, "\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38: \u65e5\u671f\u5b57\u7b26\u4e32[{}]\u4e0e\u8f93\u5165\u683c\u5f0f[{}]\u4e0d\u76f8\u7b26, \u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32", datestr, dateFormatStr);
            return week;
        }
        return week;
    }

    public static List<String> getWeekDay(int year) {
        ArrayList<String> dateList = new ArrayList<String>();
        SimpleDateFormat sid = new SimpleDateFormat("yyyyMMdd");
        GregorianCalendar calendar = new GregorianCalendar(year, 0, 1);
        int i = 1;
        while (calendar.get(1) < year + 1) {
            calendar.set(3, i++);
            calendar.set(7, 1);
            if (calendar.get(1) == year) {
                dateList.add(sid.format(calendar.getTime()));
            }
            calendar.set(7, 7);
            if (calendar.get(1) != year) continue;
            dateList.add(sid.format(calendar.getTime()));
        }
        return dateList;
    }
}

