/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.base.component.cosapi;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.common.base.util.YuinLogUtils;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CspComponent {
    @Value(value="${tsf.csp.SecretId:AKIDqPfaAQLwC8jzv1qKTHmVz8xRbQu5vQbR}")
    private String SecretId;
    @Value(value="${tsf.csp.SecretId:YldBPIq4xVib9MEmzrPdW5KGr84fwsUm}")
    private String SecretKey;
    @Value(value="${tsf.csp.region:imcr}")
    private String region;
    @Value(value="${tsf.csp.domain:csp.tce.nmgnxs.com.cn}")
    private String domain;
    @Value(value="${tsf.csp.bucketName:tongyizhifuxitong-dev-1255000214}")
    private String bucketName;

    public COSClient getcosclient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.SecretId, this.SecretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(this.region));
        SelfDefineEndPointBuilder selfDefineEndPointBuilder = new SelfDefineEndPointBuilder(this.region, this.domain);
        clientConfig.setHttpProtocol(HttpProtocol.http);
        clientConfig.setEndpointBuilder((EndpointBuilder)selfDefineEndPointBuilder);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putObject(File localFile, String key) {
        COSClient cosClient = this.getcosclient();
        try {
            PutObjectRequest request = new PutObjectRequest(this.bucketName, key, localFile);
            PutObjectResult putObjectResult = cosClient.putObject(request);
            if (putObjectResult != null && StringUtils.nonEmpty((CharSequence)putObjectResult.getRequestId())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (CosServiceException e) {
            YuinLogUtils.getInst(this).error("\u4e0eCOS\u670d\u52a1\u4ea4\u4e92\u6b63\u5e38\uff0c\u4e0a\u4f20\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (CosClientException e) {
            YuinLogUtils.getInst(this).error("\u4e0eCOS\u670d\u52a1\u4ea4\u4e92\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (Exception e) {
            YuinLogUtils.getInst(this).error("\u4e0a\u4f20\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Object)e.getMessage());
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getObject(String key, String filepath, boolean useTrafficLimit) {
        COSClient cosClient = this.getcosclient();
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucketName, key);
            if (useTrafficLimit) {
                request.setTrafficLimit(0x800000);
            }
            File localFile = new File(filepath);
            ObjectMetadata objectMetadata = cosClient.getObject(request, localFile);
            Long length = objectMetadata.getContentLength();
            cosClient.shutdown();
            Long l = length;
            return l;
        }
        catch (CosServiceException e) {
            YuinLogUtils.getInst(this).error("\u4e0eCOS\u670d\u52a1\u4ea4\u4e92\u6b63\u5e38\uff0c\u4e0b\u8f7d\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (CosClientException e) {
            YuinLogUtils.getInst(this).error("\u4e0eCOS\u670d\u52a1\u4ea4\u4e92\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (Exception e) {
            YuinLogUtils.getInst(this).error("\u4e0b\u8f7d\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Object)e.getMessage());
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteObject(String key) {
        COSClient cosClient = this.getcosclient();
        try {
            cosClient.deleteObject(this.bucketName, key);
            cosClient.shutdown();
            int n = 1;
            return n;
        }
        catch (CosServiceException e) {
            YuinLogUtils.getInst(this).error("\u4e0eCOS\u670d\u52a1\u4ea4\u4e92\u6b63\u5e38\uff0c\u5220\u9664\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (CosClientException e) {
            YuinLogUtils.getInst(this).error("\u4e0eCOS\u670d\u52a1\u4ea4\u4e92\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (Exception e) {
            YuinLogUtils.getInst(this).error("\u5220\u9664\u6587\u4ef6\u5bf9\u8c61\u5f02\u5e38", (Object)e.getMessage());
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
        return 0;
    }

    public class SelfDefineEndPointBuilder
    implements EndpointBuilder {
        private String region;
        private String domain;

        public SelfDefineEndPointBuilder(String region, String domain) {
            this.region = Region.formatRegion((Region)new Region(region));
            this.domain = domain;
        }

        public String buildGeneralApiEndpoint(String bucketName) {
            String endpoint = String.format("%s.%s", this.region, this.domain);
            return String.format("%s.%s", bucketName, endpoint);
        }

        public String buildGetServiceApiEndpoint() {
            return String.format("%s.%s", this.region, this.domain);
        }
    }
}

