   /**
    * 预警规则配置
    */
   define(function (require, exports) {
       //page加载完成后调用ready方法
       exports.ready = function (hashCode, data, cite) {
				 yufp.lookup.reg("INDEX_TYPE");
           var thisRouter = this.Router;
					 var pageNo = 1;
					 var pageSize = 10;
					 var condition = 0;
					 var model0;
           //创建virtual filter model
           var vm = yufp.custom.vue({
               el: cite.el,
               //以m_开头的参数为UI数据不作为业务数据，否则为业务数据
               data: function () {
                   var me = this;
                   return {
										 queryFields: [
											{ placeholder: '规则名称', field: 'name',type: 'input'},
										 	{ placeholder: '监控类型', field: 'type',type: 'select',dataCode:'INDEX_TYPE'},
											{
													field: 'timeRange',
													placeholder: '时间范围',
													type:"datetimerange",
													rangeSeparator:"--"
											}
										 ],
										 queryButtons:[
										 	{label:'搜索',op:'submit',type: 'primary', icon: "search",show: true, click: function (model, valid) {
														condition = 1;
														model0 = model;
														me.handleCurrentChange(1);
										 		}
										 	},
										 	{label: '重置', op: 'reset', type: 'primary', icon: 'yx-loop2', show: this.resetButton,click: function (model, valid) {
														condition = 0;
										 		} 
											}
										 ],
										 total0:0,
										 currentPage0: pageNo,
                   	expandCollapseName: [''],
                       historyInfo: {
                           url: backend.dashboardService + '/api/warnrulehistory/?pageNo='+pageNo+'&pageSize='+pageSize,
                           columns: [
                            { label: 'id',
                               prop: 'id',
                               hidden:true
                           },
                              { label: '预警内容',
                               prop: 'content'
                         }, {
                         	label: '预警时间',
                               prop: 'time',
                               formatter:function(data){
                               	var date = new Date(data.time);
                               	return me.dateFormatter(date,"yyyy-MM-dd hh:mm:ss")
//                             	return date.getFullYear()+"/"+date.getMonth()+"/"+date.getDay() +" " + date.getHours()+":"+date.getMinutes()+":"+date.getSeconds()
                               }
                         }]
                       },
                       form: {
                           visible: false,
                           disable: false,
                           fields: [{
                               columnCount: 1,
                               fields: [
                               {
                                   field: 'content',
                                   label: '预警内容',
                                   readonly:true
                              },{
                              	field: 'time',
                                   label: '预警时间',
                                   readonly:true
                              }]
                           }]
                       },
                       rule: {
                           visible: false,
                           disable: false,
                           fields: [{
                               columnCount: 2,
                               fields: [
                               {
                               	 field: 'name',
                                   label: '规则名称',
                                    readonly:true
                               },{
                                   field: 'type',
                                   label: '预警类型',
                                   readonly:true
                               },{
                                   field: 'source',
                                   label: '监控目标',
                                   readonly:true
                               },
                               {
                                   field: 'interval',
                                   label: '监控周期',
                                   readonly:true
                               },
                                {
                                   field: 'startTime',
                                   label: '开始时间',
                                   readonly:true
                               },
                                {
                                   field: 'endTime',
                                   label: '结束时间',
                                   readonly:true
                               }]
                           },{
                           	 columnCount: 1,
                               fields: [
                                {
                                   field: 'ruleDesc',
                                   label: '预警条件',
                                   readonly:true
                               },
                               {
                                   field: 'alertType',
                                   label: '预警方式',
                                   readonly:true
                               }]
                           	
                           }]
                       }
                   };
               },
              created(){
								this.getTotal();
              },
               methods: {
								 getTotal:function(){
									 	var url0= backend.dashboardService + "/api/warnrulehistory/count";
									 if(condition == 1){
									 	var name = model0.name;
									 	var type = model0.type;
										url0 += "?name="+name+"&type="+type;
										if(model0.timeRange[0] != null && model0.timeRange[0] != '')
										{
											var startTime = model0.timeRange[0].getTime();
											url0 += "&startTime="+startTime;
										}
										if(model0.timeRange[1] != null && model0.timeRange[1] != '')
										{
											var endTime = model0.timeRange[1].getTime();
											url0 += "&endTime="+endTime;
										}
									 }
									 var me = this;
									 $.ajax({
									 	type: "GET",
									 	url: url0,
									 	success: function(data){
									 		if(data.code != -1)
									 		{
												me.total0 = data.data;
											}
									 	}
									 });
								 },
								  handleSizeChange:function(val) {
										pageSize = val;
										var url0= backend.dashboardService + '/api/warnrulehistory/?pageNo='+pageNo+'&pageSize='+pageSize;
										if(condition == 1){
											var name = model0.name;
											var type = model0.type;
											url0 += "&name="+name+"&type="+type;
											if(model0.timeRange[0] != null && model0.timeRange[0] != '')
											{
												var startTime = model0.timeRange[0].getTime();
												url0 += "&startTime="+startTime;
											}
											if(model0.timeRange[1] != null && model0.timeRange[1] != '')
											{
												var endTime = model0.timeRange[1].getTime();
												url0 += "&endTime="+endTime;
											}
											this.getTotal();
										}
										// this.$refs.historyTable.remoteData();
										var me = this;
										$.ajax({
											type: "GET",
											url: url0,
											success: function(data){
												if(data.code != -1)
												{
													me.$refs.historyTable.data = data.data
												}
											}
										});
										console.log(`每页 ${val} 条`);
									},
									handleCurrentChange:function(val) {
										pageNo = val;
										var url0= backend.dashboardService + '/api/warnrulehistory/?pageNo='+pageNo+'&pageSize='+pageSize;
										if(condition == 1){
											var name = model0.name;
											var type = model0.type;
											url0 += "&name="+name+"&type="+type;
											if(model0.timeRange[0] != null && model0.timeRange[0] != '')
											{
												var startTime = model0.timeRange[0].getTime();
												url0 += "&startTime="+startTime;
											}
											if(model0.timeRange[1] != null && model0.timeRange[1] != '')
											{
												var endTime = model0.timeRange[1].getTime();
												url0 += "&endTime="+endTime;
											}
											this.getTotal();
										}
										// this.$refs.historyTable.remoteData();
										var me = this;
										$.ajax({
											type: "GET",
											url: url0,
											success: function(data){
												if(data.code != -1)
												{
													me.$refs.historyTable.data = data.data
												}
											}
										});
										console.log(`当前页: ${val}`);
									},
               	closeDialog:function(){
               		 this.$refs.historyForm.resetFn();
               	},
               	 dateFormatter:function (date,fmt) { //author: meizz 
					    var o = {
					        "M+": date.getMonth() + 1, //月份 
					        "d+": date.getDate(), //日 
					        "h+": date.getHours(), //小时 
					        "m+": date.getMinutes(), //分 
					        "s+": date.getSeconds(), //秒 
					        "q+": Math.floor((date.getMonth() + 3) / 3), //季度 
					        "S": date.getMilliseconds() //毫秒 
					    };
					    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
					    for (var k in o)
					    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
					    return fmt;
					},
                   // 查询服务信息
                   queryFn: function () {
                       this.$refs.historyTable.remoteData();
                   },

                   // 展示修改面板
                   showDetail: function () {
                       var me = this;
                       var data = this.$refs.historyTable.selections;
                       if (data.length < 1) {
                           this.$message({
                               message: '请选择一条记录修改!'
                           });
                           return false;
                       }

                       this.form.visible = true;
                       this.$nextTick(function () {
                       	   		yufp.extend(me.$refs.historyForm.formModel, data[0]);
                       	   		me.$refs.historyForm.formModel["time"] = me.dateFormatter(new Date(data[0]["time"]),"yyyy-MM-dd hh:mm:ss")
                       	   		var warnRule = me.$refs.historyForm.formModel["warnRule"]
                       	   		me.$refs.ruleForm.formModel["name"]=warnRule["name"]
                       	   		me.$refs.ruleForm.formModel["type"]=  yufp.util.getFromReg("INDEX_TYPE",warnRule["type"])      
                       	   		me.$refs.ruleForm.formModel["source"]= warnRule["source"]         
                       	   		me.$refs.ruleForm.formModel["interval"]=  yufp.util.getFromReg("TIME_RULE",warnRule["interval"])      
                       	   		me.$refs.ruleForm.formModel["startTime"]= warnRule["startTime"] +" : 00"        
                       	   		me.$refs.ruleForm.formModel["endTime"]= warnRule["endTime"]  +" : 00"       
                       	   		var str ="连续"+warnRule["count"]+"次 "+yufp.util.getFromReg("MY_MAP",warnRule["ruleDesc"])  +
                               	(yufp.util.getFromReg("EXTREMUM",warnRule["extremum"]) == null ?"" : " "+yufp.util.getFromReg("EXTREMUM",warnRule["extremum"]) )
                               +" "+yufp.util.getFromReg("CONDITION",warnRule["condition"])+" "+warnRule["threshold"];
                               	if(warnRule["ruleDesc"] == "rt_stats")
                               	{
                               		str += "ms"
                               	}else{
                               		str +="%"
                               	}
                               	me.$refs.ruleForm.formModel["ruleDesc"] = str
                               	me.$refs.ruleForm.formModel["alertType"]=  yufp.util.getFromReg("ALERT_TYPE",warnRule["alertType"]) +" : " +warnRule["target"]
                       });
                   },
                   deleteRule: function() {
                   		var selections = this.$refs.historyTable.selections;
                        if(selections.length < 1){
                           this.$message({message:'请选择一条数据', type:'error'});
                           return;
                        }
                       var me = this;
                       var arr=[]
	                    for(var i=0;i<selections.length;i++){
	                        arr.push(selections[i].id);
	                    }
                       
                       this.$confirm('确认删除?', '提示', {
                           confirmButtonText: '确定',
                           cancelButtonText: '取消',
                           type: 'warning'
                       }).then(function(){
                           yufp.service.request({
                               url: backend.dashboardService + '/api/warnrulehistory/delete/' + arr.join(","),
                               method: 'GET',
                               callback: function (code, message, response) {
                                   if (code == '0') {
																		 me.getTotal();
                                       me.$message({
                                           message: '删除成功!'
                                       });
                                       me.form.visible = false;
                                       me.$refs.historyTable.remoteData();
                                   } else {
                                       me.$message({
                                           message: '保存失败!'
                                       });
                                   }
                               }
                           });
                       });
                   }
               }
           });
       };
   });
/**
 * 监控预警
 */
//define(function (require, exports) {
//  exports.ready = function (hashCode, data, cite) {
//      var vm = yufp.custom.vue({
//          el: cite.el,
//          data:function(){
//              var me = this;
//              return{
//                  configStyle:{
//                      height: yufp.frame.size().height -10 + 'px',
//                      overflow: 'auto',
//                      overflowX: 'hidden',
//                      width:'100%'
//                  }
//              }
//          }
//      });
//  };
//});