   /**
    * 预警规则配置
    */
   define(function (require, exports) {

       //page加载完成后调用ready方法
       exports.ready = function (hashCode, data, cite) {
           yufp.lookup.reg("ALERT_TYPE","TIME_RULE","EXTREMUM","CONDITION");
          var viewType="";
          var change1= true;
          var change2= true;
          var change3= true;
          var serviceList = [];
          var hostList = [];
           var thisRouter = this.Router;
           //创建virtual filter model
           var vm = yufp.custom.vue({
               el: cite.el,
               //以m_开头的参数为UI数据不作为业务数据，否则为业务数据
               data: function () {
                   var me = this;
                   return {
                   	value2:"",
                       ruleInfo: {
                           url: backend.dashboardService + '/api/warnrule/',
                           columns: [
                            { label: 'id',
                               prop: 'id',
                               hidden:true
                           },
                              { label: '规则名称',
                               prop: 'name'
                           }, {
                               label: '主机/服务',
                               prop: 'source',
                               formatter:function(row){
                               	if(row.type == "host")
                               	{
                               		return "监控主机: " + row.source
                               	}
                               	if(row.type == "service")
                               	{
                               		return "监控服务: " + row.source
                               	}
                               }
                           },{
                               label: '监控时段',
//                             width: 120,
                                formatter:function(row){
                                	return row.startTime+":00" +" - "+ row.endTime +":00"
                                }
                           },{
                               label: '检查频率',
                               prop: 'interval',
//                             width: 120,
                               dataCode: "TIME_RULE"
                           }, {
                               label: '预警方式',
                               prop: 'alertType',
                                formatter:function(row){
                                	return yufp.util.getFromReg("ALERT_TYPE",row.alertType)+": "+row.target
                                }
                           },{
                               label: '预警条件',
                               prop: '',
                               formatter:function(row){
                               	var str = yufp.util.getFromReg("MY_MAP",row.ruleDesc)  +
                               	(yufp.util.getFromReg("EXTREMUM",row.extremum) == null ?"" : " "+yufp.util.getFromReg("EXTREMUM",row.extremum) )
                               	+" "+ yufp.util.getFromReg("CONDITION",row.condition)
                               	+" " + row.threshold;
                               	if(row.ruleDesc == "rt_stats")
                               	{
                               		return str +"ms"
                               	}else{
                               		return str +"%"
                               	}
                               }
                           },{
                               label: '阈值超越次数',
                               prop: 'count',
                               width:100
                           }]
                       },
                       form: {
                           visible: false,
                           disable: false,
                           fields: [{
                               columnCount: 2,
                               fields: [
                               {
                                   field: 'name',
                                   label: '规则名称',
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },{
                                   field: 'type',
                                   label: '预警类型',
                                   type: "select",
                                   change:function (val) {
                                   	if(!change1){
									   	me.$refs.ruleForm.formModel["ruleDesc"]="";
									    me.$refs.ruleForm.formModel["source"]="";
									    }
                                   	change1 = false;
                                   	
                                   	
                                    var sourceField = me.$refs.ruleForm.groupFields[0].fields[2];
								    var rulDescField = me.$refs.ruleForm.groupFields[0].fields[4];
								    if(val == "host")
                                	{
                                	 		sourceField.label="主机选择";
			                    			sourceField.options = hostList;
                                			rulDescField.options=[{key: "cpu", value: "cpu使用率"}, {key: "disk-used", value: "硬盘使用率"}, {key: "memory", value: "内存使用率"}]
                                	}else{
										   sourceField.label="服务选择"
										   sourceField.options = serviceList;
                                		    rulDescField.options=[{key: "rt_stats", value: " 响应时间"} ]
                                	}
                                   	
                                   	
                                   },
                                    options: [
                                    {key: "host", value: "主机"},
                                    {key: "service", value: "服务"},
                                ],
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },{
                                   field: 'source',
                                   label: '资源选择',
                                   type: "select",
                                   options:[],
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },{
                                   field: 'interval',
                                   label: '时间间隔',
                                   type: "select",
                                   dataCode: "TIME_RULE",
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },
                               
                               {
                                   field: 'ruleDesc',
                                   label: '规则描述',
                                   type: "select",
                                    options: [],
                                    change:function (val) {
                                    	if(!change2){
                                    		me.$refs.ruleForm.formModel["threshold"]="";
                                    	}
                                    	change2=false;
                                    	var field = me.$refs.ruleForm.groupFields[1].fields[2];
                                     if(val == "cpu" || val=="disk-used" || val=="memory" ){
                                     	me.$refs.ruleForm.switch('extremum', 'hidden', true);
                                     		me.$refs.ruleForm.groupFields[1].fields[0].rules[0] ={ required: false }
					                   	  field.label="阈值(%)"
					                   	  	field.rules[1] = {validator:yufp.validator.percent}
				                   	  } if(val == "rt_stats"){
				                   	  	me.$refs.ruleForm.switch('extremum', 'hidden', false);
				                   	  	me.$refs.ruleForm.groupFields[1].fields[0].rules[0] ={ required: true, message: '必填项', trigger: 'blur' }
				                   	  	field.label="阈值(ms)"
				                   	  	field.rules[1] = {validator:yufp.validator.gtZore};
					                   	me.$refs.ruleForm.rebuildFn();
				                   	  }
									},
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               }
                               ,{
                                   field: 'count',
                                   label: '阈值超越次数',
                                    rules: [{required: true,message: '必填项'},{validator:yufp.validator.naturalNum}]
                               }]
                           },
                           {
                               columnCount: 3,
                               fields: [ {
                                   field: 'extremum',
                                   type: "select",
                                   label: '极值',
                                   dataCode: "EXTREMUM",
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },{
                                   field: 'condition',
                                   type: "select",
                                   label: '条件',
                                   dataCode: "CONDITION",
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },{
                                   field: 'threshold',
                                   label: '阈值',
                                   rules: [{
                                       required: true,
                                       message: '必填项'
                                   }]
                               }]
                           
                           
                           	
                           	
                           	
                           }
                           ,
                           {
                               columnCount: 2,
                               fields: [
                               {
                                   field: 'startTime',
                                   label: '开始时间',
                                   type: 'time',
                                   pickerOptions:{start: '00:00', step: '01:00',end: '23:00'},
                                    rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }],
                                   change:function(val){
                                   	me.$refs.ruleForm.groupFields[2].fields[1].pickerOptions={start: '01:00', step: '01:00',end: '24:00',minTime:val}
                                   }
                               },
                                {
                                   field: 'endTime',
                                   label: '结束时间',
									type: 'time',
                                   pickerOptions:{start: '01:00', step: '01:00',end: '24:00'},
                                    rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }],
                                   change:function(val){
                                   	me.$refs.ruleForm.groupFields[2].fields[0].pickerOptions={start: '00:00', step: '01:00',end: '23:00',maxTime:val}
                                   }
                               },{
                                   field: 'alertType',
                                   label: '预警方式',
                                   type: "select",
                                   dataCode: "ALERT_TYPE",
                                   change:function(val){
                                   	if(!change3){
                                   		me.$refs.ruleForm.formModel["target"]="";
                                   	}
                                   	change3= false;
                                   	var field = me.$refs.ruleForm.groupFields[2].fields[3];
                                   	 if(val == "EMAIL"){
				                   	  	field.label="邮箱"
				                   	  	field.rules[1] = {validator:yufp.validator.email}
				                   	  }
				                   	  if(val == "MESSAGE"){
				                   	  field.label="手机号";
				                   	  	field.rules[1] = {validator:yufp.validator.mobile}
				                   	  }
				                   	   if(val == "WECHAT"){
				                   	  	field.label="微信号";
				                   	  	field.rules[1] = {validator:yufp.validator.noValidator};
				                   	  }
                                   },
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               },
                               {
                                   field: 'target',
                                   label: '邮箱',
                                   rules: [{
                                       required: true,
                                       message: '必填项',
                                       trigger: 'blur'
                                   }]
                               }]
                           
                           }],
                           buttons: [{
                               label: '重置',
                               type: 'primary',
                               icon: "yx-undo",
                               click: function (model) {
                                   me.$refs.ruleForm.resetFn();
                               }
                           }, {
                               label: '保存',
                               type: 'primary',
                               icon: "check",
                               hidden: false,
                               op: 'submit',
                               click: function (model, valid) {
                                   if (valid) {
                                       me.saveRule(model);
                                   }

                               }
                           }]
                       }
                   };
               },
              created(){
              	this.loadSourceList();
            },
               methods: {
               	closeDialog:function(){
               		 this.$refs.ruleForm.resetFn();
               	},
               	loadSourceList: function(){
               		var me = this;
                    	yufp.service.request({
	                        url: "/api/elasticsearchMetrics/nodesMetrics?intervalMinutes=1&intervalType=d",
	                        methods: "get",
	                        callback: function (code, message, response) {
	                            if (response != null ) {
	                            	var data0 = response.aggregations['service-nodes'].buckets;
				                    for(var i=0; i < data0.length; i++){
				                        hostList[i] ={
				                            key: data0[i].key,
				                            value: data0[i].key
				                        };
				                    }
	                            } else {
	                                this.$message("请求主机信息失败，请重试！");
                                }
	                        }
	                    })
                    
                   
                    	yufp.service.request({
	                        url: "/api/elasticsearchMetrics/APMMetrics?intervalMinutes=1&intervalType=d",
	                        methods: "get",
	                        callback: function (code, message, response) {
	                            if (response != null ) {
	                            	var data0 = response.aggregations['apm-service'].buckets;
				                    for(var i=0; i < data0.length; i++){
				                        serviceList[i] ={
				                            key: data0[i].key,
				                            value: data0[i].key
				                        };
				                    }
	                            } else {
                                    this.$message("请求服务信息失败，请重试！");
                                }
	                        }
	                    })
                    
                        
                },
                   // 查询服务信息
                   queryFn: function () {
                       this.$refs.ruleTable.remoteData();
                   },

                   //展示新增面板
                   showAddFn: function () {
                   	   viewType="ADD";
                       this.form.disable = false;
                       this.form.visible = true;
                       this.$refs.ruleTable.clearSelection();
                       this.$nextTick(function () {
                           this.$refs.ruleForm.resetFn();
                       });
                   },
                   // 展示修改面板
                   showEditFn: function () {
                   	change1=true;
                   	change2=true;
                   	change3= true;
                   	   viewType="UPDATE";
                       var me = this;
                       var data = this.$refs.ruleTable.selections;
                       if (data.length < 1) {
                           this.$message({
                               message: '请选择一条记录修改!'
                           });
                           return false;
                       }

                       this.form.visible = true;
                       this.$nextTick(function () {
//                     	   setTimeout(function(){
                       	   		yufp.extend(me.$refs.ruleForm.formModel, data[0]);
	                           me.$refs.ruleForm.formModel.startTime = data[0].startTime+":00";
	                           me.$refs.ruleForm.formModel.endTime = data[0].endTime+":00";
//                     	   },0);
                       });
                   },

                   // 保存服务
                   saveRule: function (model) {
                       var me = this;
                       var data = model;
                       var sH = model.startTime.split(":")[0];
                       var eH = model.endTime.split(":")[0];
                       data.startTime = sH;
                       data.endTime = eH;
                       
                       var url0 = backend.dashboardService + '/api/warnrule/';
                       if(viewType == "ADD")
                       {
                       	  url0 += 'add';
                       }
                       if(viewType == "UPDATE")
                       {
                       	  url0 += 'update';
                       }
                      
                       
                       yufp.service.request({
                           url: url0,
                           method: "POST",
                           data: data,
                           callback: function (code, message, response) {
                               if (code == '0') {
                                   me.$message({
                                       message: '保存成功!'
                                   });
                                   me.form.visible = false;
                                   me.$refs.ruleTable.remoteData();
                               } else {
                                   me.$message({
                                       message: '保存失败!'
                                   });
                               }

                           }
                       });
                       me.$refs.ruleForm.resetFn();
                   },
                   deleteRule: function() {
                       var selections = this.$refs.ruleTable.selections;
                       if(selections.length != 1){
                           this.$message({message:'请选择一条数据', type:'error'});
                           return;
                       }
                       var me = this;
                       var arr=[]
	                    for(var i=0;i<selections.length;i++){
	                        arr.push(selections[i].id);
	                    }

                       this.$confirm('确认删除?', '提示', {
                           confirmButtonText: '确定',
                           cancelButtonText: '取消',
                           type: 'warning'
                       }).then(function(){
                           yufp.service.request({
                               url: backend.dashboardService + '/api/warnrule/delete/'+ arr.join(","),
                               method: 'get',
                               data: data,
                               callback: function (code, message, response) {
                                   if (code == '0') {
                                       me.$message({
                                           message: '删除成功!'
                                       });
                                       me.form.visible = false;
                                       me.$refs.ruleTable.remoteData();
                                   } else {
                                       me.$message({
                                           message: '保存失败!'
                                       });
                                   }
                               }
                           });
                       });
                   }
               }
           });
       };
   });
/**
 * 监控预警
 */
//define(function (require, exports) {
//  exports.ready = function (hashCode, data, cite) {
//      var vm = yufp.custom.vue({
//          el: cite.el,
//          data:function(){
//              var me = this;
//              return{
//                  configStyle:{
//                      height: yufp.frame.size().height -10 + 'px',
//                      overflow: 'auto',
//                      overflowX: 'hidden',
//                      width:'100%'
//                  }
//              }
//          }
//      });
//  };
//});