/**
 * Created by danyb1 on 2018/6/25.
 */
define([
    './custom/widgets/js/YufpDemoSelector.js',
    './libs/js-xlsx/xlsx.full.min.js'
], function (require, exports) {

    //page加载完成后调用ready方法
    exports.ready = function (hashCode, data, cite) {

        var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var _this = this;
                return {
                    businessDomainMap: [],
                    clusterMap: [],
                    baseParams: {
                        condition: {
                            userId: 'admin'
                        }
                    },
                    tableColumns: [
                        {label: 'id', prop: 'id', hidden: true},
                        {label: '账号', prop: 'userId'},
                        {label: '用户姓名', prop: 'userName'},
                        {label: '密码', prop: 'password', hidden: true},
                        // {label: '所属业务域', prop: 'businessDomains',
                        //     formatter: function(row, column, cellValue){
                        //         if(cellValue && cellValue.length) {
                        //             var result = "";
                        //             // 把业务域编码翻译为业务域名，返回给table
                        //             for(i=0; i<cellValue.length; i++) {
                        //                 result += _this.businessDomainMap[cellValue[i]] + "    ";
                        //             }
                        //
                        //             return result;
                        //         } else {
                        //             return '';
                        //         }
                        //
                        //     }
                        // },
                        // {label: '业务域角色', prop: 'businessRole', 'dataCode': 'BUSINESS_ROLE'},
                        {
                            label: '所属集群', prop: 'clusters', formatter: function (row, column, cellValue) {
                                if (cellValue && cellValue.length) {
                                    var result = "";
                                    // 把集群编码翻译为集群名，返回给table
                                    for (i = 0; i < cellValue.length; i++) {
                                        result += _this.clusterMap[cellValue[i]] + " ";
                                    }

                                    return result;
                                } else {
                                    return '';
                                }

                            }
                        }
                    ],
                    updateFields: [{
                        columnCount: 2,
                        fields: [
                            {
                                field: 'userId', label: '账号', rules: [
                                    {required: true, message: '必填项', trigger: 'blur'}
                                ]
                            }, {
                                field: 'userName', label: '用户姓名', rules: [
                                    {required: true, message: '必填项', trigger: 'blur'}
                                ]
                            },

                            {
                                field: 'password',
                                label: '密码',
                                type: 'password',
                                rules: [{
                                    required: true, message: '必填项', trigger: 'blur'
                                }]
                            },
                            // {
                            //     field: 'businessDomains',
                            //     label: '所属业务域',
                            //     type: 'select',
                            //     dataCode: 'BUSINESS_DOMAIN',
                            //     multiple: true
                            // },
                            // {
                            //     field: 'businessRole',
                            //     label: '业务域角色',
                            //     type: 'select',
                            //     dataCode: 'BUSINESS_ROLE'
                            // },
                            {
                                field: 'clusters',
                                label: '所属集群',
                                type: 'select',
                                dataCode: 'CLUSTER',
                                multiple: true
                            }
                        ]
                    }],
                    updateButtons: [
                        {
                            label: '取消', type: 'primary', icon: "yx-undo2", hidden: false, click: function (model) {
                                _this.dialogVisible = false;
                            }
                        },
                        {
                            label: '保存', type: 'primary', icon: "check", hidden: false, click: function (model) {
                                var validate = false;
                                _this.$refs.reform.validate(function (valid) {
                                    validate = valid;
                                });
                                if (!validate) {
                                    return;
                                }

                                var url0 = "/api/user/";

                                yufp.service.request({
                                    method: 'POST',
                                    url: url0,
                                    data: model,
                                    callback: function (code, message, response) {
                                        if (code == 0) {
                                            _this.$refs.reftable.remoteData();
                                            _this.$message('操作成功');
                                            _this.dialogVisible = false;
                                        }
                                    }
                                });
                            }
                        }
                    ],
                    height: yufp.frame.size().height - 103,
                    dialogVisible: false,
                    formDisabled: false,
                    viewType: 'DETAIL',
                    viewTitle: yufp.lookup.find('CRUD_TYPE', false)
                }
            },
            created() {
                //this.loadBusinessDomain();
                this.loadCluster();
            },
            methods: {
                loadCluster: function () {
                    var _this = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/cluster/list",
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                var data = response.data;
                                var list = [];
                                for (var i = 0, j = 0; i < data.length; i++) {
                                    list[j] = {
                                        key: data[i].id,
                                        value: data[i].clusterName
                                    };
                                    _this.clusterMap[data[i].id] = data[i].clusterName;
                                    j++;
                                }
                                yufp.lookup.lookupMgr["CLUSTER"] = list;
                            }
                        }
                    })
                },
                loadBusinessDomain: function () {
                    var _this = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/businessdomain/list",
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                var data = response.data;
                                var list = [];
                                for (var i = 0, j = 0; i < data.length; i++) {
                                    list[j] = {
                                        key: data[i].id,
                                        value: data[i].name
                                    };
                                    _this.businessDomainMap[data[i].id] = data[i].name;
                                    j++;
                                }
                                yufp.lookup.lookupMgr["BUSINESS_DOMAIN"] = list;
                            }
                        }
                    })
                },
                /**
                 * @param viewType 表单类型
                 * @param editable 可编辑,默认false
                 */
                switchStatus: function (viewType, editable) {
                    var _this = this;
                    _this.viewType = viewType;
                    //_this.updateButtons[0].hidden = !editable;
                    _this.updateButtons[1].hidden = !editable;
                    _this.formDisabled = !editable;
                    _this.dialogVisible = true;
                },
                addFn: function () {
                    var _this = this;
                    _this.switchStatus('ADD', true);
                    _this.$nextTick(function () {
                        _this.$refs.reform.resetFn();
                    });
                },
                modifyFn: function () {
                    if (this.$refs.reftable.selections.length != 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    this.switchStatus('EDIT', true);
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.reform.formModel, this.$refs.reftable.selections[0]);
                    });
                },
                infoFn: function () {
                    if (this.$refs.reftable.selections.length != 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    this.switchStatus('DETAIL', false);
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.reform.formModel, this.$refs.reftable.selections[0]);
                    });
                },
                deleteFn: function () {
                    var _this = this;
                    var selections = _this.$refs.reftable.selections;
                    if (selections.length < 1) {
                        _this.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    var len = selections.length, arr = [];
                    for (var i = 0; i < len; i++) {
                        arr.push(selections[i].id);
                    }
                    _this.$confirm('确认删除记录?', '提示', {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function () {
                        yufp.service.request({
                            method: 'GET',
                            url: "/api/user/delete/" + arr.join(','),
                            callback: function (code, message, response) {
                                if (code == 0) {
                                    _this.$refs.reftable.remoteData();
                                    _this.$message('操作成功');
                                }
                            }
                        });


                    }).catch(function () {
                        return;
                    });

                }
            }
        });
    };

});