/**
 * 服务限流
 */
define( function(require, exports) {
    exports.ready = function(hashCode, data, cite){
        yufp.lookup.reg("DATA_STS,LIMIT_STATE");
        var vm = yufp.custom.vue({
            el: cite.el,
            data: function(){
                var me = this;
                var queryString = yufp.sessionStorage.get("currentCluster") ? ('applist/?cluster=' + yufp.sessionStorage.get("currentCluster")) : '';
                return {
                    applicationsUrl:backend.dashboardService+'/api/instancemanager/' + queryString,
                    getLimitArgsUrl:backend.dashboardService+'/api/servicelimiter/getLimitArgs',
                    height: yufp.frame.size().height - 92 - 10,
                    name:'',
                    tableColumns: [
                        {label: '服务名称', prop: 'name',formatter:function(row){
                        	if(row.name=="GATEWAY"){
                        		if(me.$refs.applicationsTable.data){
                        			var data_tmp=me.$refs.applicationsTable.data;
                        			var data_new=[];
                        			for(var i=0;i<data_tmp.length;i++){
                        				if(data_tmp[i].name=="GATEWAY"){
                        				}else{
                        					data_new.push(data_tmp[i]);
                        				}
                        			}
                        			me.$refs.applicationsTable.data=data_new;
                        		}
                        		return row.name; 
                        	}else{
                        		return row.name;
                        	}
                        	
                           }
                       }
                    ],
                    option:[],
                    
                    
                    tableColumns2:[],
                    parameterUrl:backend.dashboardService + '/api/servicelimiter/paramsinfo',
                    dialogVisible:false,
                    takeEffect_v:true,
                    invalid_v:true,
                    edit_v:true,
                    dialogVisible1:false,
                    dialogVisible2:false,
                    this_limitMode:'',
                    conftitle:'',
                    pathsData:{},
                    parameterTableColumns:[
                        {label:'限速方式',prop:'limitMode', type: 'select', dataCode: 'LIMIT_STATE'},
                        {label:'限速间隔周期(单位秒)',prop:'intervalPeriod'},
                        {label:'限速值',prop:'limitValue'},
                        {label:'状态',prop:'limitState',
                        	template : function() {
								return '<template scope="scope">\
                <el-tag :type="scope.row.limitState === \'A\' ? \'success\' : \'danger\'">{{ scope.row.limitState === \'A\' ? \'生效\' : \'失效\' }}</el-tag>\
            </template>';
							}
                        },
                        {label:'详细配置',prop:'limitState',fixed : 'right',
							template : function() {
								return '<template scope="scope">\
                    <el-button size="small" @click="_$event(\'custom-row-op\', scope)" :style="scope.row.limitMode!=\'QPS\'&&scope.row.limitMode!=\'TPS\'&& scope.row.limitState === \'A\' ? \'\' : \'display:none\'">配置</el-button>\
                </template>';
							}
                        }
                    ],
                    paramFields:[
                        {
                            columnCount: 2,
                            fields:[
                                {
                                    field: 'limitMode', label: '限速方式', disabled:true, type: 'select', dataCode: 'LIMIT_STATE'
                                },
                                {
                                    field: 'intervalPeriod', label: '限速间隔周期(单位秒)',rules:[
                                        {required: true, message: '必填项', trigger: 'blur'},
                                        {validator:yufp.validator.number,message:'请输入数字'}
                                    ]
                                },{
                                    field: 'limitValue', label: '限速值',rules:[
                                        {required: true, message: '必填项', trigger: 'blur'},
                                        {validator:yufp.validator.number,message:'请输入数字'}
                                    ]
                                }
                            ]
                        }
                    ],
                    paramFields2:[
                        {
                            columnCount: 1,
                            fields:[
                                
                            ]
                        }
                    ],
                    formButtons:[
                        {
                            label: '取消', type: 'primary', icon: "yx-undo2", hidden: false, click: function (model) {
                            me.dialogVisible = false;
                        }
                        },
                        {
                            label: '保存',type: 'primary',icon: "check",hidden: false,op: 'submit',click: function (model,valid) {
                                if(valid){
                                    yufp.service.request({
                                        method: 'POST',
                                        url: backend.dashboardService+'/api/servicelimiter/updateparams/'+me.name,
                                        data: model,
                                        callback: function (code, message, response) {
                                            if (response.code===0) {
                                                me.$message('修改成功');
                                                me.dialogVisible = false;
                                                me.queryParamFn();
                                            }
                                        }
                                    });
                                }else {
                                    me.$message({message: '请检查输入项是否合法', type: 'warning'});
                                    return false;
                                }
                        }
                        }
                    ],
                    formButtons2:[
                        {
                            label: '取消', type: 'primary', icon: "yx-undo2", hidden: false, click: function (model) {
                            me.dialogVisible2 = false;
                        }
                        },
                        {
                            label: '保存',type: 'primary',icon: "check",hidden: false,op: 'submit',click: function (model,valid) {
                                if(valid){
                                	if(me.this_limitMode==="IP"){
                                		 var reg = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/
                                		 if(reg.test(model.value)==false){
                                			 me.$message({message: '请检查输入的IP是否合法', type: 'warning'});
                                			 return false;
                                		 }
                                	}
                                	
                                	
                                	model.name=me.name;
                                	model.limitMode=me.this_limitMode;
                                    yufp.service.request({
                                        method: 'POST',
                                        url: backend.dashboardService+'/api/servicelimiter/addLimitArgs',
                                        data: model,
                                        callback: function (code, message, response) {
                                            if (response.code===0) {
                                                me.$message('保存成功');
                                                me.dialogVisible2 = false;
                                                me.queryParamFn2();
                                            }
                                        }
                                    });
                                }else {
                                    me.$message({message: '请检查输入项是否合法', type: 'warning'});
                                    return false;
                                }
                        }
                        }
                    ]
                }
            },
            mounted: function () {
                yufp.lookup.lookupMgr["URL_TAGS"] = [];
            },
            methods: {
                //生效
                takeEffect:function(){
                    if (this.$refs.parameterTable.selections.length < 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'})
                        return;
                    }
                    var me = this;
                    var model=me.$refs.parameterTable.selections[0];
                    model.limitState="A";
                    model.limitArgs=null;
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService+'/api/servicelimiter/updateparams/'+me.name,
                        data: model,
                        callback: function (code, message, response) {
                            if (response.code===0) {
                                me.$message('操作成功');
                                me.queryParamFn();
                                me.rowClickFn1(model);
                            }
                        }
                    });
                },
                //失效
                invalid:function(){
                    if (this.$refs.parameterTable.selections.length < 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'})
                        return;
                    }
                    var me = this;
                    var model=me.$refs.parameterTable.selections[0];
                    model.limitState="I";
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService+'/api/servicelimiter/updateparams/'+me.name,
                        data: model,
                        callback: function (code, message, response) {
                            if (response.code===0) {
                                me.$message('操作成功');
                                me.queryParamFn();
                            }
                            me.rowClickFn1(model);
                        }
                    });
                },
                rowClickFn:function(row){
                    this.name = row.name;
                    this.queryParamFn();
                    this.takeEffect_v=true;
                	this.invalid_v=true;
                	this.edit_v=true;
                },
                queryParamFn:function(){
                    var me = this;
                    var params={};
                    params.name=me.name;
                    me.$refs.parameterTable.remoteData(params);
                },
                modifyFn:function(){
                    if (this.$refs.parameterTable.selections.length < 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'})
                        return;
                    }
                    this.dialogVisible = true;
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.paramForm.formModel, this.$refs.parameterTable.selections[0]);
                    });
                },
                rowClickFn1: function (row) {
                	this.edit_v=false;
                    if(row.limitState=="A"){
                    	this.takeEffect_v=true;
                    	this.invalid_v=false;
                    }else{
                    	this.takeEffect_v=false;
                    	this.invalid_v=true;
                    }
                },
                reflushgateway:function(){
                	 var me = this;
                	 const loading = me.$loading({
                         lock: false,
                         fullscreen:false,
                         text: '数据同步中，请稍后...',
                         spinner: 'el-icon-loading'
                       });
                       setTimeout(() => {
                         loading.close();
                       }, 20000);
                	 
                	 
                	
                	yufp.service.request({
                        method: 'get',
                        url: backend.dashboardService+'/api/servicelimiter/reflushConf',
                        data: null,
                        callback: function (code, message, response) {
                        	loading.close();
                            if (response.code===0) {
                                me.$message('刷新成功');
                            }else{
                            	me.$message({message: response.message, type: 'warning'});
                            }
                        }
                    });
                },
                customRowOp : function(scope) {
                	if("IP"===scope.row.limitMode){
                		this.conftitle="受控IP地址配置";
                		this.this_limitMode="IP";
                		this.tableColumns2= [
                            {label: '受控IP地址', prop: 'value'}
                            ];
                	}else if("LOGIN"===scope.row.limitMode){
                		this.conftitle="受控登录用户配置";
                		this.this_limitMode="LOGIN";
                		this.tableColumns2= [
                            {label: '受控登录用户', prop: 'value'}
                            ];
                	}else if("URI"===scope.row.limitMode){
                		this.conftitle="受控URI配置"
                		this.this_limitMode="URI";
                		this.tableColumns2= [
                            {label: '受控URI地址', prop: 'value'}
                            ];
                		this.queryswaggerAPIFn();
                	}
                	this.dialogVisible1=true;
                	this.queryParamFn2();
                	
                	
                },
                //读取swaggerAPI文档
                queryswaggerAPIFn: function () {
                    var me = this;
                    yufp.lookup.lookupMgr["URL_TAGS"]=[];
                    me.option.splice(0,me.option.length);
                    var param = {
                    	"name":me.name
                    }
                    //发起请求
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService+'/api/gatewayapi/swaggerapi/info',
                        data: param,
                        callback: function (code, message, response) {
                        	if (response.code===0) {
                        		yufp.lookup.lookupMgr["URL_TAGS"] = response.data["tagsData"];
                        		me.pathsData=response.data["pathsData"];
                        		me.$nextTick(function () {
                                    yufp.extend(me.$refs.paramForm2.formModel, {"value":"","tags":""});
                                });
                        	}else{
                        		me.$message({message: response.message, type: 'warning'});
                        	}
                            
                        }
                    });
                },
                addConf:function(){
                	this.dialogVisible2=true;
                	var paramFields2_label="";
                	var me=this;
                	this.paramFields2.splice(0,me.paramFields2.length);
                	if(this.this_limitMode=="URI"){
                		paramFields2_label="受控URI";
                		this.paramFields2.push(
                            {
                                columnCount: 1,
                                fields:[
                                	{
                                        field: 'tags', label:"模块",type: 'select',dataCode:"URL_TAGS" ,change:function(val){
                                        	if(me.pathsData[val]){
                                        		var data_=me.pathsData[val];
                                        		me.option.splice(0,me.option.length);
                                        		for(var i=0;i<data_.length;i++){
                                        			me.option.push(data_[i]);
                                        		}
                                        		me.$nextTick(function () {
                                                    yufp.extend(me.$refs.paramForm2.formModel, {"value":""});
                                                });
                                        	}
                                        },rules: [
                                            { trigger: 'change'}
                                            ]
                                    },
                                    {
                                        field: 'value', label: paramFields2_label,type: 'select',options:me.option ,rules:[
                                            {required: true, message: '必填项', trigger: 'blur'}
                                        ]
                                    }
                                ]
                            }
                        );
                	}else if(this.this_limitMode=="LOGIN"){
                		paramFields2_label="受控登录用户";
                		this.paramFields2.push(
                            {
                                columnCount: 1,
                                fields:[
                                	{
                                        field: 'value', label: paramFields2_label,rules:[
                                            {required: true, message: '必填项', trigger: 'blur'}
                                        ]
                                    }
                                ]
                            }
                        );
                	}else if(this.this_limitMode=="IP"){
                		paramFields2_label="受控IP地址";
                		this.paramFields2.push(
                            {
                                columnCount: 1,
                                fields:[
                                	{
                                        field: 'value', label: paramFields2_label,rules:[
                                            {required: true, message: '必填项', trigger: 'blur'}
                                        ]
                                    }
                                ]
                            }
                        );
                	}else{
                		
                	}
                	
                	
                	this.$nextTick(function () {
                        yufp.extend(this.$refs.paramForm2.formModel, {"value":""});
                    });
                },
                delConf:function(){
                	if (this.$refs.applicationsTable2.selections.length < 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'})
                        return;
                    }
                    var me = this;
                    var model=me.$refs.applicationsTable2.selections[0];
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService+'/api/servicelimiter/delLimitArgs',
                        data: {value:model.value,name:me.name,limitMode:me.this_limitMode},
                        callback: function (code, message, response) {
                            if (response.code===0) {
                                me.$message('操作成功');
                                me.queryParamFn2();
                            }
                        }
                    });
                },
                queryParamFn2:function(){
                    var me = this;
                    /**
                    yufp.service.request({
                        method:'GET',
                        url:me.getLimitArgsUrl,
                        data:{
                            name:me.name,limitMode:me.this_limitMode
                        },
                        callback:function(code,message,response){
                            if(response.code===0){
                                var parameters = response.data;
                                me.$refs.applicationsTable2.data = parameters;
                                me.$refs.applicationsTable2.total = response.total;
                            }
                        }
                    });
					**/
                    var params={};
                    params.name=me.name;
                    params.limitMode=me.this_limitMode;
                    this.$nextTick(function () {
                    	me.$refs.applicationsTable2.remoteData(params);
                    });
                }
                
            }
        })
    }
});