/**
 * Created by liaoxd on 2017/12/17.
 */
define([
    './custom/widgets/js/yufpOrgTree.js'
], function (require, exports) {

    //page加载完成后调用ready方法
    exports.ready = function (hashCode, data, cite) {
        // 活跃应用列表
        var serviceInfoList=[];
        var thisRouter = this.Router;
        yufp.lookup.reg("BUS_AREA");
        yufp.lookup.lookupMgr["SERVICE_NAME"] = [];

        yufp.service.request({
            url: backend.dashboardService + "/api/businessdomain/list",
            methods: "get",
            callback: function (code, message, response) {
                if (response != null && response.data != null) {
                    var data0 = response.data;
                    var list = [];
                    for (var i = 0, j = 0; i < data0.length; i++) {
                        list[j] = {
                            key: data0[i].id,
                            value: data0[i].name
                        };
                        j++
                    }
                    yufp.lookup.lookupMgr["BUSINESS_DOMAIN"] = list;

                    //创建virtual filter model
                    var vm = yufp.custom.vue({
                        el: cite.el,
                        //以m_开头的参数为UI数据不作为业务数据，否则为业务数据
                        data: function () {
                            var me = this;
                            // 业务域条件查询字符串拼接
                            var queryString = yufp.sessionStorage.get("currentCluster") ? ('/' + yufp.sessionStorage.get("currentCluster")) : '';
                            return {
                                queryFields: [
                                    { placeholder: '服务名', field: 'serviceName',type: 'input'},
                                    //{ placeholder: '业务域from数据字典', field: 'businessDomainfrom',type:'select',options: [{key:"S",value:"业务域1"},{key:"F",value:"业务域2"}]},
                                    { placeholder: '业务域', field: 'businessDomain',type:'select',dataCode: "BUSINESS_DOMAIN"},
                                    //{ placeholder: '业务域', field: 'businessDomain',type:'select',options: []},
                                    { placeholder: '负责团队', field: 'dutyTeam',type: 'input'}
                                ],
                                queryButtons:[
                                    {label:'搜索',op:'submit',type: 'primary', icon: "search",show: true, click: function (model, valid) {
                                            if (valid) {
                                                var param = {
                                                    condition: JSON.stringify(model)
                                                };
                                                me.$refs.servicesTable.remoteData(param);
                                            }
                                        }
                                    },
                                    {label: '重置', op: 'reset', type: 'primary', icon: 'yx-loop2', show: this.resetButton }
                                ],
                                gateWayUrl: "",
                                jvmConfig: "",
                                programConfig: "",
                                jvmArgs: [{id: "-Xms", visible: true, val: 100}, {id: "-Xmx", visible: true, val: 100}, {
                                    id: "-Xmn",
                                    visible: true,
                                    val: 200
                                }, {id: "-Xss", visible: true, val: 300}, {id: "-XX:NewSize", visible: true, val: 300}],
                                argsVisible: false,
                                restBtnVisible: true,
                                saveBtnVisible: true,
                                plusDisabled: false,
                                businessDomainMap: [],
                                clusterMap: [],
                                service: {
                                    url: backend.dashboardService + '/api/service/basic/info' + queryString,
                                    columns: [{
                                        label: '业务域',
                                        prop: 'businessDomain',
                                        formatter: function (row) {
                                            var str = null;
                                            if (row.businessDomain == null) {
                                                return "";
                                            } else {
                                                return me.businessDomainMap[row.businessDomain];
                                            }
                                        }

                                    }, {
                                        label: '所属集群',
                                        prop: 'clusters',
                                        formatter: function (row, column, cellValue) {
                                            if (cellValue && cellValue.length) {
                                                var result = "";
                                                // 把集群编码翻译为集群名，返回给table
                                                for (i = 0; i < cellValue.length; i++) {
                                                    if(me.clusterMap[cellValue[i]]) {
                                                        result += me.clusterMap[cellValue[i]] + " ";
                                                    }
                                                }

                                                return result;
                                            } else {
                                                return '';
                                            }
                                        }

                                    }, {
                                        label: '服务名称',
                                        prop: 'name',
                                        template: function () {
                                            return '<template scope="scope">' +
                                                '<a style="text-decoration:underline;cursor:pointer;" @click="_$event(\'show-detail\', scope)">{{scope.row.name}}</a>' +
                                                '</template>'
                                        }
                                    }, {
                                        label: '服务描述',
                                        prop: 'serviceDesc'
                                    }, {
                                        label: '依赖服务',
                                        prop: 'dependService',
                                        formatter: function (row) {
                                            var str = null;
                                            if (row.dependService == null) {
                                                return "";
                                            }
                                            for (var i = 0; i < row.dependService.length; i++) {
                                                if (str === null) {
                                                    str = "";
                                                } else {
                                                    str += ",";
                                                }
                                                str += row.dependService[i];
                                            }
                                            return str;
                                        }
                                    }, {
                                        label: '负责团队信息',
                                        prop: 'dutyTeam'
                                    }, {
                                        label: 'Client接口信息',
                                        prop: 'client',
                                        resizable: true,
                                        template: function () {
                                            return '<template scope="scope">\
                                    <a style="text-decoration:underline;cursor:pointer;"\
                                    @click="_$event(\'custom-row-click\', scope)">{{scope.row.name}}接口查看</a>\
                                </template>';//{{scope.row.serviceName}}不存在
                                        }
                                    },{
                                        label:'应用构建',
                                        prop:'buildFlag',
                                        template: function () {
                                            return '<template scope="scope">\
                                    <el-button v-if="scope.row.buildFlag == 0" size="small" type="primary" :loading="true">应用构建中</el-button>\
                                    <el-button v-if="scope.row.buildFlag == 1" size="small" type="primary" @click="_$event(\'custom-row-op\', scope)">构建成功</el-button>\
                                    <el-button v-if="scope.row.buildFlag == 2" size="small" type="danger" @click="_$event(\'custom-row-op\', scope)">构建失败</el-button>\
                                    <el-button v-if="scope.row.buildFlag == 3" size="small" type="warning" @click="_$event(\'custom-row-op\', scope)">构建不稳定</el-button>\
                                    </template>'

                                        }
                                    }]
                                },
                                busArea: {
                                    visible: false,
                                    url: backend.dashboardService + "/api/service/basic",
                                    columns: [{
                                        prop: "name",
                                        label: "业务领域名称"
                                    }],
                                    formVisible: false,
                                    fields: [{
                                        columnCount: 1,
                                        fields: [{
                                            field: "name",
                                            label: "业务领域名称"
                                        }]
                                    }],
                                    buttons: [{
                                        label: '重置',
                                        type: 'primary',
                                        icon: "yx-undo",
                                        click: function (model) {
                                            me.$refs.busAreaForm.resetFn();
                                        }
                                    }, {
                                        label: '保存',
                                        type: 'primary',
                                        icon: "check",
                                        hidden: false,
                                        op: 'submit',
                                        click: function (model, valid) {
                                            if (valid) {
                                                me.saveBusArea(model);
                                            }
                                        }
                                    }]
                                },
                                expandCollapseName: ['1'],
                                form: {
                                    visible: false,
                                    disable: false,
                                    fields: [
                                        {
                                            columnCount: 2,
                                            fields: [{
                                                field: 'name',
                                                label: '服务名称',
                                                rules: [{
                                                    required: true,
                                                    message: '必填项',
                                                    trigger: 'blur'
                                                }]
                                            }, {
                                                field: 'businessDomain',
                                                label: '业务域',
                                                type: "select",
                                                dataCode: "BUSINESS_DOMAIN",
                                                rules: [{
                                                    required: true,
                                                    message: '必填项',
                                                    trigger: 'blur'
                                                }]
                                            }, {
                                                field: 'clusters',
                                                label: '所属集群',
                                                type: "select",
                                                dataCode: "CLUSTER",
                                                multiple: true,
                                                rules: [{
                                                    required: true,
                                                    message: '必填项',
                                                    trigger: 'blur'
                                                }]
                                            }, {
                                                field: 'serviceDesc',
                                                label: '服务描述',
                                                rules: [{
                                                    required: true,
                                                    message: '必填项',
                                                    trigger: 'blur'
                                                }]
                                            }, {
                                                field: 'dutyTeam',
                                                label: '负责团队',
                                                rules: [{
                                                    required: true,
                                                    message: '必填项',
                                                    trigger: 'blur'
                                                }]
                                            }, {
                                                field: 'dependService',
                                                label: '依赖服务',
                                                type: "select",
                                                //dataCode: "SERVICE_NAME",
                                                options:[],
                                                multiple: true
                                            }, {
                                                field: 'jenkinsBuildName',
                                                label: 'Jenkins配置名称',
                                                placeholder:'请输入应用在Jenkins配置名称'
                                            }]
                                        }],
                                    buttons: [{
                                        label: '重置',
                                        type: 'primary',
                                        icon: "yx-undo",
                                        click: function (model) {
                                            me.$refs.serviceForm.resetFn();
                                        }
                                    }, {
                                        label: '保存',
                                        type: 'primary',
                                        icon: "check",
                                        hidden: false,
                                        op: 'submit',
                                        click: function (model, valid) {
                                            if (valid) {
                                                me.saveService(model);
                                            }

                                        }
                                    }]
                                },
                                version: {
                                	url: backend.dashboardService + '/api/service/basic/version/file/',
                                    columns: [
                                        //     {
                                        //     label: '序号',
                                        //     prop: 'version',
                                        // },
                                        {
                                            label: "文件名称",
                                            prop: "fileName",
                                            width: 500
                                        }, {
                                            label: '依赖JAR包',
                                            prop: 'jars',
                                            resizable: true,
                                            template: function () {
                                                return '<template scope="scope">\
                                        <a style="text-decoration:underline;cursor:pointer;" @click="_$event(\'jars-row-click\', scope)">查看</a>\
                                    </template>';
                                            }
                                        }]
                                },
                                jar: {
                                    visible: false,
                                    data: ''
                                },
                                upload: {
                                    visible: false,
                                    data: {
                                        version: "",
                                        name: "",
                                    },
                                    rules: {
                                        required: true,
                                        message: '必填项',
                                        trigger: 'blur'
                                    },
                                    fileList: [],
                                    action: yufp.service.getUrl({
                                        url: '/api/service/basic/uploadfile'
                                    }),
                                    headers: {
                                        'Authorization': 'Basic ' + yufp.service.getToken()
                                    }
                                },
                                //表单操作状态
                                viewType: 'DETAIL',
                                uploadShow: false,
                                //构建操作
                                jenkinsBuildName: '',
                                serviceName:'',
                                buildVisible: false,
                                step1: false,
                                step2: false,
                                buttons1: false,
                                buildNumber: '',
                                consoleInfo: {
                                    data: null
                                },
                                buildResult: {
                                    data: null
                                },
                                onBuilds:[],
                                resultStyle: {
                                    margin: '0 auto',
                                    width: 210 + 'px',
                                    marginTop: 80 + 'px',
                                    fontSize: 'medium',
                                    lineHeight: 25 + 'px',
                                    color: '#48576a'
                                },
                                buildDialog:{
                                    title:'构建信息',
                                    width:400+'px',
                                    height:300+'px'
                                }
                            };
                        },
                        created() {
                            this.loadCluster();
                            this.loadAppliciationManager();
                        },
                        mounted: function () {
                            this.loadBusinessDomain();
                            this.loadGateWayUrl();
                        },
                        methods: {
                            // 加载活跃应用
                            loadAppliciationManager:function(){
                                yufp.service.request({
                                    method:'GET',
                                    url:backend.dashboardService+'/api/instancemanager/',
                                    callback:function(code,messaage,response){
                                        if(response !=null && response.data !=null){
                                            serviceInfoList=response.data;
                                        }
                                    }
                                })
                            },
                            //数据加载后查询应用是否执行构建
                            loadedFn:function(data,total){
                                if(total>0){
                                    var me = this;
                                    yufp.service.request({
                                        method:'GET',
                                        url:backend.dashboardService+'/api/jenkins/getjenkinsinfo',
                                        callback:function(code,message,response){
                                            if(code==0&&response.code==0){
                                                me.onBuilds = [];
                                                var count = 0;
                                                for(var i in data){
                                                    if(response.data.length>0){
                                                        var responseData = response.data;
                                                        for(var j in responseData){
                                                            if(data[i].name == responseData[j].name){
                                                                me.$set(data[i],'buildFlag',responseData[j].buildFlag);
                                                                if(responseData[j].buildFlag=='0'){
                                                                    responseData[j].jenkinsBuildName = data[i].jenkinsBuildName;
                                                                    me.onBuilds.push(responseData[j]);
                                                                }
                                                                count++;
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    if(count==0){
                                                        me.$set(data[i],'buildFlag',-1);
                                                    }
                                                }
                                            }
                                            if(me.onBuilds.length>0){
                                                me.onBulidsInfo();
                                            }
                                        }
                                    });
                                }
                            },
                            //获取应用构建状态
                            onBulidsInfo:function(){
                                var me = this;
                                for(var k in me.onBuilds){
                                    yufp.service.request({
                                        method: 'GET',
                                        url: backend.dashboardService + '/api/jenkins/buliddetails',
                                        timeout: 3000000,
                                        data: {
                                            jenkinsBuildName: me.onBuilds[k].jenkinsBuildName,
                                            buildNumber: me.onBuilds[k].buildNumber,
                                            serviceName:me.onBuilds[k].name
                                        },
                                        callback: function (code, message, response) {
                                            if (code == 0 && response.code == 0) {
                                                var name = response.data.fullDisplayName.trim().split(/\s+/)[0];
                                                var serviceList = me.$refs.servicesTable.data;
                                                for(var m in serviceList){
                                                    if(serviceList[m].jenkinsBuildName == name){
                                                        if (response.data.buildResult == "SUCCESS") {
                                                            me.$set(serviceList[m],'buildFlag',1);
                                                        }else if (response.data.buildResult == "FAILURE"){
                                                            me.$set(serviceList[m],'buildFlag',2);
                                                        }else{
                                                            me.$set(serviceList[m],'buildFlag',3);
                                                        }
                                                        me.$set(serviceList[m],'buildNumber',response.data.buildNumber);
                                                    }
                                                }
                                            }
                                        }
                                    });
                                }
                            },
                            loadCluster: function () {
                                var _this = this;
                                yufp.service.request({
                                    url: backend.dashboardService + "/api/cluster/list",
                                    methods: "get",
                                    callback: function (code, message, response) {
                                        if (response != null && response.data != null) {
                                            var data = response.data;
                                            var list = [];
                                            for (var i = 0, j = 0; i < data.length; i++) {
                                                list[j] = {
                                                    key: data[i].id,
                                                    value: data[i].clusterName
                                                };
                                                _this.clusterMap[data[i].id] = data[i].clusterName;
                                                j++;
                                            }
                                            yufp.lookup.lookupMgr["CLUSTER"] = list;
                                        }
                                    }
                                })
                            },
                            loadGateWayUrl: function () {
                                var me = this;
                                yufp.service.request({
                                    url: backend.dashboardService + "/api/instancemanager/instancelist?name=" + backend.gateWayName,
                                    methods: "get",
                                    callback: function (code, message, response) {
                                        if (response != null && response.data != null) {
                                            if (response.data.length > 0) {
                                                var data0 = response.data[0];
                                                me.gateWayUrl = data0.url;
                                            }
                                        }
                                    }
                                })
                            },
                            loadBusinessDomain: function () {
                                var _this = this;
                                yufp.service.request({
                                    url: backend.dashboardService + "/api/businessdomain/list",
                                    methods: "get",
                                    callback: function (code, message, response) {
                                        if (response != null && response.data != null) {
                                            var data0 = response.data;
                                            var list = [];
                                            for (var i = 0, j = 0; i < data0.length; i++) {
                                                list[j] = {
                                                    key: data0[i].id,
                                                    value: data0[i].name
                                                };
                                                _this.businessDomainMap[data0[i].id] = data0[i].name;
                                                j++
                                            }
                                            yufp.lookup.lookupMgr["BUSINESS_DOMAIN"] = list;
                                        }
                                    }
                                })
                            },
                            // 查询服务信息
                            queryFn: function () {
                                this.$refs.servicesTable.remoteData();
                            },
                            // 查询版本信息
                            queryVersion: function (param) {
                                var me = this;
                                this.$nextTick(function () {
                                    me.$refs.versionTab.remoteData(param);
                                });
                            },
                            //查询业务领域信息
                            queryBusArea: function (param) {
                                var me = this;
                                this.$nextTick(function () {
                                    me.$refs.busAreaTab.remoteData(param);
                                });
                            },
                            //展示业务领域信息面板
                            showBusArea: function () {
                                this.busArea.visible = true;
                            },
                            // 保存业务领域
                            saveBusArea: function (model) {

                                yufp.service.request({
                                    url: backend.dashboardService + "/api/busArea/update",
                                    method: "post",
                                    data: model,
                                    callback: function (code, msg, res) {

                                    }
                                });
                            },
                            loadServiceList: function (name) {

                                var data = this.$refs.servicesTable.$data.data;

                                var list = [];

                                for (var i = 0, j = 0; i < data.length; i++) {
                                    if( name != data[i].name ){
                                        list[j] = {
                                            key: data[i].name,
                                            value: data[i].serviceDesc
                                        };
                                        j++
                                    }
                                }

                                yufp.lookup.lookupMgr["SERVICE_NAME"] = list;

                                return list;
                            },
                            //展示新增面板
                            showAddFn: function () {
                                //var me = this;
                                this.restBtnVisible = true;
                                this.saveBtnVisible = true;
                                this.plusDisabled = false;
                                this.jvmConfig = "";
                                this.programConfig = "";

                                var optionsList = this.loadServiceList();
                                this.form.fields[0].fields[5].options = optionsList;

                                this.form.buttons[0].hidden = false;
                                this.form.buttons[1].hidden = false;
                                for (var i = 0; i < this.form.fields[0].fields.length; i++) {
                                    this.form.fields[0].fields[i].readonly = false;
                                }
                                this.viewType = 'ADD';
                                this.form.disable = false;
                                this.form.visible = true;
                                this.$refs.servicesTable.clearSelection();
                                this.$nextTick(function () {
                                    this.$refs.serviceForm.resetFn();
                                    this.uploadShow = false;
                                });
                            },
                            //展示参数面板
                            showArgsFn: function () {
                                this.argsVisible = true;
                                for (var i = 0; i < this.jvmArgs.length; i++) {
                                    if (this.jvmConfig.indexOf(this.jvmArgs[i].id) == -1) {
                                        this.jvmArgs[i].visible = true;
                                    }
                                }
                            },
                            argsClick: function (event, index) {
                                var _self = event.currentTarget;
//              	this.jvmConfig+=$(_self).attr("id")+":"+$(_self).prev().children("input").val()+" "
//              	$(_self).parent().parent().css("display","none")
                                for (var i = 0; i < this.jvmArgs.length; i++) {
                                    if ($(_self).attr("id") == this.jvmArgs[i].id) {
                                        if (this.jvmConfig[this.jvmConfig.length - 1] != " ") {
                                            this.jvmConfig += " "
                                        }
                                        this.jvmConfig += this.jvmArgs[i].id + this.jvmArgs[i].val + "M "
                                        this.jvmArgs[i].visible = false;
                                    }
                                }
                            },
                            // 展示修改面板
                            showEditFn: function () {
                                var me = this;
                                this.restBtnVisible = true;
                                this.saveBtnVisible = true;
                                this.plusDisabled = false;
                                var data = this.$refs.servicesTable.selections;
                                if (data.length < 1) {
                                    this.$message({
                                        message: '请选择一条记录修改!'
                                    });
                                    return false;
                                }
                                if (data > 1) {
                                    vm.$message({
                                        message: '只能选择一条记录修改!'
                                    });
                                    return false;
                                }

                                var optionsList = this.loadServiceList(data[0].name);
                                this.form.fields[0].fields[5].options = optionsList;

                                this.version.url = backend.dashboardService + '/api/service/basic/version/file/' + data[0].name;
                                this.form.buttons[0].hidden = true;
                                this.form.buttons[1].hidden = false;
                                this.form.fields[0].fields[0].readonly = true;
                                this.form.disable = false;
                                this.viewType = "UPDATE";
                                this.form.visible = true;

                                if (data[0].dependService === null) {
                                    data[0].dependService = [];
                                }
                                this.$nextTick(function () {
                                    yufp.extend(me.$refs.serviceForm.formModel, data[0]);
                                    this.jvmConfig = data[0].jvmConfiguration;
                                    this.programConfig = data[0].programConfiguration;
                                    me.uploadShow = true;
                                });
                                var param = {
                                    // name: data[0].name
									// url中已包含，不需要再次添加
                                };
                                this.$nextTick(function () {
                                    me.queryVersion(param);
                                });
                            },
                            // 展示详情面板
                            showDetailFn: function (scope) {
                                var me = this;
                                this.restBtnVisible = false;
                                this.saveBtnVisible = false;
                                this.plusDisabled = true;
                                this.loadServiceList(scope.row.name);
                                this.version.url = backend.dashboardService + '/api/service/basic/version/file/' + scope.row.name;
                                this.form.buttons[0].hidden = true;
                                this.form.buttons[1].hidden = true;
                                this.form.disable = true;
                                this.viewType = "DETAIL";
                                this.form.visible = true;

                                if (scope.row.dependService === null) {
                                    scope.row.dependService = [];
                                }

                                this.$nextTick(function () {
                                    yufp.extend(me.$refs.serviceForm.formModel, scope.row);
                                    this.jvmConfig = scope.row.jvmConfiguration;
                                    this.programConfig = scope.row.programConfiguration;
                                    this.uploadShow = true;
                                });
                                var param = {
                                    //name: scope.row.name
                                };
                                this.$nextTick(function () {
                                    me.queryVersion(param);
                                });
                            },
                            // 展示文件上传面板
                            showUpload: function () {
                                var me = this;
                                var data = this.$refs.servicesTable.selections;
                                if (data == null || data.length != 1) {
                                    me.$message("请至少选择一条数据 !");
                                    return false;
                                }
                                this.upload.visible = true;
                                this.upload.data.name = data[0].name;
                                this.upload.data.version = me.formatTime('yyyyMMdd.hhmmss', new Date());
                            },
                            closeUpload: function () {
                                this.upload.visible = false;
                                this.upload.fileList = [];
                            },
                            uploadFile: function () {
                                this.$refs.uploadList.submit();
                            },
                            // 上传之前验证文件
                            fileChange: function (file, fileList) {
                                console.log(file)
                                console.log(fileList)
                                var fileName = file.name;
                                var suffix = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length)
                                if (suffix != "jar" && suffix != "war") {
                                    fileList.pop();
                                    this.$message("请选择jar或war文件！");
                                } else {
                                    if (fileList.length > 1) {
                                        fileList.pop();
                                        fileList[0] = file;
                                    }
                                }

                                // var t = [];
                                // t.push(file);
                                // this.upload.fileList = t;
                            },
                            // 文件上传之前参数校验
                            beforeUpload: function () {
                                var me = this;
                                // if (this.$refs.serviceForm && this.$refs.serviceForm.formModel) {
                                //     var name = this.$refs.serviceForm.formModel.name;
                                //     if (name && name != "") {
                                //         this.upload.data.name = name;
                                //     }
                                // }
                                if (this.upload.data.name == "" || this.upload.data.version == "") {
                                    this.$message("请确认版本号已填写和服务名已有!")
                                    return false;
                                }
                            },
                            //上传成功回调函数
                            handleAvatarSuccess: function (res, file) {
                                this.$message("上传文件成功!");
                                this.upload.visible = false;
                                this.upload.fileList = [];
                                if (this.$refs.versionTab != undefined) {
                                    this.$refs.versionTab.remoteData();
                                }
                            },
                            // 上传失败回调函数
                            handleAvatarErr: function (err, file) {
                                this.$message("上传文件失败!");
                            },
                            // 删除对应版本
                            deleteVersion: function () {
                                var me = this;
                                var serviceName = me.$refs.servicesTable.selections[0].name;
                                var data = me.$refs.versionTab.selections;
                                var files = "";
                                if (data == null | data.length < 1) {
                                    me.$message("请至少选择一条数据!");
                                }

                                files += data[0].fileName;
                                for (var i = 1; i < data.length; i++) {
                                	files += "," + data[i].fileName;
                                }

                                me.$confirm('确认删除版本?', '提示', {
                                    confirmButtonText: '确定',
                                    cancelButtonText: '取消',
                                    type: 'warning'
                                }).then(function () {
                                    yufp.service.request({
                                        url: backend.dashboardService + '/api/service/basic/version/remove',
                                        method: 'get',
                                        data: {
                                            serviceName: serviceName,
                                            fileList: files
                                        },
                                        callback: function (code, message, response) {
                                            if (code == '0') {
                                                me.$message({
                                                    message: '删除成功!'
                                                });
                                                me.$refs.versionTab.remoteData();
                                            } else {
                                                me.$message({
                                                    message: '删除失败!'
                                                });
                                            }
                                        }
                                    });
                                }).catch(function () {
                                    return;
                                });
                            },
                            //批量删除服务
                            deleteServiceFn: function () {
                                var ids = "";
                                var data = this.$refs.servicesTable.selections;
                                var me = this;
                                if (data == null || data.length <= 0) {
                                    me.$message("请至少选择一条需要删除的数据!");
                                    return false;
                                }

                                ids += data[0].id;
                                for (var i = 1; i < data.length; i++) {
                                    ids += "," + data[i].id;
                                }

                                var flag=true;
                                for(var i=0;i<serviceInfoList.length;i++){
                                    if(serviceInfoList[i].name==data[0].name){
                                        flag = false;
                                        break;
                                    }
                                }

                                if(flag) {
                                    me.$confirm('确认删除服务?', '提示', {
                                        confirmButtonText: '确定',
                                        cancelButtonText: '取消',
                                        type: 'warning'
                                    }).then(function () {
                                        yufp.service.request({
                                            url: backend.dashboardService + '/api/service/basic/delete/' + ids,
                                            method: 'GET',
                                            callback: function (code, message, response) {
                                                if (code == '0') {
                                                    me.$message({
                                                        message: '删除成功!'
                                                    });
                                                    me.$refs.servicesTable.remoteData();
                                                } else {
                                                    me.$message({
                                                        message: '删除失败!'
                                                    });
                                                }
                                            }
                                        });
                                    }).catch(function () {
                                        return;
                                    });
                                } else {
                                    me.$message({message:'该服务为活跃状态，不能被删除'});
                                    return;
                                }
                            },
                            saveService0: function () {
                                var me = this;
                                var data = this.$refs.serviceForm.formModel;
                                data.jvmConfiguration = this.jvmConfig;
                                data.programConfiguration = this.programConfig;
                                if (data.dependService == "") {
                                    data.dependService = new Array();
                                }
                                data.name = this.$refs.serviceForm.formModel.name.toUpperCase();

                                yufp.service.request({
                                    url: backend.dashboardService + '/api/service/basic/update',
                                    method: 'post',
                                    data: data,
                                    callback: function (code, message, response) {
                                        if (code == '0') {
                                            if(response.code==0){
                                                me.$message({
                                                    message: '保存成功!'
                                                });
                                                me.form.visible = false;
                                                me.$refs.servicesTable.remoteData();
                                            }else if(response.code==10000){
                                                me.$message({
                                                    message:response.message,
                                                    type:'warning'
                                                })
                                            }
                                        } else {
                                            me.$message({
                                                message: '保存失败!'
                                            });
                                        }

                                    }
                                });
                            },
                            myRestFn: function () {
                                //新增全部重置
                                if (this.viewType == "ADD") {
                                    this.$refs.serviceForm.resetFn();
                                }
                                //修改只读属性不重置
                                if (this.viewType == "UPDATE") {
                                    var temp = new Map();
                                    //取出readonly的值
                                    for (var i = 0; i < this.form.fields[0].fields.length; i++) {
                                        if (this.form.fields[0].fields[i].readonly) {
                                            var fieldName = this.form.fields[0].fields[i].field;
                                            temp.set(fieldName, this.$refs.servicesTable.selections[0][fieldName]);
                                        }
                                    }
                                    //清空表单
                                    this.$refs.serviceForm.resetFn();
                                    //重设readonly的值
                                    for (var entry of  temp) {

                                        this.$refs.serviceForm.formModel[entry[0]] = entry[1];
                                    }
                                }

                                this.jvmConfig = "";
                                this.programConfig = "";
                            },
                            //查看API,需要当前WEB系统已登录网关
                            detailFn: function (scope) {
                                var me = this;
                                var data = {
                                    username: 'admin',
                                    password: 'admin',
                                    grant_type: "password",
                                    sysId: "1cab27def8fb4c0f9486dcf844b783c0"
                                };
                                var headers = {
                                    "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                                    "Authorization": "Basic d2ViX2FwcDo="
                                };

                                yufp.core.ajax({
                                    url: me.gateWayUrl + backend.uaaService + '/oauth/token',
                                    type: 'post',
                                    headers: headers,
                                    async: true,
                                    data: data,
                                    error: function (xhr, textStatus) {
                                        console.log('错误')
                                        console.log(xhr)
                                        console.log(textStatus)
                                    },
                                    success: function (data, status, xhr) {
                                        if (data) {
                                            var dataObj = JSON.parse(data)
                                            var accessToken = dataObj.access_token;

                                            var url = me.gateWayUrl + "/swagger-ui2.html?jhi-authenticationtoken=" + accessToken + "&name=" + scope.row.name;

                                            var swaggerConfig = {
                                                swaggerConfig:{
                                                    html: 'pages/content/dashboard/swaggerConfig/swaggerConfig.html',
                                                    js:	'pages/content/dashboard/swaggerConfig/swaggerConfig.js'
                                                }
                                            };

                                            yufp.router.addRouteTable(swaggerConfig);

                                            yufp.frame.addTab({
                                                id: 'swaggerConfig',//FUNC_ID(业务功能编号)
                                                title: '接口['+ scope.row.name +']', //MENU_NAME(菜单名称)
                                                key: scope.row.name, //UP_MENU_ID(上级菜单编号)
                                                data: url //给打开的页面传参
                                            });
                                            //var apiwindow = window.open(url, "apiwindow", "height=800, width=800, toolbar =no, menubar=yes,scrollbars=yes, resizable=no, location=no, status=no");
                                        } else {
                                            var msg = '跳转失败，请联系系统管理员！';
                                            $('#msg').text(msg).show();
                                        }
                                    }
                                });
                            },
                            // 查看当前行的jar依赖
                            jarsFn: function (scope) {
                                this.jar.data = '';
                                this.jar.visible = true;
                                var param = {
                                	serviceName: this.$refs.servicesTable.selections[0].name,
                                    fileName: scope.row.fileName    
                                }
                                var me = this;
                                yufp.service.request({
                                    url: backend.dashboardService + '/api/service/basic/dependjars',
                                    method: 'get',
                                    data: param,
                                    callback: function (code, message, response) {
                                        if (code == '0') {
                                            me.$nextTick(function () {
                                                me.jar.data = response.data;
                                            });
                                        } else {
                                            me.$message({
                                                message: '获取依赖JAR包数据失败!'
                                            });
                                        }
                                    }
                                });
                            },
                            formatTime: function (fmt, value) {
                                var o = {
                                    "M+": value.getMonth() + 1, //月份
                                    "d+": value.getDate(), //日
                                    "h+": value.getHours(), //小时
                                    "m+": value.getMinutes(), //分
                                    "s+": value.getSeconds(), //秒
                                    "q+": Math.floor((value.getMonth() + 3) / 3), //季度
                                    "S": value.getMilliseconds() //毫秒
                                };
                                if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (value.getFullYear() + "").substr(4 - RegExp.$1.length));
                                for (var k in o)
                                    if (new RegExp("(" + k + ")").test(fmt))
                                        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
                                return fmt;
                            },
                            //构建
                            buildFn: function () {
                                var me = this;
                                if (me.$refs.servicesTable.selections.length != 1) {
                                    me.$message('请选择一条数据');
                                    return;
                                }
                                if(me.$refs.servicesTable.selections[0].buildFlag==0){
                                    me.$message({message:'该应用正在执行构建，不可重复操作！',type:'warning'});
                                    return;
                                }

                                me.jenkinsBuildName = me.$refs.servicesTable.selections[0].jenkinsBuildName;
                                me.serviceName = me.$refs.servicesTable.selections[0].name;
                                this.$nextTick(function () {
                                    yufp.service.request({
                                        method:'GET',
                                        url:backend.dashboardService + '/api/jenkins/jobcheck',
                                        data:{
                                            jenkinsBuildName:me.jenkinsBuildName
                                        },
                                        callback:function(code,message,response){
                                            if(response && response.code == 100000){
                                                me.$message({message:response.message,type:response.level})
                                                return;
                                            }else if(code == 0 && response.code == 0){
                                                me.$confirm('此操作将执行应用构建,请确认?', '提示', {
                                                    confirmButtonText: '确认',
                                                    cancelButtonText: '取消',
                                                    type: 'warning'
                                                }).then(function (){
                                                    me.beginBuildFn();
                                                    me.$set(me.$refs.servicesTable.selections[0],'buildFlag',0);
                                                }).catch(function(){
                                                    return;
                                                })
                                            }
                                        }
                                    });
                                })
                            },
                            //开始构建
                            beginBuildFn: function () {
                                var me = this;
                                yufp.service.request({
                                    method: 'GET',
                                    url: backend.dashboardService + '/api/jenkins/jobbuild',
                                    data: {
                                        jenkinsBuildName: me.jenkinsBuildName,
                                        serviceName:me.serviceName
                                    },
                                    timeout: 3000000,
                                    callback: function (code, message, response) {
                                        if (code == 0 && response.code == 0) {
                                            var name = response.data.fullDisplayName.trim().split(/\s+/)[0];
                                            var serviceList = me.$refs.servicesTable.data;
                                            for(var n in serviceList){
                                                if(serviceList[n].jenkinsBuildName == name){
                                                    if (response.data.buildResult == "SUCCESS") {
                                                        me.$set(serviceList[n],'buildFlag',1);
                                                    }else if (response.data.buildResult == "FAILURE"){
                                                        me.$set(serviceList[n],'buildFlag',2);
                                                    }else{
                                                        me.$set(serviceList[n],'buildFlag',3);
                                                    }
                                                    me.$set(serviceList[n],'buildNumber',response.data.buildNumber);
                                                }
                                            }
                                        }
                                    }
                                });
                            },
                            //构建结果查看
                            buildResultFn:function(scope){
                                var me = this;
                                me.buildVisible = true;
                                me.buildDialog.title = '应用构建';
                                me.buildDialog.width = 400+'px';
                                me.buildDialog.height= 300+'px';
                                me.buttons1 = true;
                                me.step1 = true;
                                me.step2 = false;
                                me.jenkinsBuildName = scope.row.jenkinsBuildName;
                                me.buildNumber = scope.row.buildNumber;
                                me.serviceName = scope.row.name;
                                yufp.service.request({
                                    method:'GET',
                                    url:backend.dashboardService + '/api/jenkins/buliddetails',
                                    data:{
                                        jenkinsBuildName: me.jenkinsBuildName,
                                        buildNumber: me.buildNumber,
                                        serviceName:me.serviceName
                                    },
                                    callback:function(code,message,response){
                                        if(code==0&&response.code==0){
                                            var responseData = response.data;
                                            var estimatedTime = ((responseData.estimatedDuration) / 1000).toString().replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
                                            var durationTime = ((responseData.duration) / 1000).toString().replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
                                            var buildTime = new Date(responseData.timestamp).toLocaleString().replace(/\//g, "-");
                                            var outputContent = "应用名称: " + me.serviceName + '\n'+"Jenkins配置名称: " + me.jenkinsBuildName + '\n' + "本次构建编号: " + me.buildNumber + '\n' +
                                                "预计构建所需时间: " + estimatedTime + 's' + '\n' + "实际构建使用时间: " + durationTime + 's' + '\n' + "构建时间: " + buildTime + '\n' + "构建结果: " + responseData.buildResult;
                                            me.buildResult.data = outputContent;
                                        }
                                    }
                                });
                            },
                            //控制台输出
                            consoleInfoFn: function () {
                                var me = this;
                                me.step1 = false;
                                me.step2 = true;
                                me.buttons1 = false;
                                yufp.service.request({
                                    method: 'GET',
                                    url: backend.dashboardService + '/api/jenkins/consoleinfo',
                                    data: {
                                        jenkinsBuildName: me.jenkinsBuildName,
                                        buildNumber: me.buildNumber
                                    },
                                    timeout: 200000,
                                    callback: function (code, messsage, response) {
                                        if (code == 0 && response.code == 0) {
                                            me.buildDialog.title = '控制台信息';
                                            me.buildDialog.width = 500+'px';
                                            me.buildDialog.height= 500+'px';
                                            me.consoleInfo.data = response.data;
                                        }
                                    }
                                });
                            }
                        },
                        computed: {
                            uploadAction: function () {
                                return yufp.service.getUrl({
                                    url: this.upload.action
                                });
                            }
                        }
                    });
                }
            }
        });


    };

});