/**
 * 服务伸缩界面
 */
define(function (require, exports) {
    exports.ready = function (hashCode, data, cite) {
        yufp.lookup.reg("UNIT", "INDEX_TYPE", "INDEX_NAME", "RELATION", "FLEX_TYPE","FLEX_WAY","STRATEGY","FREQUENCY");
        var viewType="ADD";
        var vm = yufp.custom.vue({
            el: "#serviceFlex",
            data: function () {
                var me = this;
                return {
                	serviceName:"",
                    height:(yufp.frame.size().height - 35*2 -36 - 20)/2,
                    serviceStyle: {
                        height: yufp.custom.viewSize().height + "px",
                        overflow: "auto",
                        width: "400px",
                        float:'left'
                    },
                    tabStyle: {
                        height: yufp.custom.viewSize().height + "px",
                        marginLeft:'405px',
                        marginRight:'-10px'
                    },
                    activeName: '',
                    service: "",
                    index: {
                        url: backend.dashboardService + "/api/service/flex/index",
                        columns: [
                         {
                            label: "类型",
                            prop: "type",
                            type: "select",
                            dataCode: "INDEX_TYPE",
                        }, {
                            label: "指标",
                            prop: "name",
                            type: "select",
                            dataCode: "INDEX_NAME",
                            formatter:function(row){
                            	return yufp.util.getFromReg("MY_MAP",row.name);
                            }
                        }, {
                            label: "关系",
                            prop: "relation",
                            type: "select",
                            dataCode: "RELATION",
                        }, {
                            label: "阈值",
                            prop: "threshold",
                             formatter:function(row){
                             	var str = row.threshold
                               	if(row.name == "rt_stats")
                               	{
                               		return str +"ms"
                               	}else{
                               		return str +"%"
                               	}
                               }
                        },{
                            label: "伸缩类型",
                            prop: "flexType",
                            type: "select",
                            dataCode: "FLEX_TYPE",
                        },{
                            label: "当前值",
                            prop: "value"
                        }],
                        title: "",
                        visible: false,
                        fields: [{
                            columnCount: 2,
                            fields: [ {
                                field: "type",
                                label: "指标",
                                type: "select",
                                dataCode: "INDEX_TYPE",
                                rules: [{
                                    required: true,
                                    message: '必填项',
                                    trigger: 'change'
                                }],
                                  change:function (val) {
									   	me.$refs.indexForm.formModel["name"]="";
									   	me.$refs.indexForm.formModel["threshold"]="";
									   	
								    var field0 = me.$refs.indexForm.groupFields[0].fields[1];
								    var field1 = me.$refs.indexForm.groupFields[0].fields[4];
								    if(val == "host")
                                	{
                                			field0.options=[{key: "cpu", value: "cpu使用率"},  {key: "memory", value: "内存使用率"}]
                                			field1.label="阈值(%)"
                                			field1.rules[1] = {validator:yufp.validator.percent}
                                	}else{
                                		    field0.options=[{key: "rt_stats", value: " 响应时间"} ]
                                		    field1.label="阈值(ms)"
                                		    field1.rules[1] = {validator:yufp.validator.gtZore}
                                	}
                                   	
                                   	
                                   }
                            },{
                                field: "name",
                                label: "名称",
                                type: "select",
                                rules: [{
                                    required: true,
                                    message: '必填项',
                                    trigger: 'change'
                                }]
                            },{
                                field: "flexType",
                                label: "伸缩类型",
                                type: "select",
                                dataCode: "FLEX_TYPE",
                                rules: [{
                                    required: true,
                                    message: '必填项',
                                    trigger: 'change'
                                }]
                            }, {
                                field: "relation",
                                label: "关系",
                                type: "select",
                                dataCode: "RELATION",
                                rules: [{
                                    required: true,
                                    message: '必填项',
                                    trigger: 'change'
                                }]
                            }, {
                                field: "threshold",
                                label: "阈值",
                                type: "num",
                                rules: [{
                                    required: true,
                                    message: '必填项'
                                },{
                                    validator: yufp.validator.number,
                                    message: '数值类型'
                                }]
                            }]
                        }],
                        buttons: [{
                            label: "取消",
                            icon: "yx-undo2",
                            type:'primary',
                            click: function (model, valid) {
                                me.indexClose();
                            }
                        }, {
                            label: "保存",
                            type:'primary',
                            icon: "check",
                            op: 'submit',
                            click: function (model, valid) {
                                if (valid) {
                                    me.indexSaveFn(model);
                                }
                            }
                        }]
                    },
                    detail:{
                        title: "",
                        visible: false,
                        fields: [{
                            columnCount: 2,
                            fields: [ {
                                field: "expandShrinkFrequency",
                                label: "伸缩间隔时间",
                                type:"select",
                                dataCode:"FREQUENCY",
                                rules: [{
                                    required: true,
                                    message: '必填项'
                                }]
                            },{
                                field: "expandMax",
                                label: "最大扩容数",
                                rules: [{
                                    required: true,
                                    message: '必填项'
                                },{validator:yufp.validator.gtOne}]
                            }, {
                                field: "shrinkMin",
                                label: "最小收缩数",
                                rules: [{
                                    required: true,
                                    message: '必填项'
                                },{validator:yufp.validator.gtOne}]
                            }, {
                                field: "expandShrinkStrategy",
                                label: "收缩策略",
                                type: "select",
                                dataCode:"STRATEGY",
                                rules: [{
                                    required: true,
                                    message: '必填项'
                                }]
                            }]
                        }],
                        buttons: [{
                            label: "取消",
                            icon: "yx-undo2",
                            type:'primary',
                            click: function (model, valid) {
                                me.detailClose();
                            }
                        }, {
                            label: "保存",
                            type:'primary',
                            icon: "check",
                            op: 'submit',
                            click: function (model, valid) {
                                if (valid) {
                                    me.detailSaveFn(model);
                                }
                            }
                        }]
                    
                    },
                    hosts: [],
                    versions: [],
                    services: [],
                    log: {
                        visible: false,
                        url: backend.dashboardService + "/api/service/flexHistory/info",
                        columns: [{
                            prop: "name",
                            label: "服务名称"
                        }, {
                            prop: "type",
                            label: "伸缩类型",
                            dataCode: "FLEX_TYPE"
                        }, {
                            prop: "auto",
                            label: "是否自动",
                            dataCode: "FLEX_WAY"
                        }, {
                            prop: "host",
                            label: "机器"
                        }, {
                            prop: "time",
                            label: "时间"
                        }, {
                            prop: "desc",
                            label: "扩容描述"
                        }]
                    }
                };
            },
            // 创建时执行
            created: function () {
                this.loadServices();
            },
            methods: {
                // 刷新指标表
                queryIndexTab: function (param) {
                    this.$refs.indexTab.remoteData(param);
                },
                //刷新伸缩日志
                queryLogTab: function (param) {
                    this.$refs.logTab.remoteData(param);
                },
                // 刷新表格
                refreshTab: function (name) {
                    var param = {
                        name: name
                    };
                    this.service = name;
                    this.queryIndexTab(param);
                    this.queryLogTab(param);
                    this.activeName = name;
                },
                // 关闭指标维护面板
                indexClose: function () {
                    this.index.visible = false;
                },
                // 关闭详情面板
                detailClose: function () {
                    this.detail.visible = false;
                    this.loadServices();
                },
                // 展示新增指标面板
                showAddIndex: function () {
                	viewType = "ADD";
                    var me = this;
                    me.index.title = "新增指标";
                    me.index.visible = true;
                    me.$nextTick(function () {
                        me.$refs.indexForm.resetFn();
                    });
                },
                // 展示修改指标面板
                showUpdateIndex: function () {
                	viewType = "UPDATE";
                    var me = this;
                    var data = me.$refs.indexTab.selections;
                    if (data == null || data.length != 1) {
                        me.$message("请选择一条数据!")
                        return;
                    }
                    me.index.title = "修改指标";
                    me.index.visible = true;
                    me.$nextTick(function () {
                        me.$refs.indexForm.resetFn();
                        yufp.extend(me.$refs.indexForm.formModel, data[0]);
                    });
                },
                 // 展示修改详情面板
                showDetails: function () {
                    var me = this;
                    me.detail.title = "设置详情";
                    me.detail.visible = true;
                    me.$nextTick(function () {
                    	me.$refs.detailForm.resetFn();
                		 for(var i = 0;i<me.services.length;i++)
	                    {
	                    	if(me.service == me.services[i]["name"] )
	                    	{
		                    	me.$refs.detailForm.formModel["expandShrinkFrequency"]=me.services[i]["expandShrinkFrequency"]
		                		me.$refs.detailForm.formModel["expandMax"]=me.services[i]["expandMax"]
		                		me.$refs.detailForm.formModel["shrinkMin"]=me.services[i]["shrinkMin"]
		                		me.$refs.detailForm.formModel["expandShrinkStrategy"]=me.services[i]["expandShrinkStrategy"]
	                    	}
	                    }
                    	});
                },
                //指标保存
                indexSaveFn: function (param) {
                    var me = this;
                    //start add by Cytus_ at 20180903 增加在新增保存指标是存在重复的指标项校验
                    var tableDataArrays = me.$refs.indexTab.data;
                    var isRepeat = false;
                    for (var i  = 0; i < tableDataArrays.length; i++) {
                    	var tableData = tableDataArrays[i];
                    	if (param.id != tableData.id && param.flexType == tableData.flexType && param.name == tableData.name 
                    			&& param.type == tableData.type && param.relation == tableData.relation) {
                    		isRepeat = true;
                    		break;
                    	}
                    }
                    	
                    if (isRepeat) {
                    	me.$message("已存在相同的指标项, 请修改相关配置!");
                    	return;
                    }
                    //end add by Cytus_ at 20180903
                    
                    var url="";
                    if(viewType=="ADD")
                    {
                    	url = backend.dashboardService + "/api/service/flex/addindex?name=" + me.service
                    }
                    if(viewType=="UPDATE")
                    {
                    	url = backend.dashboardService + "/api/service/flex/updateindex?name=" + me.service
                    }
                    yufp.service.request({
                        url: url,
                        method: "post",
                        data: param,
                        callback: function (code, msg, res) {
                            if (res != null && res.data != null && res.data == 0) {
                                me.$message("保存成功!");
                                me.indexClose();
                                me.$refs.indexTab.remoteData();
                            } else {
                                me.$message("保存失败!");
                            }
                        }
                    })
                },
                //详情保存
                detailSaveFn: function (param) {
                    var me = this;
                    yufp.service.request({
                        url:  backend.dashboardService + "/api/service/basic/updateExpandShrinkDetails?name=" + me.service,
                        method: "post",
                        data: param,
                        callback: function (code, msg, res) {
                            if (res != null && res.data != null && res.data == 0) {
                                me.$message("保存成功!");
                                me.detailClose();
                            } else {
                                me.$message("保存失败!");
                            }
                        }
                    })
                },
                // 指标移除
                removeIndex: function () {
                    var me = this;
                    var data = me.$refs.indexTab.selections;
                    var ids = "";
                    if (data == null | data.length < 1) {
                        me.$message("请至少选择一条数据!");
                    }

                    ids += data[0].id;
                    for (var i = 1; i < data.length; i++) {
                        ids += "," + data[i].id;
                    }

                    me.$confirm('确认删除指标信息?', '提示', {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function () {
                        yufp.service.request({
                            url: backend.dashboardService + '/api/service/flex/removeindex',
                            method: 'get',
                            data: {
                                name:me.service,
                                keys: ids
                            },
                            callback: function (code, message, response) {
                                if (code == '0') {
                                    me.$message({
                                        message: '删除成功!'
                                    });
                                    me.$refs.indexTab.remoteData();
                                } else {
                                    me.$message({
                                        message: '删除失败!'
                                    });
                                }
                            }
                        });

                    });
                },
                //单个服务信息刷新
                refresh: function (item) {
                    item.load = true;
                    var me = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/service/flex/info/" + item.name,
                        method: "get",
                        callback: function (code, msg, res) {
                            if (res != null && res.data != null) {
                                item.load = false;
                                var data = me.buildSingleService(res.data);
                                me.updateCluster(item, data.clusterNum, data.instanceNum);
                            }
                        }
                    });
                },
                // 添加实例
                addInstance: function (item) {
										this.$message({
											message: '正在扩容，请稍后'
										});
                    var me = this;
                    me.updateCluster(item, item.clusterNum + 1, item.instanceNum);
                    yufp.service.request({
                        url: backend.dashboardService + "/api/service/flex/addinstance",
                        method: "get",
                        timeout:6000000,
                        data: {
                            name: item.name
                        },
                        callback: function (code, msg, res) {
                            me.$message("服务已开始部署!");
                        }
                    });
                },
                // 减少实例
                downInstance: function (item) {
										this.$message({
											message: '正在收缩，请稍后'
										});
                    var me = this;
                    if (item.clusterNum == 0) {
                        return;
                    }
                    me.updateCluster(item, item.clusterNum - 1, item.instanceNum);
                    yufp.service.request({
                        url: backend.dashboardService + "/api/service/flex/downinstance",
                        method: "get",
                        data: {
                            name: item.name
                        },
                        callback: function (code, msg, res) {
                            me.$message("开始关闭一个服务!");
                        }
                    });
                },
                //更新页面展示状态
                updateCluster: function (item, clusterNum, instanceNum) {
                    item.clusterNum = clusterNum;
                    item.instanceNum = instanceNum;
                    item.clus = item.instanceNum + "/" + item.clusterNum;
                    item.tipText = "集群数目:" + item.clusterNum + "已部署数目:" + item.instanceNum;
                    if (item.clusterNum && item.instanceNum && item.clusterNum != 0) {
                        item.percentage = (item.instanceNum / item.clusterNum) * 100;
                    }
                },
                // 载入服务列表
                loadServices: function () {
                    var me = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/service/flex/info",
                        method: "get",
                        callback: function (code, msg, res) {
                            if (res != null && res.data != null) {
                                var data = res.data;
                                var _data = [];
                                //构建额外信息
                                for (var i = 0; i < data.length; i++) {
                                    _data.push(me.buildSingleService(data[i]));
                                }
                                me.services = _data;
                            }
                        }
                    });
                },
                // 构建单个服务信息
                buildSingleService: function (data) {
                    var temp = data;
                    temp.maxVersion = "";
                    temp.clus = "";
                    temp.percentage = 0;
                    temp.load = false;
                    //提示信息
                    temp.tipText = "未获取到集群数目"
                    var map = temp.versionMap;
                    var maxKey = "";
                    if (map) {
                        for (var key in map) {
                            if (key > maxKey) {
                                maxKey = key;
                            }
                        }
                    }
                    temp.maxVersion = map[maxKey].version;
                    temp.clus = temp.instanceNum + "/" + temp.clusterNum;
                    temp.tipText = "集群数目:" + temp.clusterNum + "已部署数目:" + temp.instanceNum;
                    if (temp.clusterNum && temp.instanceNum && temp.clusterNum != 0) {
                        temp.percentage = (temp.instanceNum / temp.clusterNum) * 100;
                    }

                    return temp;
                }
            },
            computed: {
                indexButton: function () {
                    return this.service != null && this.service != "";
                }
            }
        });
    };
});