/**
 * 服务降级
 */
define( function(require, exports) {
    exports.ready = function(hashCode, data, cite){
    	yufp.lookup.reg('DOWNGRADE_STRATEGY,HTTP_CONTENT_TYPE');
    	yufp.lookup.lookupMgr["URL_TAGS"] = [];
    	yufp.lookup.lookupMgr["URL_PATHS"] = [];
        var vm = yufp.custom.vue({
            el: cite.el,
            data: function(){
                var me = this;
                var queryString = yufp.sessionStorage.get("currentCluster") ? ('applist/?cluster=' + yufp.sessionStorage.get("currentCluster")) : '';
                return {
                    applicationsUrl:backend.dashboardService+'/api/instancemanager/' + queryString,
                    height: yufp.frame.size().height - 92 - 10,
                    name:'',
                    tableColumns: [
                    	{label: '服务名称', prop: 'name',formatter:function(row){
                        	if(row.name=="GATEWAY"){
                        		if(me.$refs.applicationsTable.data){
                        			var data_tmp=me.$refs.applicationsTable.data;
                        			var data_new=[];
                        			for(var i=0;i<data_tmp.length;i++){
                        				if(data_tmp[i].name=="GATEWAY"){
                        				}else{
                        					data_new.push(data_tmp[i]);
                        				}
                        			}
                        			me.$refs.applicationsTable.data=data_new;
                        		}
                        		return row.name;
                        	}else{
                        		return row.name;
                        	}
                        	
                           }},
                    	{ label: '数量', prop: 'instances', width:100, resizable: true,formatter:function(row){
                            var upCount = 0;
                             for(var i=0; i < row.instances.length; i++){
                                 if (row.instances[i].status === "UP"){
                                     upCount++;
                                 }
                             }
                             return upCount + "/" + row.instances.length;
                            }
                        }
                    ],
                    parameterUrl:backend.dashboardService + '/api/serviceDegradation/paramsinfo',
                    dialogVisible:false,
                    pathsData:{},
                    parameterTableColumns:[
                    	
                    	{ prop: 'uri', label: '请求URI'},
                        { prop: 'downgradeStrategy', label: '降级策略', type: 'select', dataCode: 'DOWNGRADE_STRATEGY'},
                        // { prop: 'staticResContentType', label: '响应内容类型', type: 'select', dataCode: 'HTTP_CONTENT_TYPE'},
                        { prop: 'staticResContent', label: '静态响应内容', type: 'select', type: 'textarea', rows: 3}
                    ],
                    paramFields:[
                    	
                        {
                            columnCount: 2,
                            fields:[
                            	{ field: 'name', label: '服务名称',disabled:true }
                            ]
                        },
                        {
                            columnCount: 1,
                            fields:[
                            	{
                                    field: 'tags', label:"模块",type: 'select',dataCode:"URL_TAGS" ,hidden:true,change:function(val){
                                    	if(me.pathsData[val]){
                                    		var data_=me.pathsData[val];
                                    		 yufp.lookup.lookupMgr["URL_PATHS"].splice(0,yufp.lookup.lookupMgr["URL_PATHS"].length);
                                    		for(var i=0;i<data_.length;i++){
                                    			 yufp.lookup.lookupMgr["URL_PATHS"].push(data_[i]);
                                    		}
                                    		me.$nextTick(function () {
                                                yufp.extend(me.$refs.paramForm.formModel, {"uri":""});
                                            });
                                    	}
                                    },rules: [{ trigger: 'change'}]
                                }
                            ]
                        },
                    	{
                            columnCount: 2,
                            fields:[
                                {
                                    field: 'uri', label: "请求URI",type: 'select',dataCode:"URL_PATHS",rules:[
                                        {required: true, message: '必填项', trigger: 'blur'}
                                    ]
                                },
                                { field: 'downgradeStrategy', label: '降级策略', type: 'select', dataCode: 'DOWNGRADE_STRATEGY', change:function (val) {
                                        me.setResContent(val);
                                    },rules:[{required: true, message: '必填项', trigger: 'blur'}]},
                                // { field: 'staticResContentType', label: '响应内容类型', type: 'select', dataCode: 'HTTP_CONTENT_TYPE'}
                            ]
                        },
                        {
                            columnCount: 1,
                            fields:[
                                { field: 'staticResContent', label: '静态响应内容', type: 'textarea', rows: 5, hidden:true }
                            ]
                        }
                    ],
                    formButtons:[
                        {
                            label: '取消', type: 'primary', icon: "yx-undo2", hidden: false, click: function (model) {
                            me.dialogVisible = false;
                        }
                        },
                        {
                            label: '保存',type: 'primary',icon: "check",hidden: false,op: 'submit',click: function (model,valid) {
                                if(valid){
                                    if(model.downgradeStrategy === '01'){
                                        model.staticResContent = '';
                                    }
                                    yufp.service.request({
                                        method: 'POST',
                                        url: backend.dashboardService+'/api/serviceDegradation/updateparams',
                                        data: model,
                                        callback: function (code, message, response) {
                                            if (response.code===0) {
                                                me.$message('保存成功，请点击实时同步');
                                                me.dialogVisible = false;
                                                me.queryParamFn();
                                            }
                                        }
                                    });
                                }else {
                                    me.$message({message: '请检查输入项是否合法', type: 'warning'});
                                    return false;
                                }
                        }
                        }
                    ]
                }
            },
            methods: {
                setResContent:function(val){
                    var flag = true;
                    if (val === '02'){
                        flag = false;
                    }
                    this.$nextTick(function () {
                        this.$refs.paramForm.switch('staticResContent','hidden',flag);
                    });
                },
                //删除
                takeEffect:function(){
                    if (this.$refs.parameterTable.selections.length < 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'})
                        return;
                    }
                    var me = this;
                    var model=me.$refs.parameterTable.selections[0];
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService+'/api/serviceDegradation/remove',
                        data: model,
                        callback: function (code, message, response) {
                            if (response.code===0) {
                                me.$message('操作成功，请点击实时同步');
                                me.queryParamFn();
                            }
                        }
                    });
                },
                //新增
                addFn:function(){
                	if(this.name==""){
                		this.$message({message: '请先选择一条服务', type: 'warning'})
                		return;
                	}
                	// this.paramFields[1].fields[0].hidden=false;
//                	this.paramFields[1].fields[1].disabled=false;
                	this.dialogVisible = true;
                	this.setResContent();
                	var  model={};
                	model.name=this.name;
                	model.uri="";
                	model.downgradeStrategy="";
                	model.staticResContentType="";
                	model.staticResContent="";
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.paramForm.formModel, model);
                        this.$refs.paramForm.switch('tags','hidden',false);
                    });
                    this.queryswaggerAPIFn();
                  
                },
                rowClickFn:function(row){
                    this.name = row.name;
                    this.queryParamFn();
                },
                queryParamFn:function(){
                    var me = this;
                    var params={};
                    params.name=me.name;
                    me.$refs.parameterTable.remoteData(params);
                    /**
                    yufp.service.request({
                        method:'GET',
                        url:backend.dashboardService + '/api/serviceDegradation/paramsinfo',
                        data:{
                            name:me.name
                        },
                        callback:function(code,message,response){
                            if(response.code===0){
                                var parameters = response.data;
                                if(response.data==null){
                                	 me.$refs.parameterTable.data = [];
                                     me.$refs.parameterTable.total = 0;
                                }else{
                                	 me.$refs.parameterTable.data = parameters;
                                     me.$refs.parameterTable.total = response.total;
                                }
                               
                            }
                        }
                    });
                    **/
                },
                modifyFn:function(){
                    if (this.$refs.parameterTable.selections.length < 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'})
                        return;
                    }
                    // this.paramFields[1].fields[0].hidden=true;
//                	this.paramFields[1].fields[1].disabled=true;
                    this.dialogVisible = true;
                    this.setResContent(this.$refs.parameterTable.selections[0].downgradeStrategy);
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.paramForm.formModel, this.$refs.parameterTable.selections[0]);
                        this.$refs.paramForm.switch('tags','hidden',true);
                    });
                },
                reflushgateway:function(){
               	 var me = this;
               	const loading = me.$loading({
                    lock: false,
                    fullscreen:false,
                    text: '数据同步中，请稍后...',
                    spinner: 'el-icon-loading'
                  });
                  setTimeout(() => {
                    loading.close();
                  }, 20000);
                  
               	yufp.service.request({
                       method: 'get',
                       url: backend.dashboardService+'/api/serviceDegradation/reflushConf',
                       data: null,
                       callback: function (code, message, response) {
                    	   loading.close();
                           if (response.code===0) {
                                me.$message('刷新成功');
                           }else{
                           		me.$message({message: response.message, type: 'warning'});
                           }
                       }
                   });
               },
                //读取swaggerAPI文档
                queryswaggerAPIFn: function () {
                    var me = this;
                    yufp.lookup.lookupMgr["URL_PATHS"].splice(0,yufp.lookup.lookupMgr["URL_PATHS"].length);
                    yufp.lookup.lookupMgr["URL_TAGS"].splice(0,yufp.lookup.lookupMgr["URL_TAGS"].length);
                    var param = {
                    	"name":me.name
                    }
                    //发起请求
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService+'/api/gatewayapi/swaggerapi/info',
                        data: param,
                        callback: function (code, message, response) {
                        	if (response.code===0) {
                        		for(var i=0;i<response.data["tagsData"].length;i++){
                        			yufp.lookup.lookupMgr["URL_TAGS"].push(response.data["tagsData"][i]);
                        		}
                        		//yufp.lookup.lookupMgr["URL_TAGS"].push({});// = response.data["tagsData"];
                        		me.pathsData=response.data["pathsData"];
                        		me.$nextTick(function () {
                                    yufp.extend(me.$refs.paramForm.formModel, {"uri":"","tags":""});
                                });
                        	}else{
                        		me.$message({message: response.message, type: 'warning'});
                        	}
                            
                        }
                    });
                }
            }
        })
    }
});