/**
 * 服务监控
 */
define(function (require, exports) {
    exports.ready = function (hashcode, data, cite) {
        var seriesLabel = {
            normal: {
                show: true,
                position: 'insideLeft',
                textStyle: {
                    color: '#666'
                }
            }
        }
        var tooltip = {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            },
            formatter: "{a} <br/> {b} : {c} "
        };
        var grid = {
            left: '2%',
            bottom: '3%',
            containLabel: true
        };
        var xAxis = {
            type: 'value',
            axisLine: {
                lineStyle: {
                    color: '#666'
                }
            }
        };
        var serviceDataUrl = backend.dashboardService + '/api/instancemanager' + (data===''? '/' : '/?name='+data);
        var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var me = this;
                return {
                    dataUrl: serviceDataUrl,
                    height: yufp.frame.size().height - 56 - 10,
                    tableColumns: [
                        {label: '服务名称', prop: 'name'}
                    ],
                    ifChart: false,
                    memoryList: [],
                    totalThreads: 0,
                    runnableNum: 0,
                    runnableWidth: '',
                    threadDataList: [],
                    activeWebChart: null,
                    activeWebTitle: '',
                    activeWebData: [],
                    webResponseChart: null,
                    webResponseTitle: '',
                    webResponseData: [],
                    webRequestsChart: null,
                    webRequestsTitle: '',
                    webRequestsData: [],
                    responseChartBox:'',
                    requestsChartBox:'',
                    activeChartBox:''
                }
            },
            methods: {
                //服务信息
                serviceQueryFn:function(){
                    var me = this;
                    yufp.service.request({
                        method:'GET',
                        url:serviceDataUrl,
                        callback:function(code,message,response){
                            if(code==0&&response.code==0){
                                me.$refs.serviceTable.setCurrentRow(me.$refs.serviceTable.data[0]);
                                me.$refs.serviceTable.radio= 0;
                                var instances = response.data[0].instances;
                                var ids = '';
                                if (instances.length > 0) {
                                    for (var t = 0; t < instances.length; t++) {
                                        ids = ids + ',' + instances[t].id;
                                    }
                                    ids = ids.substr(1);
                                    me.serviceInfoFn(ids);
                                }else{
                                    return;
                                }

                            }
                        }
                    })
                },
                //监控信息查询
                serviceInfoFn:function(ids){
                    var me = this;
                    me.ifChart = true;
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/monitorservice/' + ids + '/metrics.json/',
                        callback: function (code, message, response) {
                            if (code == 0 && response.code == 0) {
                                me.memoryList = [];
                                me.webResponseData = [];
                                var totalMemory = 0;
                                var freeMem = 0;
                                var heapUsed = 0;
                                var nonHeap = 0;
                                var heapCommit = 0;
                                var nonHeapCommit = 0;
                                var errorsCount = 0;
                                var badRequestCount = 0;
                                var createdCount = 0;
                                var noContentCount = 0;
                                var notFoundCount = 0;
                                var okCount = 0;
                                var otherCount = 0;
                                var serverErrorCount = 0;
                                var timeoutsCount = 0;

                                var data = response.data.split('|');
                                for (var n = 0; n < data.length - 1; n++) {
                                    var responseData = JSON.parse(data[n + 1])
                                    totalMemory = totalMemory + responseData['mem'] / 1024;
                                    freeMem = freeMem + responseData['mem.free'] / 1024;
                                    heapUsed = heapUsed + responseData['heap.used'] / 1024;
                                    heapCommit = heapCommit + responseData['heap.committed'] / 1024;
                                    nonHeap = nonHeap + responseData['nonheap.used'] / 1024;
                                    nonHeapCommit = nonHeapCommit + responseData['nonheap.committed'] / 1024;
                                    // errorsCount = errorsCount+responseData['com.codahale.metrics.servlet.InstrumentedFilter.errors.count'];
                                    badRequestCount = badRequestCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.badRequest.count'];
                                    createdCount = badRequestCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.created.count'];
                                    noContentCount = noContentCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.noContent.count'];
                                    notFoundCount = notFoundCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.notFound.count'];
                                    okCount = okCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.ok.count'];
                                    otherCount = otherCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.other.count'];
                                    serverErrorCount = serverErrorCount + responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.serverError.count'];
                                    // timeoutsCount = timeoutsCount+responseData['com.codahale.metrics.servlet.InstrumentedFilter.timeouts.count'];
                                }
                                var usedMem = totalMemory - freeMem;
                                var memoryWidth = ((usedMem / totalMemory) * 100).toFixed(2);
                                var heapWidth = ((heapUsed / heapCommit) * 100).toFixed(2);
                                var nonHeapWidth = ((nonHeap / nonHeapCommit) * 100).toFixed(2);
                                me.memoryList.push(
                                    {
                                        title: '总内存',
                                        used: usedMem.toFixed(2),
                                        total: totalMemory.toFixed(2),
                                        width: memoryWidth
                                    },
                                    {
                                        title: '堆内存',
                                        used: heapUsed.toFixed(2),
                                        total: heapCommit.toFixed(2),
                                        width: heapWidth
                                    },
                                    {
                                        title: '非堆内存',
                                        used: nonHeap.toFixed(2),
                                        total: nonHeapCommit.toFixed(2),
                                        width: nonHeapWidth
                                    }
                                );
                                for(var k in me.memoryList){
                                    if(me.memoryList[k].width>0&&me.memoryList[k].width<=80){
                                        me.memoryList[k].bgColor = '#20a0ff';
                                    }else if(me.memoryList[k].width>80&&me.memoryList[k].width<=90){
                                        me.memoryList[k].bgColor = '#f7ba2a';
                                    }else if(me.memoryList[k].width>90&&me.memoryList[k].width<=100){
                                        me.memoryList[k].bgColor = '#ff4949';
                                    }
                                }
                                me.webResponseData.push(
                                    // {name:'errors',value:errorsCount},
                                    {name: 'BadRequest', value: badRequestCount},
                                    {name: 'Created', value: createdCount},
                                    {name: 'NoContent', value: noContentCount},
                                    {name: 'NotFound', value: notFoundCount},
                                    {name: 'OK', value: okCount},
                                    {name: 'Other', value: otherCount},
                                    {name: 'ServerError', value: serverErrorCount}
                                    // {name:'timeouts',value:timeoutsCount}

                                );
                                me.webResponseTitle = 'Web响应码';
                                me.webResponseChartFn();
                            }
                        }
                    });

                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/monitorservice/' + ids + '/dump/',
                        callback: function (code, message, response) {
                            if (code == 0 && response.code == 0) {
                                me.threadDataList = [];
                                var threadStateList = {
                                    RUNNABLE: 0,
                                    TIMED_WAITING: 0,
                                    WAITING: 0
                                };
                                var data1 = response.data.split('|');
                                for (var j = 0; j < data1.length - 1; j++) {
                                    var responseData2 = JSON.parse(data1[j + 1]);
                                    for (var key in responseData2) {
                                        if (responseData2[key].threadState === 'RUNNABLE') {
                                            threadStateList.RUNNABLE++;
                                        } else if (responseData2[key].threadState === 'TIMED_WAITING') {
                                            threadStateList.TIMED_WAITING++;
                                        } else if (responseData2[key].threadState === 'WAITING') {
                                            threadStateList.WAITING++;
                                        }
                                    }
                                }
                                me.totalThreads = threadStateList.RUNNABLE + threadStateList.TIMED_WAITING + threadStateList.WAITING;
                                me.runnableNum = threadStateList.RUNNABLE;
                                me.runnableWidth = ((me.runnableNum / me.totalThreads) * 100).toFixed(2) + '%';
                                me.threadDataList.push(
                                    {
                                        title: '限时等待',
                                        num: threadStateList.TIMED_WAITING,
                                        width: ((threadStateList.TIMED_WAITING / me.totalThreads) * 100).toFixed(2) + '%'
                                    },
                                    {
                                        title: '等待',
                                        num: threadStateList.WAITING,
                                        width: ((threadStateList.WAITING / me.totalThreads) * 100).toFixed(2) + '%'
                                    }
                                );
                            }
                        }
                    });

                },
                rowClickFn: function (row) {
                    if (row.instances.length > 0) {
                        var instances = row.instances;
                        var ids = '';
                        if (instances.length > 0) {
                            for (var i = 0; i < instances.length; i++) {
                                ids = ids + ',' + instances[i].id;
                            }
                            ids = ids.substr(1);
                            this.serviceInfoFn(ids);
                        }else{
                            return;
                        }
                    }
                },
                activeWebChartFn: function () {
                    this.activeWebChart.setOption({
                        title: {
                            // text: this.activeWebTitle,
                            // text:'Active Web Requests',
                            text: '主动Web请求',
                            textStyle: {
                                color: '#666',
                                fontSize: 14
                            },
                            top: 15
                        },
                        tooltip: tooltip,
                        grid: grid,
                        xAxis: xAxis,
                        yAxis: {
                            type: 'category',
                            data: ['Requests', 'Dispatches', 'Suspended'],
                            axisLine: {
                                lineStyle: {
                                    color: '#666'
                                }
                            },
                            axisLabel: {
                                margin: 1
                            }
                        },
                        color: ['#20a0ff'],
                        series: [
                            {
                                name: this.activeWebTitle,
                                type: 'bar',
                                label: seriesLabel,
                                // data: this.activeWebData
                                data: [6, 1, 0]
                            }
                        ]
                    });
                },
                webResponseChartFn: function () {
                    this.webResponseChart.setOption({
                        title: {
                            text: this.webResponseTitle,
                            textStyle: {
                                color: '#666',
                                fontSize: 14
                            },
                            top: 15
                        },
                        color: ['#20a0ff'],
                        tooltip: tooltip,
                        grid: grid,
                        xAxis: xAxis,
                        yAxis: {
                            type: 'category',
                            data: ['BadRequest', 'Created', 'NoContent', 'NotFound', 'OK', 'Other', 'ServerError'],
                            axisLine: {
                                lineStyle: {
                                    color: '#666'
                                }
                            },
                            axisLabel: {
                                margin: 1
                            }
                        },
                        series: [
                            {
                                name: this.webResponseTitle,
                                type: 'bar',
                                label: seriesLabel,
                                data: this.webResponseData
                            }
                        ]
                    });
                },
                webRequestsChartFn: function () {
                    this.webRequestsChart.setOption({
                        title: {
                            // text: this.webRequestsTitle,
                            // text:'Web Requests',
                            text: 'Web请求',
                            textStyle: {
                                color: '#666',
                                fontSize: 14
                            },
                            top: 15
                        },
                        color: ['#20a0ff'],
                        tooltip: tooltip,
                        grid: grid,
                        xAxis: xAxis,
                        yAxis: {
                            type: 'category',
                            data: ['PUT', 'POST', 'OTHER', 'OPTIONS', 'GET', 'DELETE'],
                            axisLine: {
                                lineStyle: {
                                    color: '#666'
                                }
                            },
                            axisLabel: {
                                margin: 1
                            }
                        },
                        series: [
                            {
                                name: this.webRequestsTitle,
                                type: 'bar',
                                label: seriesLabel,
                                // data: this.webRequestsData
                                data: [0, 1693, 0, 0, 550, 1]
                            }
                        ]
                    });
                }
            },
            mounted: function () {
                var mathRand = function () {
                    var num="";
                    for(var i=0;i<6;i++)
                    {
                        num+=Math.floor(Math.random()*10);
                    }
                    return num;
                };
                this.responseChartBox = 'responseChartBox'+mathRand();
                this.activeChartBox = 'activeChartBox'+mathRand();
                this.requestsChartBox = 'requestsChartBox'+mathRand();
                this.$nextTick(function () {
                    this.serviceQueryFn();
                    this.activeWebChart = echarts.init(document.getElementById(this.activeChartBox));
                    this.activeWebChartFn();
                    this.webResponseChart = echarts.init(document.getElementById(this.responseChartBox));
                    this.webResponseChartFn();
                    this.webRequestsChart = echarts.init(document.getElementById(this.requestsChartBox));
                    this.webRequestsChartFn();
                });
            }
        });
    }
});
