/**
 * Created by yumeng on 2017/11/26.
 */
define([
],function (require, exports) {

    //page加载完成后调用ready方法
    exports.ready = function (hashCode, data, cite) {
		var queryString = yufp.sessionStorage.get("currentCluster") ? ('/' + yufp.sessionStorage.get("currentCluster")) : '';
    var userId = yufp.sessionStorage.get("userInfo")["id"] == null ? "" : yufp.sessionStorage.get("userInfo")["id"];
		var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var _self = this;
                return {
									loading:false,
									infoData:[]
							}
            },
						created:function(){
							
						},
						mounted:function(){
							this.clickRefresh();
							_self = this;
							// setInterval(_self.refresh, 5000);
						},
            methods: {
							nameChange:function(val){
								_self = this;
								if(val != null && val  != "")
								{
									yufp.service.request({
											method: 'GET',
											url:backend.dashboardService + "/api/middleware/version?name="+val,
											callback: function (code, message, response) {
												if (code==0) {
													for(var i=0;i<response.data.length;i++)
													{
														_self.versions.push({label:response.data[i],value:response.data[i]})
													}
												}
											}
										});
								}else{
									_self.verions=[];
								}
							},
				delete:function(){
					_self = this;
					var selections=this.$refs.table.selections;
					if (selections.length < 1) {
						this.$message({message: '请先选择一条记录', type: 'warning'});
						return;
					}
					var len=selections.length,arr=[];
					for(var i=0;i<len;i++){
						arr.push(selections[i].id);
					}
					_self.$confirm('确认删除中间件?', '提示', {
						confirmButtonText: '确定',
						cancelButtonText: '取消',
						type: 'warning'
					}).then(function () {
						yufp.service.request({
								method: 'GET',
								url:backend.dashboardService + "/api/middlewareinfo/delete/"+arr.join(','),
								callback: function (code, message, response) {
									if (code==0) {
										_self.$refs.table.remoteData();
										_self.$message('操作成功');
									}
								}
							});
						
						
					}).catch(function(){
						return;
					});
				},
				start:function(id){
					_self = this;
						this.$notify({
						title: '提示',
						message: '正在启动，请稍后',
						duration: 2000
					});
					var name=""
					var hostName=""
					var version=""
					var startConfig = ""
					for(var i=0;i<this.infoData.length;i++)
					{
						if(id == this.infoData[i]["id"])
						{
							name=this.infoData[i]["middleWareName"]
							hostName=this.infoData[i]["hostName"]
							version=this.infoData[i]["middleWareVersion"]
							startConfig=this.infoData[i]["startConfig"]
						}
					}
					$.ajax({
						type: "POST",
						url: backend.dashboardService +"api/deploytask/start",
						data:{"id":id,"startConfig":startConfig},
						success: function(data){
							if(data.code == -1){
								_self.$notify({
								title: '启动失败',
								message: 'msg: '+data.message,
								type: 'warning',
								position: 'top-left',
								duration: 1000
								})
							}else{
								_self.loading = true;
								setTimeout(() => {
								_self.loading = false;
								}, 1000);
								_self.refresh();
								_self.$notify({
								title: '启动成功',
								position: 'top-left',
								message: '',
								type: 'success',
								duration: 1000
								})
							}
								},
						error:function(obj,msg){
							_self.$notify({
							title: '启动失败',
							message: 'err: '+obj.status,
							position: 'top-left',
							type: 'warning',
							duration: 2000
							})
						}
					});
				},
				stop:function(id){
					_self = this
					_self.$confirm('停止中间件可能造成业务异常', '警告', {
						confirmButtonText: '确定',
						cancelButtonText: '取消',
						type: 'warning'
					}).then(function(){
						
						_self.$notify({
						title: '提示',
						message: '正在停止，请稍后',
						duration: 2000
						});
						$.ajax({
							type: "POST",
							url: backend.dashboardService +"api/deploytask/stop",
							data:{"id":id},
							success: function(data){
								if(data.code == -1){
									_self.$notify({
									title: '关闭失败',
									message: 'msg: '+data.message,
									position: 'top-left',
									type: 'warning',
									duration: 1000
									})
								}else{
									_self.loading = true;
									setTimeout(() => {
									_self.loading = false;
									}, 1000);
									_self.refresh();
									_self.$notify({
									title: '关闭成功',
									message: '',
									position: 'top-left',
									type: 'success',
									duration: 1000
									})
									
								}
								
									},
							error:function(obj,msg){
								_self.$notify({
								title: '关闭失败',
								message: 'err: '+obj.status,
								position: 'top-left',
								type: 'warning',
								duration: 2000
								})
							}
						});
						
					})
					
				
				},
				clickRefresh:function(){
					this.loading = true;
					setTimeout(() => {
					this.loading = false;
					}, 500);
					this.refresh()
				},
				refresh:function(){
					_self = this;
					$.ajax({
						type: "GET",
						url: backend.dashboardService + "/api/middlewareinfo/list?userId=" + userId,
						success: function(data){
							if(data.code != -1){
									_self.infoData = [];
										for(var i=0;i<data.data.length;i++)
										{
											if(data.data[i] != null)
											{
												var info = {
													id:data.data[i]["id"],
													middleWareName:data.data[i]["middleWareName"],
													middleWareVersion:data.data[i]["middleWareVersion"],
													hostName:data.data[i]["hostName"],
													status:data.data[i]["status"],
													startConfig:data.data[i]["startConfig"],
													createdTime:data.data[i]["createdTime"]
												}
												if(data.data[i]["status"] == 1)
												{
													info["startShow"] = false;
												}else{
													info["startShow"] = true;
												}
												_self.infoData.push(info);
											}
										}
									
							}
							
						}
					});
					
				}
			}
        });
    };

});