/**
 * Created by yumeng on 2017/11/26.
 */
define([
],function (require, exports) {

    //page加载完成后调用ready方法
    exports.ready = function (hashCode, data, cite) {
		yufp.lookup.reg("HOST_TYPE");
		var str="(选填)启动参数"
		var queryString = yufp.sessionStorage.get("currentCluster") ? ('/' + yufp.sessionStorage.get("currentCluster")) : '';
        var userId = yufp.sessionStorage.get("userInfo")["id"] == null ? "" : yufp.sessionStorage.get("userInfo")["id"];
		var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var _self = this;
                return {
								middleware:[],
								table0Loading:false,
								hostList:[],
								middlewares:[],
								hostTableVisible:false,
								resultUrl:backend.dashboardService + "/api/deployresult/list?userId=" + userId,
								resultColumns: [
									{label: "id", prop: "id",hidden:true},
									{
										label: "中间件名称",
										prop: "middleWareName",
										dataCode: "MIDDLE_WARE"
									},{
										label: "主机名",
										prop: "hostName"
									}, {
										label: "部署结果",
										prop: "flag",
										template: function () {
																return '<template scope="scope">' +
																					'<el-tooltip class="item" effect="light" v-bind:content="scope.row.msg" placement="right">'+
																						'<span v-if="scope.row.flag == 2" style="color:blue;font-weight:bold">部署成功</span>'+
																						'<span v-if="scope.row.flag == -1" style="color:red;font-weight:bold">部署失败</span>'+
																					'</el-tooltip>'+
																			 '</template>'
														
															}
										},{
										label: "部署时间",
										prop: "createdTime",
										}
								],
								hostUrl:backend.dashboardService + "/api/host/infos" + queryString,
								hostColumns: [
									{label: "id", prop: "id",hidden:true},
									{
										label: "类型",
										prop: "type",
										dataCode: "HOST_TYPE"
									},{
										label: "主机名",
										prop: "hostName"
									},{
										label: "IP",
										prop: "ip"
									}
								],
								deployData: []
							}
            },
						created:function(){
							_self = this;
							yufp.service.request({
									method: 'GET',
									url:backend.dashboardService + "/api/middleware/names",
									callback: function (code, message, response) {
										if (response.code!=-1) {
											for(var i=0;i<response.data.length;i++)
											{
												_self.middlewares.push({label:response.data[i],value:response.data[i]})
											}
										}
									}
								});
						
						},
						mounted:function(){
							this.reload();
							setInterval(_self.refresh, 5000);
						},
            methods: {
							renderHeader:function(createElement, { column, _self }) {
									 return createElement('span',{style:{height:'12px'}},[
												createElement('span', { domProps: {innerHTML: '状态'},style:{'font-size':'12px'}}, []),
												createElement('el-dropdown',{attrs: { trigger: 'click',command:'showList' },},
													[
															
															createElement('i', {'class': 'el-icon-arrow-down el-icon--right',style:{cursor:'pointer',color: 'blue'}}, []),
															createElement('el-dropdown-menu', {attrs: { slot:"dropdown" }}, [
																	createElement('el-dropdown-item', {domProps: {innerHTML: '默认显示'}, nativeOn: {click: _self.showDefaultList}}, []),
																	createElement('el-dropdown-item', {domProps: {innerHTML: '成功任务'},nativeOn: {click: _self.showSuccessfulList}}, []),
																	createElement('el-dropdown-item', {domProps: {innerHTML: '失败任务'},nativeOn: {click: _self.showFailedList}}, []),
																	createElement('el-dropdown-item', {domProps: {innerHTML: '全部任务'},nativeOn: {click: _self.showAllList}}, [])
																	]
															)
													]
												)
											]
										)
									
							},
							operate:function(str){
								_self = this;
								var code = str.split(":")[0];
								var id = str.split(":")[1];
								if(code == 'start')
								{
									this.$message({message: '正在启动', type: 'info'});
								}
								if(code == 'stop')
								{
									this.$message({message: '正在停止', type: 'info'});
								}
								if(code == 'delete')
								{
									
									_self.$confirm('确认删除?', '提示', {
										confirmButtonText: '确定',
										cancelButtonText: '取消',
										type: 'warning'
									}).then(function () {
										
										$.ajax({
											type: "GET",
											url: backend.dashboardService + "/api/deploytask/delete?ids="+id,
											success: function(data){
												if(data.code != -1)
												{
													var index
													for(var i=0;i<_self.deployData.length;i++)
													{
														if(_self.deployData[i]["id"] == id)
														{
															index = i;
															break;
														}
													}
													_self.deployData.splice(index,1);
												}
											}
										});
										
									})
									
									
									
									
									
								}
							},
							showDefaultList:function() {
									this.reload(0);
							},
							showSuccessfulList:function() {
									this.reload(1);
							},
							showFailedList:function() {
									this.reload(-1);
							},
							showAllList:function() {
									this.reload(2);
							},
							nameChange:function(val){
								_self = this;
								if(val != null && val  != "")
								{
									yufp.service.request({
											method: 'GET',
											url:backend.dashboardService + "/api/middleware/version?name="+val,
											callback: function (code, message, response) {
												if (code==0) {
													var versions = [];
													for(var i=0;i<response.data.length;i++)
													{
														versions.push({label:response.data[i],value:response.data[i]})
													}
													for(var i =0 ;i<_self.deployData.length;i++)
													{
														if(_self.deployData[i]["middleWareName"] == val)
														{
															_self.deployData[i]["middleWareVersions"] = versions
														}
													}
												}
											}
										});
								}else{
									var versions = [];
									for(var i =0 ;i<_self.deployData.length;i++)
									{
										if(_self.deployData[i]["middleWareName"] == val)
										{
											_self.deployData[i]["middleWareVersions"] = versions
										}
									}
								}
							},
						reload:function(type){
							this.table0Loading=true;
							setTimeout(() => {
							this.table0Loading = false;
							}, 500);
							//获取默认列表（成功+正在部署）
							url = backend.dashboardService +"api/deploytask/notfailedlist?userId="+userId
							if(type==0)
							{
								//获取默认列表（成功+正在部署）
								url = backend.dashboardService +"api/deploytask/notfailedlist?userId="+userId
							}
							if(type==1)
							{
								//获取成功列表
								url = backend.dashboardService +"api/deploytask/successfullist?userId="+userId
							}
							if(type==-1)
							{
								//获取失败列表
								url = backend.dashboardService +"api/deploytask/failedlist?userId="+userId
							}
							if(type==2)
							{
								//获取所有列表
								url = backend.dashboardService +"api/deploytask/list?userId="+userId
							}
									var _self = this;
										$.ajax({
											type: "GET",
											url: url,
											success: function(data){
												if(data.code != -1)
												{
													_self.deployData=[];
														for(var i=0;i<data.data.length;i++)
														{
															if(data.data[i]["flag"] != 0)
															{
																data.data[i]["versionDisabled"] = true;
																data.data[i]["nameDisabled"] = true;
																data.data[i]["configDisabled"] = true;
																data.data[i]["placeholder"] = "";
															}
															_self.deployData.push(data.data[i]);
														}
												}
											}
										});
						},
						clickrefresh:function(){
							this.table0Loading=true;
							setTimeout(() => {
							this.table0Loading = false;
							}, 500);
							this.refresh()
						},
						refresh:function(){
							var _self = this;
							var ids = [];
							var deployData = this.deployData;
							for(var i=0 ;i<deployData.length;i++)
							{
								ids.push(deployData[i]["id"]);
							}
							if(ids.length>0)
							{
								$.ajax({
									type: "GET",
									url: backend.dashboardService +"api/deploytask/listByIds?ids="+ids,
									success: function(data){
											for(var i=0;i<data.data.length;i++)
											{
												if(data.data[i] != null)
												{
													for(var j= 0;j<deployData.length;j++)
													{
														if(data.data[i]["id"] ==deployData[j]["id"] )
														{
															deployData[j]["flag"] = data.data[i]["flag"]
															deployData[j]["msg"] = data.data[i]["msg"]
															deployData[j]["createdTime"] = data.data[i]["createdTime"]
															if(data.data[i]["flag"] != 0)
															{
																deployData[j]["versionDisabled"] = true;
																deployData[j]["nameDisabled"] = true;
																deployData[j]["configDisabled"] = true;
																deployData[j]["placeholder"] = "";
															}
														}
													}
												}
											}
										}
								});
							}
							
						},
						delete1:function(){
							_self = this;
							var deployData = this.deployData;
							var selections=this.$refs.table0.selection;
							if (selections.length < 1) {
								this.$message({message: '请先选择一条记录', type: 'warning'});
								return;
							}
							for(var i=0;i<selections.length;i++)
							{
								for(var j = 0;j<deployData.length;j++)
								{
									if(selections[i]["id"] ==deployData[j]["id"] )
									{
										_self.deployData.splice(j,1)
									}
								}
							}
							
							
						},
						randomRangeId:function(num){
								var returnStr = "",       
										charStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'; 
								for(var i=0; i<num; i++){
										var index = Math.round(Math.random() * (charStr.length-1));
										returnStr += charStr.substring(index,index+1);
								}
								return returnStr;
						},
						deploy1:function(id){
							for(var i = 0;i<this.deployData.length;i++)
							{
								if(id == this.deployData[i]["id"] && (this.deployData[i]["flag"] ==0 ||this.deployData[i]["flag"] ==-1))
								{
									var names = [];
									var versions = [];
									var startConfigs = [];
									var hostNames = [];
									var ids = [];
									if(this.deployData[i]["middleWareName"] == null || this.deployData[i]["middleWareName"]=="")
									{
										this.$message({message: '请将中间件名称填写完整', type: 'warning'});
										return;
									}else{
										names.push(this.deployData[i]["middleWareName"])
									}
									if(this.deployData[i]["middleWareVersion"] == null || this.deployData[i]["middleWareVersion"] =="")
									{
										this.$message({message: '请将版本信息名称填写完整', type: 'warning'});
										return;
									}else{
										versions.push(this.deployData[i]["middleWareVersion"])
									}
									ids.push(this.deployData[i]["id"]);
									startConfigs.push(this.deployData[i]["startConfig"])
									hostNames.push(this.deployData[i]["hostName"])
									this.deployData[i]["flag"]="1";
									this.deployData[i]["msg"]= "请稍后";
									this.deployData[i]["versionDisabled"] = true;
									this.deployData[i]["nameDisabled"] = true;
									this.deployData[i]["configDisabled"] = true;
									this.deployData[i]["placeholder"] = "";
									
									$.ajax({
										type: "POST",
										url: backend.dashboardService +"api/middlewaredeploy/",
										data:{"ids":ids.join(","), "names":names.join(","),"startConfigs":startConfigs.join(","),"hostNames":hostNames.join(","),"versions":versions.join(","),"userId":userId == null ? "":userId},
										success: function(data){
												}
									});
								}
							}
							
						},
// 						deploy:function(){
// 							if(this.deployData.length ==0)
// 							{
// 								this.$message({message: '请至少先选择一台主机', type: 'warning'});
// 								return;
// 							}
// 							var selections=this.$refs.table0.selection;
// 							if (selections.length < 1) {
// 								this.$message({message: '请先选择一个任务', type: 'warning'});
// 								return;
// 							}
// 							
// 							var deployData = [];
// 							for(var i = 0;i<selections.length;i++)
// 							{
// 								if(this.deployData[i]["flag"] == 0 || this.deployData[i]["flag"] == -1)
// 								{
// 									deployData.push(this.deployData[i]);
// 								}
// 							}
// 							var names = [];
// 							var versions = [];
// 							var startConfigs = [];
// 							var hostNames = [];
// 							var ids = [];
// 							for(var i=0;i<deployData.length;i++)
// 							{
// 								if(deployData[i]["middleWareName"] == null || deployData[i]["middleWareName"]=="")
// 								{
// 									this.$message({message: '请将中间件名称填写完整', type: 'warning'});
// 									return;
// 								}else{
// 									names.push(deployData[i]["middleWareName"])
// 								}
// 								if(deployData[i]["middleWareVersion"] == null || deployData[i]["middleWareVersion"] =="")
// 								{
// 									this.$message({message: '请将版本信息名称填写完整', type: 'warning'});
// 									return;
// 								}else{
// 									versions.push(deployData[i]["middleWareVersion"])
// 								}
// 								ids.push(deployData[i]["id"]);
// 								startConfigs.push(deployData[i]["startConfig"])
// 								hostNames.push(deployData[i]["hostName"])
// 								deployData[i]["flag"]="1";
// 								deployData[i]["msg"]= "请稍后";
// 								deployData[i]["versionDisabled"] = true;
// 								deployData[i]["nameDisabled"] = true;
// 								deployData[i]["configDisabled"] = true;
// 								deployData[i]["placeholder"] = "";
// 							}
// 								 $.ajax({
// 									 type: "POST",
// 									 url: backend.dashboardService +"api/middlewaredeploy/",
// 									 data:{"ids":ids.join(","), "names":names.join(","),"startConfigs":startConfigs.join(","),"hostNames":hostNames.join(","),"versions":versions.join(","),"userId":userId == null ? "":userId},
// 									 success: function(data){
// 												}
// 								 });
// 								 this.$message({message: '后台已开始部署，下方日志可查看结果', type: 'success'});
// 		// 					yufp.service.request({
// 		// 							method: 'POST',
// 		// 							url: backend.dashboardService +"api/middlewaredeploy/",
// 		// 							data:{"name":name,"hostNames":hostNames,"version":"9.0.10","userId":userId == null ? "":userId},
// 		// 							callback: function (code, message, response) {
// 		// 									_self.$message('开始部署');
// 		// 							}
// 		// 						});
// 						},
						showHosts:function(){
							this.hostTableVisible=true
						},
						confirm1:function(){
							
							_self = this;
								var selections=this.$refs.hostTable.selections;
								if (selections.length < 1) {
									this.$message({message: '请先选择一台主机', type: 'warning'});
									return;
								}
								var len=selections.length > 10 ? 10:selections.length;
								for(var i=0;i<len;i++){
									var id = _self.randomRangeId(32);
									var item = {
										id:id,
										ip:selections[i]["ip"],
										hostName:selections[i]["hostName"],
										middleWareName:"",
										middleWareVersion:"",
										middleWareVersions:[],
										flag:"0",
										startConfig:"",
										placeholder:str,
										msg:""
									}
									this.deployData.unshift(item)
								}
								this.hostTableVisible=false
								this.$refs.hostTable.remoteData();
								
							
							
							
						}
					}
						});
				};
		
});