/**
 * 微服务配置
 */
define(function (require, exports) {
    exports.ready = function (hashCode, data, cite) {
        var vm = yufp.custom.vue({
            el: '#microServiceConfig',
            data: function () {
                var me = this;
                var itemValid = function(rule,value,callback){
                    if(me.addFlag){
                        yufp.service.request({
                            method:"GET",
                            url:backend.dashboardService + '/conf/getCfg/' + me.serviceName,
                            callback:function(code,message,response){
                                if(code=='0'){
                                    var responseData = response.data;
                                    for(var k in responseData){
                                        if(value==k){
                                            callback(new Error("该配置项已存在"));
                                        }
                                    }
                                }
                                callback();
                            }
                        });
                    }else{
                        callback();
                    }
                };
                return {
                    applicationsUrl: backend.dashboardService + '/conf/getApps',
                    height: yufp.frame.size().height - 92 - 10,
                    serviceName: '',
                    buttonEnable: true,
                    addEnable:true,
                    viewEnable:true,
                    tabDisplay:true,
                    yamlDisplay:false,
                    viewTitle: '',
                    tableColumns: [
                        {label: '服务名称', prop: 'name'}
                    ],
                    addFlag:false,
                    config: {
                        url: backend.dashboardService + '/conf/getCfg/'+me.serviceName,
                        columns: [
                            {label: '配置项', prop: 'configItem', sortable:true},
                            {label: '配置值', prop: 'configValue', sortable:true}
                        ],
                        data:[],
                        height: yufp.frame.size().height - 92 - 10,
                        formFields: [{
                            columnCount: 2,
                            fields: [
                                {field: 'configItem', label: '配置项',rules:[{
                                    required: true, message: '必填项', trigger: 'blur'
                                },{
                                    validator:itemValid,trigger:'blur'
                                }]},
                                {
                                    field: 'configValue', label: '配置值', rules: [{
                                    required: true, message: '必填项', trigger: 'blur'
                                }]
                                }
                            ]
                        }],
                        buttons: [
                            {
                                label: '取消', type: 'primary', icon: 'yx-undo2', click: function () {
                                me.$refs.configForm.resetFn();
                                me.dialogVisible = false;
                                me.addFlag = false;
                            }
                            },
                            {
                                label: '保存',
                                type: 'primary',
                                icon: 'check',
                                op: 'submit',
                                click: function (model, valid) {
                                    if (valid) {
                                        me.saveInfoFn(model);
                                    }
                                }
                            }
                        ]
                    },
                    dialogVisible: false,
                    configInfo:''
                }
            },
            methods: {
                //服务列表点击
                rowClickFn: function (row) {
                    this.serviceName = row.name;
                    this._id = row.id;
                    this.addEnable = false;
                    this.viewEnable = false;
                    if(this.tabDisplay){
                        this.configInfoQuery();
                    }
                    if(this.yamlDisplay){
                        this.yamlInfo();
                    }
                },
                //配置信息查询
                configInfoQuery:function(){
                    var me = this;
                    yufp.service.request({
                        method:"GET",
                        url:backend.dashboardService + '/conf/getCfg/' + me.serviceName,
                        callback:function(code,message,response){
                            if(code=='0'){
                                var configInfoTmp = [];
                                var responseData = response.data;
                                for(var k in responseData){//遍历json对象的每个key/value对,k为key
                               	 configInfoTmp.push(
                                         {configItem:k,configValue:responseData[k]}
                                     );
                                	}
                                me.$refs.configTable.data = configInfoTmp;
                            }
                        }
                    });
                },
                //配置信息列表点击
                configClickFn: function (row) {
                    this.buttonEnable = false;
                },
                //配置下发
                confRefresh:function(){
                    var data = this.$refs.applicationsTable.selections;
                    if (data.length<1) {
                        this.$message("请选择一条数据!")
                        return;
                    }
                    var me = this;
                    me.$confirm('该操作将使该服务配置下发,是否继续','提示',{
                        confirmButtonText:'确定',
                        cancelButtonText:'取消',
                        type:'warning'
                    }).then(function(){
                        yufp.service.request({
                            method:'GET',
                            url:backend.dashboardService+'/conf/refreshAll/'+ me._id,
                            callback:function(code,message,response){
                                if(code=='0'){
                                    me.$message('服务配置下发成功');
                                }else{
                                    me.$message('服务配置下发失败');
                                }
                            }
                        });
                    }).catch(function(){
                        return;
                    })
                },
                //下发所有
                confRefreshAll:function(){
                    var me = this;
                    me.$confirm('该操作将使所有服务配置下发,是否继续','提示',{
                        confirmButtonText:'确定',
                        cancelButtonText:'取消',
                        type:'warning'
                    }).then(function(){
                        yufp.service.request({
                           method:'GET',
                            timeout: 20000,
                           url:backend.dashboardService+'/conf/refreshAll',
                            callback:function(code,message,response){
                               if(code=='0'){
                                   me.$message('服务配置下发成功');
                               }else{
                                   me.$message('服务配置下发失败');
                               }
                            }
                        });
                    }).catch(function(){
                        return;
                    })
                },
                //新增
                addConfig:function(){
                    this.viewTitle = '配置信息新增';
                    this.dialogVisible = true;
                    this.$refs.configTable.clearSelection();
                    this.addFlag = true;
                    this.$nextTick(function(){
                        this.$refs.configForm.resetFn();
                        this.$refs.configForm.switch('configItem','disabled',false);
                    });
                },
                //修改
                editConfig: function () {
                    this.viewTitle = '配置信息修改';
                    var data = this.$refs.configTable.selections;
                    if (data == null || data.length != 1) {
                        this.$message("请选择一条数据!")
                        return;
                    }
                    this.dialogVisible = true;
                    this.addFlag = false;
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.configForm.formModel, this.$refs.configTable.selections[0]);
                        this.$refs.configForm.rebuildFn();
                        this.$refs.configForm.switch('configItem','disabled',true);
                    });
                },
                //保存信息
                saveInfoFn:function(model){
                    var me = this;
                    var commitData = me.$refs.configTable.data;
                    var temp='';
                    if(me.addFlag){
                        commitData.push(model);
                    }
                    for(var key in commitData){
                        if(!me.addFlag && commitData[key].configItem==model.configItem){
                            commitData[key].configValue = model.configValue
                        }
                        temp = temp + ',' + '"' + commitData[key].configItem + '"' + ':'+ '"' + commitData[key].configValue + '"';
                    }
                    temp = '{'+ temp.substr(1) +'}';
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService + '/conf/updateCfg/' + me._id,
                        data:{
                            content:temp
                        },
                        callback: function (code, message, response) {
                            if (code == '0') {
                                me.$message('保存成功');
                                me.dialogVisible = false;
                                me.addFlag = false;
                                me.configInfoQuery();
                            }
                        }
                    });
                },
                //删除
                deleteConfig: function () {
                    var me = this;
                    var temp = "";
                    var data = me.$refs.configTable.selections;
                    if (data == null || data.length < 1) {
                        me.$message("请至少选择一条数据!")
                        return;
                    }
                    var delCommitData = me.$refs.configTable.data;
                    var count = 0;
                    for(var key in delCommitData){
                        count = 0;
                        for (var i = 0; i < data.length; i++) {
                            if(delCommitData[key].configItem == data[i].configItem && delCommitData[key].configValue == data[i].configValue){
                                count++;
                                break;
                            }
                        }
                        if(count==0){
                            temp = temp + ',' + '"' + delCommitData[key].configItem + '"' + ':'+ '"' + delCommitData[key].configValue + '"';
                        }
                    }
                    temp = '{'+ temp.substr(1) +'}';

                    me.$confirm('确认删除配置信息?', '提示', {
                        confirmButtonText: '确认',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function () {
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/conf/updateCfg/' + me._id,
                            data:{
                                content:temp
                            },
                            callback: function (code, message, response) {
                                if (code == '0') {
                                    me.$message('删除成功');
                                    me.configInfoQuery();
                                } else {
                                    me.$message('删除失败');
                                }
                            }
                        });
                    }).catch(function(){
                        return;
                    });
                },
                //YAML格式查看
                yamlInfo:function(){
                    var me = this;
                    me.tabDisplay = false;
                    me.yamlDisplay = true;
                    me.addEnable = true;
                    me.buttonEnable = true;
                    yufp.service.request({
                        method:'GET',
                        url:backend.dashboardService+'/conf/getCfgAsText/'+me.serviceName,
                        callback:function(code,message,response){
                            if(code=='0'){
                                me.configInfo =  response.data;
                            }
                        }
                    });
                },
                //key-value表格格式查看
                tabInfo:function(){
                    var me = this;
                    me.tabDisplay = true;
                    me.yamlDisplay = false;
                    me.addEnable = false;
                    me.configInfoQuery();
                }
            }
        })
    }
});