/**
 * @Authoer: dusong
 * @Description: 实例管理
 * @Date 2018/3/7
 * @Modified By:
 *
 */
define(function (require, exports) {

    exports.ready = function (hashCode, data, cite){

        var vm;
        vm = yufp.custom.vue({
            el: cite.el,
            data:function() {
                var me = this;
                var queryString = yufp.sessionStorage.get("currentCluster") ? ('applist/?cluster=' + yufp.sessionStorage.get("currentCluster")) : '';
                return {
                    applicationInstance: {
                        currentRow: null,
                        data: null,
                        total: null,
                        dataUrl: backend.dashboardService+'/api/instancemanager/' + queryString,
                        height: yufp.frame.size().height - 92 - 10,
                        tableColumns: [
                            { label: '服务名称', prop: 'name',  resizable: true },
                            { label: '数量', prop: 'instances', width:100, resizable: true,formatter:function(row){
                                var upCount = 0;
                                 for(var i=0; i < row.instances.length; i++){

                                     if (row.instances[i].status === "UP"){
                                         upCount++;
                                     }
                                 }
                                 if (me.instanceData.data === null){
                                    me.instanceData.data = row.instances;
                                    me.instanceData.name = row.name;
                                 }
                                 return upCount + "/" + row.instances.length;
                                }
                            }
                        ],
                    },
                    instanceData: {
                        currentRow: null,
                        name: "",
                        data: null,
                        height:yufp.frame.size().height - 92 - 10,
                        updateFields: [{
                            columnCount: 2,
                            fields: [
                            { field: 'name', label: '实例', disabled:true },
                            { field: 'url', label: 'URL' , disabled:true },
                            { field: 'ip', label: 'IP' , disabled:true },
                             { field: 'port', label: 'port' , disabled:true },
                            { field: 'version',label: '版本', disabled:true  },
                            { field: 'status',label: '状态' , disabled:true},
                            { field: 'weighted', label: '权重',rules:[
                                    {required: true, message: '必填项', trigger: 'blur'},
                                    {max:2,message:'输入值过长',trigger:'blur'}
                                ]},
                            { field: 'lable', label: '标签' , rules:[
                                    {required: true, message: '必填项', trigger: 'blur'},
                                    {max:100,message:'输入值过长',trigger:'blur'}
                                ]}
                            ]
                        }],
                        piDialog: 'details',
                        details: ['healthChecks','memory','JVM'],
                        env:['Profiles','ServerPorts'],
                        threads:['count','list']
                    },
                    instanceUpdateData: {
                        currentRow: null,
                        name: "",
                        data: null,
                        height:yufp.frame.size().height - 92 - 10,
                        piDialog: 'details',
                        details: ['healthChecks','memory','JVM'],
                        env:['Profiles','ServerPorts'],
                        threads:['count','list']
                    },
                    dialogInstanceVisible: false,
                    dialogTraceDetailVisible: false,
                    dialogThreadDetailVisible: false,
                    dialogPiVisible: false,
                    healthData: null,
                    memoryData: null,
                    jvmData: null,
                    gcData: null,
                    containerData: null,
                    countersData: null,
                    jvmMetricsData: null,
                    profilesData: null,
                    serverPortsData: null,
                    systemPropertiesData: null,
                    systemEnvironmentData: null,
                    applicationConfigData: null,
                    springCloudClientHostInfoData: null,
                    defaultPropertiesData:null,
                    threadsData: null,
                    threadsCount: null,
                    traceData: null,
                    jvmDataUpdateTime: '',
                    threadDetail: null,
                    traceDetail: null,
                    hour:0,
                    minute:0,
                    second:0,
                    millisecond: 0,
                    day:0,
                    textMap: {
                        update: '设置',
                        console: '控制台'
                    },
                    requestData:null,
                    requestTotal:0,
                    activeRequests:0,
                    totalThreads:0,
                    runnableNum:0,
                    runnableWidth:'',
                    memoryDataList:[],
                    threadDataList:[],
                    consoleInfo: {
                        visible: false,
                        data: null,
                        loading:false
                    },
                    buttonsts: {
                        offline: false,
                        puase: false,
                        restart: false,
                        shutdown: false,
                        kpi:false,
                        hystrix: false,
                        set:false,
                        console:false
                    }

                }
            },
            mounted: function () {
            },
            methods: {
                rowClickFn: function (row,index) {
                    this.applicationInstance.currentRow = this.$refs.applicationInstance.selections[0];
                    this.instanceData.data = row.instances;
                    this.instanceData.name = row.name;
                    this.instanceData.currentRow = null;
                },
                rowListClickFn: function (row,index) {
                    this.instanceData.currentRow = row;
                    this.updateButtonsSts(row);
                },
                queryMainGridFn: function () {
                    var me = this;
                    me.$refs.applicationInstance.remoteData();
                },
                showHystrix: function () {
                    if (this.instanceData.currentRow === null) {
                        this.$message({message: '请选择一条数据', type: 'warning'});
                        return;
                    }
                    var row = this.instanceData.currentRow;

                    var url = '/#/circuit-breaker/instance/' + row.id.replace('@','_');

                    window.open (url, "apiwindow", "height=800, width=1000, toolbar =no, menubar=yes,scrollbars=yes, resizable=no, location=no, status=no");
                },
                opInstance: function (opType) {
                    var me=this;
                    var row = this.instanceData.currentRow;
                    if (this.instanceData.currentRow === null) {
                        this.$message({message: '请选择一条数据', type: 'warning'});
                        return;
                    }

                    if ((row.status === "UNKNOWN" || row.status === "OFFLINE") &&
                        opType != 'offrestart'){
                        this.$message({message:"实例["+row.id+"]"+row.status+"状态，无法执行操作!", type: 'warning'});
                        return;
                    }

                    if (opType === 'restart'){
                        if (row.status != "DOWN" ){
                            this.$message({message:"实例["+row.id+"]"+row.status+"状态，无法执行操作!", type: 'warning'});
                            return;
                        }
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/instancemanager/' + row.id + '/restart',
                            data: null,
                            callback: function (code, message, response) {
                                me.$message({message: '操作成功', type: 'success'});
                                me.queryMainGridFn();
                            }
                        });
                    }else if (opType === 'pause'){
                        if (row.status != "UP" ){
                            this.$message({message:"实例["+row.id+"]"+row.status+"状态，无法执行操作!", type: 'warning'});
                            return;
                        }
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/instancemanager/' + row.id + '/pause',
                            data: null,
                            callback: function (code, message, response) {
                                me.$message({message: '操作成功', type: 'success'});
                                me.queryMainGridFn();
                            }
                        });
                    }else if (opType === 'shutdown'){
                        if (row.status != "UP" ){
                            this.$message({message:"实例["+row.id+"]"+row.status+"状态，无法执行操作!", type: 'warning'});
                            return;
                        }
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/instancemanager/' + row.id + '/shutdown',
                            data: null,
                            callback: function (code, message, response) {
                                me.$message({message: '操作成功', type: 'success'});
                                me.queryMainGridFn();
                            }
                        });
                    }else if (opType === 'offrestart'){//掉线重启
                        var param = row;
                        if (row.status != "OFFLINE" ){
                            this.$message({message:"实例["+row.id+"]"+row.status+"状态，无法执行操作!", type: 'warning'});
                            return;
                        }

                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/instancemanager/start',
                            data: param,
                            callback: function (code, message, response) {
                                me.$message({message: '操作成功', type: 'success'});
                                    me.queryMainGridFn();
                            }
                        });
                    }
                },
                openPi: function () { //指标查看
                    if (this.instanceData.currentRow === null) {
                        this.$message({message: '请选择一条数据', type: 'warning'});
                        return;
                    }
                    this.dialogPiVisible = true;
                    this.instanceData.piDialog = 'overView';
                    this.instanceData.details = 'healthChecks';
                    this.loadDetailsData();
                    this.loadThreadsData();
                },
                // openInstance: function () { //权重设置
                //
                //     var row = this.instanceData.currentRow;
                //
                //     if (this.instanceData.currentRow === null) {
                //         this.$message({message: '请选择一条数据', type: 'warning'});
                //         return;
                //     }
                //
                //     if (row.status === "UNKNOWN" || row.status === "OFFLINE") {
                //         this.$message({message:"实例["+row.id+"]"+row.status+"状态，无法执行操作!", type: 'warning'});
                //         return;
                //     }
                //
                //     var me = this;
                //     this.dialogInstanceVisible = true;
                //     this.$nextTick(function () {
                //         me.$refs.instanceDialogform.resetFields();
                //         yufp.extend(me.$refs.instanceDialogform.formModel, me.instanceData.currentRow );
                //     });
                // },
                openInstance: function () { //权重设置
                    var me = this;
                    this.dialogInstanceVisible = true;
                    this.$nextTick(function () {
                        //var tmp = null;
                        //yufp.extend(tmp, me.instanceData.data );
                        me.instanceUpdateData.data = me.instanceData.data;
                    });
                },
                piClick: function(tab, val) { //指标对话框点击事件

                    if (tab.name === 'details') {
                        this.loadDetailsData();
                    } else if (tab.name === 'env') {
                        this.loadEnvData();
                    } else if (tab.name === 'threads') {
                        this.loadThreadsData();
                    } else if (tab.name === 'trace') {
                        this.loadTraceData();
                    }
                },
                detailsClick: function (val) {

                },
                loadDetailsData: function () {  //加载指标信息-明细
                    var me = this;
                    var row = this.instanceData.currentRow;

                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/' + row.id + '/health/',
                        data: null,
                        callback: function (code, message, response) {
                            //vue.$message({message: '操作成功', type: 'success'});

                            if (code === 0 && response.code === 0){
                                var  responseData = JSON.parse(response.data);
                                var keyList = [
                                    {name:'discoveryComposite',path:'discoveryComposite',descpath:'description',status:'',description:''},
                                    {name:'discoveryClient',path:'discoveryComposite.discoveryClient',descpath:'description',status:'',description:''},
                                    {name:'eureka',path:'discoveryComposite.eureka',descpath:'description',status:'',description:''},
                                    {name:'hystrix',path:'hystrix',descpath:'',status:'',description:''},
                                    {name:'configServer',path:'configServer',descpath:'propertySources',status:'',description:''},
                                    {name:'db',path:'db',descpath:'database',status:'',description:''},
                                    {name:'diskSpace',path:'diskSpace',descpath:'',status:'',description:''},
                                    {name:'redis',path:'redis',descpath:'',status:'',description:''}];

                                for(var i = 0; i < keyList.length; i++){
                                    var  _obj = responseData;
                                    _obj = me.findObj(responseData,keyList[i].path)

                                    keyList[i].status = _obj.status;
                                    if ('diskSpace' === keyList[i].name) {
                                        keyList[i].description = "Free:" + (_obj["free"]/1024/1024/1024).toFixed(2)+'G';
                                    }else {
                                        keyList[i].description = _obj[keyList[i].descpath];
                                    }
                                }

                                me.healthData = keyList;
                            } else {

                            }
                        }
                    });

                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/' + row.id + '/metrics.json/',
                        data: null,
                        callback: function (code, message, response) {
                            if (code === 0 && response.code === 0){

                                var  responseData = JSON.parse(response.data);

                                //memoryTmp begin
                                var memoryTmp = [
                                    {name:'Total Memory Free', value: Math.ceil(responseData['mem.free']/1024) +'M/' + Math.ceil(responseData['mem']/1024)+'M'},
                                    {name:'Heap Memory Used',value:Math.ceil(responseData['heap.used']/1024) +'M/' + Math.ceil(responseData['heap.committed']/1024)+'M'},
                                    {name:'Initial Heap (-Xms)',value:Math.ceil(responseData['heap.init']/1024)+'M'},
                                    {name:'Maximum Heap (-Xmx)',value:Math.ceil(responseData['heap']/1024)+'M'}];

                                var memoryUsed = (responseData['mem']/1024- responseData['mem.free']/1024).toFixed(2);
                                var mem = (responseData['mem']/1024).toFixed(2);
                                var memoryWidth = ((memoryUsed/mem)*100).toFixed(2);

                                var heapUsed = (responseData['heap.used']/1024).toFixed(2);
                                var heapCommit = (responseData['heap.committed']/1024).toFixed(2);
                                var heapWidth = ((heapUsed/heapCommit)*100).toFixed(2);

                                var nonHeapUsed = (responseData['nonheap.used']/1024).toFixed(2);
                                var nonHeapCommit = (responseData['nonheap.committed']/1024).toFixed(2);
                                var nonHeapWidth = ((nonHeapUsed/nonHeapCommit)*100).toFixed(2);

                                me.memoryDataList = [];
                                me.memoryDataList.push(
                                    {title:'总内存',used:memoryUsed,total:mem,width:memoryWidth},
                                    {title:'堆内存',used:heapUsed,total:heapCommit,width:heapWidth},
                                    {title:'非堆内存',used:nonHeapUsed,total:nonHeapCommit,width:nonHeapWidth}
                                );
                                for(var k in me.memoryDataList){
                                    if(me.memoryDataList[k].width>0&&me.memoryDataList[k].width<=80){
                                        me.memoryDataList[k].bgColor = '#20a0ff';
                                    }else if(me.memoryDataList[k].width>80&&me.memoryDataList[k].width<=90){
                                        me.memoryDataList[k].bgColor = '#f7ba2a';
                                    }else if(me.memoryDataList[k].width>90&&me.memoryDataList[k].width<=100){
                                        me.memoryDataList[k].bgColor = '#ff4949';
                                    }
                                }

                                //memoryTmp end

                                //jvmTmp begin
                                var date = new Date();
                                date.setTime(responseData['uptime']);
                                me.second = date.getSeconds();
                                me.minute = date.getMinutes();
                                me.hour = date.getHours();
                                me.day = Math.floor((responseData['uptime'])/(1000*60*60*24));
                                //刷新频率1S
                                setInterval(function(){
                                    me.timeAdd(me);
                                },1000);

                                var jvmTmp = [
                                    {name:'Uptime', value: me.jvmDataUpdateTime},
                                    {name:'Available Processors',value:responseData['processors']},
                                    {name:'Current loaded Classes',value:responseData['classes']},
                                    {name:'Total loaded Classes',value:responseData['classes.loaded']},
                                    {name:'Unloaded Classes',value:responseData['classes.unloaded']},
                                    {name:'Threads',value:responseData['threads'] + ' total / ' +  responseData['threads.daemon'] + ' daemon / ' + responseData['threads.peak'] +' peak '}];
                                //jvmTmp end

                                var gcTmp = [
                                    {name:'Gc ps_scavenge Count', value: responseData['gc.ps_scavenge.count']},
                                    {name:'Gc ps_scavenge Time', value: responseData['gc.ps_scavenge.time' ]+'ms'},
                                    {name:'Gc ps_marksweep Count', value: responseData['gc.ps_marksweep.count']},
                                    {name:'Gc ps_marksweep Time', value: responseData['gc.ps_marksweep.time']+'ms'}
                                ];

                                var containerTmp = [
                                    {name:'Servlet Container', value: responseData['httpsessions.active'] +' active / '+ responseData['httpsessions.max'] == -1 ? 'unlimited' : responseData['httpsessions.max'] + ' max'},
                                    {name:'Datasource Connections', value: 'active: '+ responseData['datasource.primary.active'] + ',usage:' + responseData['datasource.primary.usage']*100+'%'}
                                ];

                                var jvmMetricsTmp = [];

                                for (var key in responseData){
                                    if (key.substr(0,3) === 'jvm'){
                                        jvmMetricsTmp.push({name:key,value:responseData[key]});
                                    }
                                }
                                //刷新页面数据
                                me.memoryData = memoryTmp;  //内存
                                me.jvmData = jvmTmp;  //JVN参数
                                me.gcData = gcTmp;
                                me.containerData = containerTmp;
                                me.jvmMetricsData = jvmMetricsTmp;

                                //HTTP Request
                                var okCount = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.ok.count'];
                                var okMean = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.ok.meanRate'].toFixed(2);
                                var okAveOne = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.ok.oneMinuteRate'].toFixed(2);
                                var okAveFive = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.ok.fiveMinuteRate'].toFixed(2);
                                var okAveFifteen = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.ok.fifteenMinuteRate'].toFixed(2);
                                var notFoundCount = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.notFound.count'];
                                var notMean = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.notFound.meanRate'].toFixed(2);
                                var notAveOne = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.notFound.oneMinuteRate'].toFixed(2);
                                var notAveFive = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.notFound.fiveMinuteRate'].toFixed(2);
                                var notAveFifteen = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.notFound.fifteenMinuteRate'].toFixed(2);
                                var serverErrorCount = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.serverError.count'];
                                var serverMean = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.serverError.meanRate'].toFixed(2);
                                var serverAveOne = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.serverError.oneMinuteRate'].toFixed(2);
                                var serverAveFive = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.serverError.fiveMinuteRate'].toFixed(2);
                                var serverAveFifteen = responseData['com.codahale.metrics.servlet.InstrumentedFilter.responseCodes.serverError.fifteenMinuteRate'].toFixed(2);
                                var requestDataList = [];
                                me.activeRequests = responseData['com.codahale.metrics.servlet.InstrumentedFilter.activeRequests'];
                                me.requestTotal = okCount+notFoundCount+serverErrorCount;
                                requestDataList.push(
                                    {code:'OK',count:okCount,mean:okMean,aveOne:okAveOne,aveFive:okAveFive,aveFifteen:okAveFifteen,styleWidth:(okCount/me.requestTotal)*100+'%'},
                                    {code:'Not Found',count:notFoundCount,mean:notMean,aveOne:notAveOne,aveFive:notAveFive,aveFifteen:notAveFifteen,styleWidth:(notFoundCount/me.requestTotal)*100+'%'},
                                    {code:'Server Error',count:serverErrorCount,mean:serverMean,aveOne:serverAveOne,aveFive:serverAveFive,aveFifteen:serverAveFifteen,styleWidth:(serverErrorCount/me.requestTotal)*100+'%'}
                                )
                                me.requestData = requestDataList;
                                //HTTP Request End
                            } else {

                            }

                        }
                    });
                },
                loadEnvData: function () {  //加载指标信息-环境变量
                    var me = this;
                    var row = this.instanceData.currentRow;
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/' + row.id + '/env/',
                        data: null,
                        callback: function (code, message, response) {
                            //vue.$message({message: '操作成功', type: 'success'});

                            if (code === 0 && response.code === 0){
                                var  responseData = JSON.parse(response.data);

                                var profilesTmp = [];
                                var serverPortsTmp = [];
                                var systemPropertiesTmp = [];
                                var systemEnvironmentTmp = [];
                                var applicationConfigTmp = [];
                                var springCloudClientHostInfoTmp = [];
                                var defaultPropertiesTmp = [];
                                var profiles = responseData['profiles'];
                                for (var key in profiles){
                                    profilesTmp.push({name:profiles[key]});
                                }

                                var serverPorts = responseData['server.ports'];
                                for (var key in serverPorts){
                                    serverPortsTmp.push({name:key, value:serverPorts[key]});
                                }

                                var systemProperties = responseData['systemProperties'];
                                for (var key in systemProperties){
                                    systemPropertiesTmp.push({name:key, value:systemProperties[key]});
                                }

                                var systemEnvironment = responseData['systemEnvironment'];
                                for (var key in systemEnvironment){
                                    systemEnvironmentTmp.push({name:key, value:systemEnvironment[key]});
                                }

                                var applicationConfig;
                                for (var fileKey in responseData){
                                    if (fileKey.substr(0,17) === 'applicationConfig'){
                                        applicationConfig = responseData[fileKey];

                                        for (var key in applicationConfig){
                                            applicationConfigTmp.push({file:fileKey.substr(fileKey.indexOf('/',-1),fileKey.length-fileKey.indexOf('/',-1)-1), name:key, value:applicationConfig[key]});
                                        }
                                    }
                                }

                                var springCloudClientHostInfo = responseData['springCloudClientHostInfo'];
                                for (var key in springCloudClientHostInfo){
                                    springCloudClientHostInfoTmp.push({name:key, value:springCloudClientHostInfo[key]});
                                }

                                var defaultProperties = responseData['defaultProperties'];
                                for (var key in defaultProperties){
                                    defaultPropertiesTmp.push({name:key, value:defaultProperties[key]});
                                }
                                me.profilesData = profilesTmp;
                                me.serverPortsData = serverPortsTmp;
                                me.systemPropertiesData = systemPropertiesTmp;
                                me.systemEnvironmentData = systemEnvironmentTmp;
                                me.applicationConfigData = applicationConfigTmp;
                                me.springCloudClientHostInfoData = springCloudClientHostInfoTmp;
                                me.defaultPropertiesData = defaultPropertiesTmp;
                            } else {

                            }
                        }
                    });
                },
                loadThreadsData: function () {  //加载指标信息-线程信息

                    var me = this;
                    var row = this.instanceData.currentRow;
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/' + row.id + '/dump/',
                        data: null,
                        callback: function (code, message, response) {
                            //vue.$message({message: '操作成功', type: 'success'});

                            if (code === 0 && response.code === 0){
                                var responseData = JSON.parse(response.data);
                                var threadStateList = {
                                    RUNNABLE: 0,
                                    TIMED_WAITING:0,
                                    WAITING:0
                                };
                                for (var key in responseData){
                                    if (responseData[key].threadState === 'RUNNABLE'){
                                        threadStateList.RUNNABLE++;
                                    } else if (responseData[key].threadState === 'TIMED_WAITING'){
                                        threadStateList.TIMED_WAITING++;
                                    } else if (responseData[key].threadState === 'WAITING'){
                                        threadStateList.WAITING++;
                                    }
                                }

                                me.threadsCount = [{name:'RUNNABLE:',value:threadStateList.RUNNABLE},
                                    {name:'TIMED_WAITING',value:threadStateList.TIMED_WAITING},
                                    {name:'WAITING',value:threadStateList.WAITING}];
                                me.threadsData = responseData;

                                me.totalThreads = threadStateList.RUNNABLE+threadStateList.TIMED_WAITING+threadStateList.WAITING;
                                me.runnableNum = threadStateList.RUNNABLE;
                                me.runnableWidth = ((me.runnableNum/me.totalThreads)*100).toFixed(2)+'%';

                                me.threadDataList = [];
                                me.threadDataList.push(
                                    {title:'限时等待',num:threadStateList.TIMED_WAITING,width:((threadStateList.TIMED_WAITING/me.totalThreads)*100).toFixed(2)+'%'},
                                    {title:'等待',num:threadStateList.WAITING,width:((threadStateList.WAITING/me.totalThreads)*100).toFixed(2)+'%'}
                                );

                            } else {

                            }
                        }
                    });
                },
                loadTraceData: function () {  //加载指标信息-trace信息
                    var me = this;
                    var row = this.instanceData.currentRow;
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/' + row.id + '/trace/',
                        data: null,
                        callback: function (code, message, response) {
                            //vue.$message({message: '操作成功', type: 'success'});

                            if (code === 0 && response.code === 0){
                                var responseData = JSON.parse(response.data);
                                me.traceData = responseData;
                            } else {
                            }
                        }
                    });
                },
                findObj: function(_obj,path){ //根据路径，获取对象
                    var _path = path.split(".");
                    _path.forEach(function(item,index,array){
                        if (_obj.hasOwnProperty(item)) {
                            _obj=_obj[item];
                        }else{
                            _obj={};
                        }
                    });
                    return _obj;
                },
                timeAdd: function(me){ //时间在线刷新
                    me.millisecond=me.millisecond+1000;
                    if(me.millisecond>=1000)
                    {
                        me.second=this.second+1;
                    }
                    if(me.second>=60)
                    {
                        me.second=0;
                        me.minute=me.minute+1;
                    }

                    if(me.minute>=60)
                    {
                        me.minute=0;
                        me.hour=me.hour+1;
                    }
                    if(me.hour>=24)
                    {
                        me.hour=0;
                        me.day=me.day+1;
                    }
                    me.jvmDataUpdateTime=me.hour+'时'+me.minute+'分'+me.second+'秒';
                    if ( me.jvmData.length > 0)
                    me.jvmData[0].value=me.day+'天'+me.hour+'时'+me.minute+'分'+me.second+'秒';
                },
                saveInstanceEditFn: function () {
                    var instanceDialogform = this.$refs.instanceUpdateData;

                    var vue = this;
                    //校验权重设置

                    var comitData = {
                        instanceList: instanceDialogform.data
                    };

                    vue.dialogInstanceVisible = false;
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService + '/api/instancemanager/updateweight',
                        data: comitData,
                        timeout: 300000,
                        callback: function (code, message, response) {
                            if (response.code === 0) {
                                vue.$message({message: '操作成功', type: 'success'});
                                vue.dialogInstanceVisible = false;
                                vue.queryInstanceData();
                            } else {
                                vue.$message({message: response.message, type: 'warning'});
                            }
                        }
                    });
                },
                queryInstanceData: function () {  //查询单个实例信息
                    var me = this;
                    var row = this.applicationInstance.currentRow;
                    var param = {
                        name: row.name
                    }
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/' ,
                        data: param,
                        callback: function (code, message, response) {
                            //vue.$message({message: '操作成功', type: 'success'});

                            if (code === 0 && response.code === 0){
                                var responseData = response.data;
                                me.instanceData.data = responseData[0].instances;
                                me.queryMainGridFn();
                            } else {
                            }
                        }
                    });
                },
                showTraceDetail: function(scope){
                    this.traceDetail = scope.row.info;
                    this.dialogTraceDetailVisible = true;
                },
                showThreadDetail: function(scope){
                    this.threadDetail = scope.row;
                    this.dialogThreadDetailVisible = true;
                },
                showConsole: function() {
                    var me=this;
                    me.consoleInfo.loading = true;
                    var row = this.instanceData.currentRow;
                    if (this.instanceData.currentRow === null) {
                        this.$message({message: '请选择一条数据', type: 'warning'});
                        return;
                    }
                    me.consoleInfo.visible = true;

                    yufp.service.request({
                        method: 'GET',
                        timeout: 300000,
                        url: backend.dashboardService + '/api/instancemanager/' + row.id + '/logfile/',
                        data: null,
                        callback: function (code, message, response) {
                            me.consoleInfo.loading = false;

                            if (code === 0 && response.code === 0) {
                                me.consoleInfo.data = response.data;
                            } else {
                                me.$message({message:response.message, type:"error"});
                            }
                        }
                    });
                },
                //刷新服务列表
                refreshApp:function(){
                    yufp.frame.refreshTab();
                },
                //刷新button状态
                updateButtonsSts: function(row){

                    if (row.status === 'UP') {
                        this.buttonsts = {
                            offline: true,
                            puase: false,
                            restart: false,
                            shutdown: false,
                            kpi:false,
                            hystrix: false,
                            set:false,
                            console:false
                        };

                    } else if (row.status === 'DOWN') {
                        this.buttonsts = {
                            offline: true,
                            puase: true,
                            restart: false,
                            shutdown: true,
                            kpi: true,
                            hystrix: true,
                            set: true,
                            console: true
                        };
                    } else if (row.status === 'OFFLINE') {
                        this.buttonsts = {
                            offline: false,
                            puase: true,
                            restart: true,
                            shutdown: true,
                            kpi: true,
                            hystrix: true,
                            set: true,
                            console: true
                        };
                    } else  {
                        this.buttonsts = {
                            offline: true,
                            puase: true,
                            restart: true,
                            shutdown: true,
                            kpi: true,
                            hystrix: true,
                            set: true,
                            console: true
                        };
                    }

                }
            }
        });
    };

    //消息处理
    exports.onmessage = function (type, message) {

    };

    //page销毁时触发destroy方法
    exports.destroy = function (id, cite) {

    };
});