/**
 * 主机管理
 */
define(function (require, exports) {
    exports.ready = function (hashCode, data, cite) {
        yufp.lookup.reg("HOST_TYPE");
        yufp.lookup.lookupMgr["BUSINESS_DOMAIN"] = [];
        yufp.lookup.lookupMgr["CLUSTER"] = [];

        // 业务域条件查询字符串拼接
        var queryString = yufp.sessionStorage.get("currentCluster") ? ('/' + yufp.sessionStorage.get("currentCluster")) : '';
        var hostvm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var me = this;
                var _this = this;
                return {
									loading0:false,
                	businessDomainMap: [],
                    clusterMap: [],
                    host: {
                        url: backend.dashboardService + "/api/host/infos" + queryString,
                        columns: [{
                            label: "类型",
                            prop: "type",
                            dataCode: "HOST_TYPE"
                        }, {
                            label: "业务域",
                            prop: "businessDomains",
                            formatter:function(row){
                                var str = null;
                                if (row.businessDomains == null) {
                                    return "";
                                }
                                for(var i=0; i < row.businessDomains.length; i++){
                                    if (str === null) {
                                        str = "";
                                    } else {
                                        str += ",";
                                    }
                                    str += me.businessDomainMap[row.businessDomains[i]];
                                }
                                return str;
                            }
                        }, {
                            label: "主机名",
                            prop: "hostName"
                        }, {
                            label: "IP",
                            prop: "ip"
                        }, {
                            label: "用户名称",
                            prop: "userName"
                        },{
                            label: '所属集群', prop: 'clusters', formatter: function(row, column, cellValue) {
                                if(cellValue && cellValue.length) {
                                    var result = '';
                                    // 把集群编码翻译为集群名
                                    for(var i=0; i<cellValue.length; i++) {
                                        result += _this.clusterMap[cellValue[i]] + " ";
                                    }

                                    return result;
                                }

                                return '';

                            }
                        }],
                    },
                    height:yufp.frame.size().height - 92,
                    extHeight:yufp.frame.size().height - 56,
                    extHost: {
                        url: backend.dashboardService + "/api/host/extinfo",
                        columns: [{
                            label: "SSH KEY",
                            prop: "hostKey",
                            showOverflowTooltip: true
                        }, {
                            label: "状态",
                            prop: "hostState"
                        }, {
                            label: "监控",
                            prop: "hardwareInfos",
                            formatter: function (row, column) {
                                var infos = row[column.property];
                                return JSON.stringify(infos);
                            }
                        }],
                    },
                    add: {
                        visible: false,
                        fields: [{
                            columnCount: 2,
                            fields: [{
                                field: "type",
                                label: "类型",
                                type: "select",
                                dataCode: "HOST_TYPE",
                                placeholder: "请输入一个类型",
                                rules: [{
                                    required: true,
                                    message: '必填项',
                                    trigger: 'change'}]
                            },{
                                 field: "businessDomains",
                                label: "业务域",
                                type: "select",
                               dataCode: "BUSINESS_DOMAIN",
                               multiple: true
                            },{
                                field: "clusters",
                                label: "所属集群",
                                type: "select",
                                dataCode: "CLUSTER",
                                multiple: true
                            },{
                                field: "hostName",
                                label: "主机名称",
                                type: "input",
                                placeholder: "不要重复",
                                rules: [{
                                    required: true,message: '必填项',trigger: 'blur'}]
                            }, {
                                field: "ip",
                                label: "ip地址",
                                type: "input",
                                rules: [{
                                    required: true,message: '必填项',trigger: 'blur'},{
                                    validator:yufp.validator.ip
                                }],
                                change: function() {
                                    _this.add.buttons[1].disabled = true;
                                }
                            }, {
                                field: "userName",
                                label: "用户名",
                                type: "input",
                                rules: [{
                                    required: true,message: '必填项',trigger: 'blur'}],
                                change: function() {
                                    _this.add.buttons[1].disabled = true;
                                }
                            }, {
                                field: "password",
                                label: "密码",
                                type: "password",
                                rules: [{
                                    required: true,message: '必填项',trigger: 'blur'}],
                                change: function() {
                                    _this.add.buttons[1].disabled = true;
                                }
                            }]
                        }],
                        buttons: [{
                            label: "测试连接", click: function (model, valid) {
                                _this.testConn(model);
                            }
                        }, {
                            label: "保存", icon: "check", op: 'submit', click: function (model, valid) {
                                if (valid) {
                                    _this.saveHost(model);
                                }
                            }
                        }]
                    },
                    shell: {
                        visible: false,
                        cmdHis: [],
                        first: true,
                        cmdParam: {
                            hostName: "",
                            dir: "/home>",
                            lastVal: "/home>",
                            rVal: "/home>"
                        },
                        data: "/home>"
                    }
                };
            },
            created(){
                this.loadCluster();
            	this.loadBusinessDomain();
            },
            methods: {
                loadCluster: function() {
                    var _this = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/cluster/list",
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                var data = response.data;
                                var list = [];
                                for(var i=0,j = 0; i < data.length; i++){
                                    list[j] ={
                                        key: data[i].id,
                                        value: data[i].clusterName
                                    };
                                    _this.clusterMap[data[i].id]=data[i].clusterName;
                                    j++;
                                }
                                yufp.lookup.lookupMgr["CLUSTER"] = list ;
                            }
                        }
                    })
                },
            	loadBusinessDomain : function (){
            		var _this = this;
            		yufp.service.request({
                        url: backend.dashboardService + "/api/businessdomain/list",
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                            	var data = response.data;
			                    var list = [];
			                    for(var i=0,j = 0; i < data.length; i++){
			                        list[j] ={
			                            key: data[i].id,
			                            value: data[i].name
			                        };
			                        _this.businessDomainMap[data[i].id]=data[i].name;
			                        j++
			                    }
                            	yufp.lookup.lookupMgr["BUSINESS_DOMAIN"] = list ;
                            }
                        }
                    })
            	},
            	 // 展示修改面板
                editFn: function () {
                    var data = this.$refs.hostTable.selections;
                    if (data.length < 1) {
                        this.$message({
                            message: '请选择一条记录修改!'
                        });
                        return false;
                    }
                    if (data > 1) {
                        vm.$message({
                            message: '只能选择一条记录修改!'
                        });
                        return false;
                    }
                    
                    this.add.buttons[0].hidden = false;
                    this.add.buttons[1].hidden = false;
                    this.add.fields[0].fields[3].readonly = true;
                    this.add.fields[0].fields[4].readonly = true;
                    this.viewType = "UPDATE";
                    this.add.visible = true;
                    var _this = this;
                   this.$nextTick(function () {
                        yufp.extend(_this.$refs.addForm.formModel, _this.$refs.hostTable.selections[0]);
                    });
                },
                keyEnter: function () {
                    var _this = this;
                    var rVal = this.shell.cmdParam.rVal;
                    var val = this.shell.data;
                    var dir = this.shell.cmdParam.dir;
                    dir = dir.substring(0, dir.length - 1);
                    var cmd = val.substring(rVal.length, val.length);
                    var param = {
                        dir: encodeURI(dir),
                        hostName: encodeURI(this.shell.cmdParam.hostName),
                        cmd: cmd
                    };

                    yufp.service.request({
                        url: backend.dashboardService + "/api/host/cmd",
                        methods: "get",
                        data: param,
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                if (response.data.code == 0) {
                                    _this.shell.cmdParam.dir = response.data.dir + ">";
                                }
                                _this.shell.cmdParam.rVal = val + response.data.out + "\n" + _this.shell.cmdParam.dir;
                                _this.shell.cmdParam.lastVal = _this.shell.cmdParam.rVal;
                                _this.shell.data = _this.shell.cmdParam.lastVal;
                            }
                        }
                    })
                },
                changeValue: function (value) {
                    var _this = this;
                    var rVal = this.shell.cmdParam.rVal;
                    if (!(value.indexOf(rVal) > -1)) {
                        //恢复修改值
                        var lastVal = this.shell.cmdParam.lastVal;
                        this.$nextTick(function () {
                            _this.shell.data = lastVal;
                        });
                    } else {
                        this.shell.cmdParam.lastVal = value;
                    }
                },
                clear: function () {
                    var _this = this;
                    _this.shell.cmdParam.rVal = _this.shell.cmdParam.dir;
                    _this.shell.cmdParam.lastVal = _this.shell.cmdParam.dir;
                    _this.shell.data = _this.shell.cmdParam.dir;
                },
                createFn: function () {
					for(var i =0;i<  this.add.fields[0].fields.length;i++){
                    	 this.add.fields[0].fields[i].readonly = false;
                    	 // 设置主机名为只读，只能通过测试连接按钮获取
                    	 if(i==3) {
                    	     this.add.fields[0].fields[i].readonly = true;
                         }
                    }
                    var me = this;
                    me.add.visible = true;
                    this.$nextTick(function () {
                        me.$refs.addForm.resetFn();
                    });
                },
                addClose: function () {
                    this.add.visible = false;
                },
                shellClose: function () {
                    this.shell.cmdParam.dir = "/home>";
                    this.clear();
                    this.shell.visible = false;
                },
                saveHost: function (params) {
                    var _this = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/host/addhost",
                        method: "post",
                        data: params,
                        callback: function (code, message, response) {
                            _this.$message(message);
                            _this.addClose();
                            _this.$refs.hostTable.remoteData();
                        }
                    })
                },
                deleteHost: function () {
                    var _this = this;
                    var data = this.$refs.hostTable.selections;
                    if (data.length != 1) {
                        this.$message("请选择一台主机!")
                        return;
                    }
                    _this.$confirm('确认删除主机信息?', '提示', {
                        confirmButtonText: '确认',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function(){
                        yufp.service.request({
                            url: backend.dashboardService + "/api/host/delhost",
                            method: "post",
                            data: data[0],
                            callback: function (code, message, response) {
                                _this.$message('删除成功');
                                _this.addClose();
                                _this.$refs.hostTable.remoteData();
                            }
                        })
                    }).catch(function(){
                        return;
                    });
                },
                searchExt: function (row) {
                    var param = {
                        hostName: row.hostName
                    }
                    this.$refs.extTable.remoteData(param);
                },
                showCmdDialog: function () {
                    var data = this.$refs.hostTable.selections;
                    if (data.length != 1) {
                        this.$message("请选择一台主机!")
                        return;
                    }
                    this.shell.cmdParam.hostName = data[0].hostName;
                    this.shell.visible = true;
                },
                testConn: function (params) {
                    var _this = this;
										_this.loading0 = true;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/host/test",
                        method: "post",
						timeout : 4000,
                        data: params,
                        callback: function (code, message, response) {
                            _this.$message(response.message);
							_this.loading0 = false;

							if(response.message == "success") {
							    _this.add.buttons[1].disabled = false;
							    _this.$refs.addForm.formModel.hostName = response.data.hostName.trim();
                            } else {
                                _this.add.buttons[1].disabled = true;
                                _this.$refs.addForm.formModel.hostName = "";
                            }
                        }
                    })
                }
            }
        });
    };

    //消息处理
    exports.onmessage = function (type, message) {

    };

    //page销毁时触发destroy方法
    exports.destroy = function (id, cite) {

    }

});