/**
 * Created by wangzy1. 
 */
define(function(require, exports) {

	// page加载完成后调用ready方法
	exports.ready = function(hashCode, data, cite) {
		// 注册该功能要用到的数据字典
		// yufp.lookup.reg("NATIONALITY,PUBLISH_STATUS");
		var vm = yufp.custom
				.vue({
					el : "#el_table_x_gateway",
					data : function() {
						var me = this;
						return {
							height : yufp.custom.viewSize().height - 100,
							checkbox : false,
							dataUrl : '/api/gatewayapi/gatewayconfig/getallfilter',
							dataParams : {},
							hideColumn : true,
							tableColumns : [
									{
										label : '名称',
										prop : 'filterName'
									},
									{
										label : '中文名称',
										prop : 'desc'
									},
									{
										label : '类型',
										prop : 'filterType'
									},
									{
										label : '顺序',
										prop : 'filterOrder'
									},
									{
										label : '是否已启用',
										prop : 'enabled',
										template : function() {

											return '<template scope="scope">\
                            <el-tag :type="scope.row.enabled === \'是\' ? \'success\' : \'danger\'">{{ scope.row.enabled }}</el-tag>\
                        </template>';
										}
									},
									{
										label : '操作',
										width : 160,
										fixed : 'right',
										template : function() {
											return '<template scope="scope">\
                                <el-button size="small" @click="_$event(\'custom-row-op\', scope, scope.row.enabled === \'是\' ? \'disable\' : \'enable\')">{{scope.row.enabled === \'是\' ? \'停用\' : \'启用\'}}</el-button>\
                            </template>';
										}
									} ],

							gatewayVisible : false,
							//gatewayUrl : "/api/gatewayapi/gatewayconfig/getallgateway",
							gatewayAddData:[],
							gatewayAddTableColumns : [ {
								label : '网关地址',
								prop : 'gatewayurl',
								width : 200
							}, {
								label : '环境',
								prop : 'metadata',
								width : 200
							}, {
								label : '操作',
								prop : 'isOk',
								template : function() {
									return '<template scope="scope">\
	                            		<el-tag :type="scope.row.isOk === \'1\' ? \'success\' : \'danger\'">{{scope.row.isOk === \'1\' ? \'停用\' : \'失败\'}}</el-tag>\
										</template>';
									
								}
							} ]
						}
					},
					methods : {
						customRowOp : function(scope, op) {
							var _this = this;
							var asyncFunction=function(this_data,scope,flag){
								var the_url=this_data.gatewayurl.replace("http://","");
								yufp.service
								.request({
									url : "/api/gatewayapi/gatewayconfig/maintenancefilterzuul?filterName="
											+ scope.row.filterName
											+ "&opStr="+flag+"&host="+the_url,
									method : 'get',
									data : null,  
									callback : function(
											code,
											message,
											response) {
										if (response.code ===0) {

											//vm.$refs.gatewayfiltertable.remoteData();
											this_data.isOk="成功";
											vm.$refs.gatewayfiltertable.remoteData();
							
										} else {
											this_data.isOk="失败"
										}
									}
								});
							}
							if ("enable" == op) {
								_this.$confirm('确定启用该过滤器码?', '提示', {
											confirmButtonText : '确定',
											cancelButtonText : '取消',
											type : 'warning'
										}).then(
												function() {
													
													yufp.service
													.request({
														url : "/api/dashboard/gatewayconfig/removedisablefilter?filtername="
																+ scope.row.filterName,
														method : 'get',
														data : null,
														callback : function(
																code,
																message,
																response) {
															if (response.code== 0) {
																vm.$message({message : '配置中心登记-启用成功!'});
																_this.$confirm('配置中心登记成功，但运行的网关需要同步生效,是否进行在线生效?', '提示', {
																	confirmButtonText : '确定',
																	cancelButtonText : '取消',
																	type : 'warning'
																}).then(
																		function() {
																			
																			//开启同步列表
																			_this.gatewayVisible = true;
																			
																			yufp.service.request({
																				url : "/api/gatewayapi/gatewayconfig/getallgateway",
																				method : 'get',
																				data : null,
																				callback : function(
																						code,
																						message,
																						response) {
																					if (response.code == 0) {
																						_this.gatewayAddData=response.data;
																						
																						for(var i=0;i<_this.gatewayAddData.length;i++){
																							var this_data=_this.gatewayAddData[i];
																							this_data.isOk="--";
																							asyncFunction(this_data,scope,"enable");
																						}
																						
																						
																					} else {
																						vm.$message({
																									message : '获取网关地址失败'
																						});
																					}
																				}
																			});
																			
																			
																			return;
																			
																			
																			
																		}
																);		
															} else {
																vm.$message({
																	message : '配置中心登记-启用失败!'
																});
															}
														}
													});
													
												});
								
							} else if ("disable" == op) {
								
								_this.$confirm('确定停用该过滤器码?', '提示', {
											confirmButtonText : '确定',
											cancelButtonText : '取消',
											type : 'warning'
										}).then(
												function() {
													/**
													 * 到配置中心登记
													 */
													 var comitData = {
								                        		filtername: scope.row.filterName,
								                        		filtertype: scope.row.filterType,
								                        		filterorder: scope.row.filterOrder,
								                        		filterdisabled: "1"
								                        		};
													yufp.service
													.request({
														url : "/api/dashboard/gatewayconfig/disablefilter",
														method : 'post',
														data : comitData,
														callback : function(
																code,
																message,
																response) {
															if (response.code == 0) {
																vm.$message({message : '配置中心登记-停用成功!'});
																//vm.$refs.gatewayfiltertable.remoteData();
																_this.$confirm('配置中心登记成功，但运行的网关需要同步生效,是否进行在线生效?', '提示', {
																	confirmButtonText : '确定',
																	cancelButtonText : '取消',
																	type : 'warning'
																}).then(
																	function() {
																		_this.gatewayVisible = true;
																		
																		yufp.service.request({
																			url : "/api/gatewayapi/gatewayconfig/getallgateway",
																			method : 'get',
																			data : null,
																			callback : function(
																					code,
																					message,
																					response) {
																				if (response.code == 0) {
																					_this.gatewayAddData=response.data;
																					for(var i=0;i<_this.gatewayAddData.length;i++){
																						var this_data=_this.gatewayAddData[i];
																						this_data.isOk="--";
																						asyncFunction(this_data,scope,"disable");
																					}
																					//vm.$refs.gatewayfiltertable.remoteData();
																				} else {
																					vm.$message({
																								message : '获取网关地址失败'
																					});
																				}
																			}
																		});
																		return;
																		
																	}
																);
															} else {
																vm.$message({
																	message : '配置中心登记-停用失败!'
																});
															}
														}
													});
													
												});
							}
						}
					}
				});
	};

	// 消息处理
	exports.onmessage = function(type, message) {

	};

	// page销毁时触发destroy方法
	exports.destroy = function(id, cite) {

	}

});