/**
 * Created by yumeng on 2017/11/26.
 */
define([
    './custom/widgets/js/YufpDemoSelector.js',
    './libs/js-xlsx/xlsx.full.min.js'
],function (require, exports) {

    //page加载完成后调用ready方法
    exports.ready = function (hashCode, data, cite) {
        var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var _self = this;
                return {
                    baseParams: {
                        condition: {
                            userId: 'admin'
                        },
                        nonCondParam1: '1',
                        nonCondParam2: '2'
                    },
                    tableColumns: [
                        {label: 'id', prop: 'id',hidden:true},
                        {label: '业务域名称', prop: 'name', sortable: true, resizable: true},
                        {label: '业务域描述', prop: 'description'}
                    ],
                    updateFields: [{
                        columnCount: 2,
                        fields: [
                            { field: 'name', label: '名称', rules:[
                                { required: true, message: '必填项', trigger: 'blur' }
                            ]},
                            { field: 'description', label: '描述', rules:[
                                    { required: true, message: '必填项', trigger: 'blur' }]
                            }
                        ]
                    }],
                    updateButtons: [
                        {label: '取消', type: 'primary', icon: "yx-undo2", hidden: false, click: function (model) {
                            _self.dialogVisible = false;
                        }},
                        {label: '保存', type: 'primary', icon: "check", hidden: false, click: function (model) {
                            var validate = false;
                            _self.$refs.reform.validate(function (valid) {
                                validate = valid;
                            });
                            if(!validate){
                                return;
                            }
                            
                            var url0 = "/api/businessdomain/";
                            
                            yufp.service.request({
                                method: 'POST',
                                url: url0,
                                data: model,
                                callback: function (code, message, response) {
                                    if (code==0) {
                                        _self.$refs.reftable.remoteData();
                                        _self.$message('操作成功');
                                        _self.dialogVisible = false;
                                    }
                                }
                            });
                        }}
                    ],
                    height: yufp.frame.size().height - 103,
                    dialogVisible: false,
                    formDisabled: false,
                    viewType: 'DETAIL',
                    viewTitle: yufp.lookup.find('CRUD_TYPE', false)
                }
            },
            methods: {
                /**
                 * @param viewType 表单类型
                 * @param editable 可编辑,默认false
                 */
                switchStatus: function (viewType, editable) {
                    var _self = this;
                    _self.viewType = viewType;
                    //_self.updateButtons[0].hidden = !editable;
                    _self.updateButtons[1].hidden = !editable;
                    _self.formDisabled = !editable;
                    _self.dialogVisible = true;
                },
                addFn: function () {
                    var _self = this;
                    _self.switchStatus('ADD', true);
                    _self.$nextTick(function () {
                        _self.$refs.reform.resetFn();
                    });
                },
                modifyFn: function () {
                    if (this.$refs.reftable.selections.length != 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    this.switchStatus('EDIT', true);
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.reform.formModel, this.$refs.reftable.selections[0]);
                    });
                },
                infoFn: function () {
                    if (this.$refs.reftable.selections.length != 1) {
                        this.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    this.switchStatus('DETAIL', false);
                    this.$nextTick(function () {
                        yufp.extend(this.$refs.reform.formModel, this.$refs.reftable.selections[0]);
                    });
                },
                deleteFn: function () {
                    var _self = this;
                    var selections=_self.$refs.reftable.selections;
                    if (selections.length < 1) {
                        _self.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    var len=selections.length,arr=[];
                    for(var i=0;i<len;i++){
                        arr.push(selections[i].id);
                    }
                    _self.$confirm('确认删除服务?', '提示', {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function () {
                    	yufp.service.request({
		                        method: 'GET',
		                        url: "/api/businessdomain/delete/"+arr.join(','),
		                        callback: function (code, message, response) {
		                            if (code==0) {
		                                _self.$refs.reftable.remoteData();
		                                _self.$message('操作成功');
		                            }
		                        }
		                    });
                    	
                    	
                    }).catch(function(){
                        return;
                    });
                    
                },
                exportFn: function () {
                    yufp.util.exportExcelByTable({
                        fileName:'下载文件',
                        importType: 'service',//page当前页 selected 选中的数据  service 后端数据
                        ref: this.$refs.reftable,
                        url: '/trade/example/list',
                        param:{}
                    });
                }
            }
        });
    };

});