/**
 * @Authoer: dusong
 * @Description: 应用管理
 * @Date 2018/3/22
 * @Modified By:
 *
 */
define([
    './libs/mxgraph/js/mxClient.js'
    ],
    function (require, exports) {
    exports.ready = function (hashCode, data, cite){
        var graph;
         function main (container){

            //检查浏览器是否支持  
            if (!mxClient.isBrowserSupported()) {
                //如果浏览器不支持，显示错误信息。  
                mxUtils.error('Browser is not supported!', 200, false);
            } else {
                //能够实现在SVG中清晰呈现矩形，即：去锯齿效果  
                mxRectangleShape.prototype.crisp = true;
                //在给定的容器中创建的图形  
                 graph = new mxGraph(container);

                //设置容器自动调整大小  
                //graph.setResizeContainer(true);  
                //允许弹性选项  
                new mxRubberband(graph);
                // 在对象中创建默认组件  
                var parent = graph.getDefaultParent();
                //在图形中插入组件  
                //开启模型的事务  
                graph.getModel().beginUpdate();

                try {
                    //插入点  
                    var v1 = graph.insertVertex(parent, null, 'Hello,', 20, 20, 80, 30);
                    var v2 = graph.insertVertex(parent, null, 'World!', 200, 150, 80, 30);
                    graph.insertEdge(parent, null, '', v1, v2);

                }
                finally {
                    //事务结束  
                    graph.getModel().endUpdate();
                }
            }
          };

         function addNode(){

             var model = graph.getModel();
             var parent = graph.getDefaultParent();

             model.beginUpdate();
             try {
                 //插入点  
                 var v3 = graph.insertVertex(parent, null, 'Hello,', 20, 20, 80, 90);
                 var v4 = graph.insertVertex(parent, null, 'Hello,', 20, 51, 80, 30);

                 v3.width = 100;
                 v3.height = 120;
             }
             finally {
                 //事务结束  
                 model.endUpdate();
             }
          };

        var divObj = $('#graphContainer')[0];

         main(divObj);
        addNode();
        // var vm;
        // vm = yufp.custom.vue({
        //     el: "#graphContainer",
        //     data:function() {
        //         var me = this;
        //
        //         return {
        //         }
        //     },
        //     mounted: function () {
        //         var me = this;
        //     },
        //     methods: {
        //     }
        // });



        function addToolbarItem(graph, toolbar, prototype, image)
        {
            // Function that is executed when the image is dropped on
            // the graph. The cell argument points to the cell under
            // the mousepointer if there is one.
            var funct = function(graph, evt, cell)
            {
                graph.stopEditing(false);

                var pt = graph.getPointForEvent(evt);
                var vertex = graph.getModel().cloneCell(prototype);
                vertex.geometry.x = pt.x;
                vertex.geometry.y = pt.y;

                graph.setSelectionCells(graph.importCells([vertex], 0, 0, cell));
            }

            // Creates the image which is used as the drag icon (preview)
            var img = toolbar.addMode(null, image, funct);
            mxUtils.makeDraggable(img, graph, funct);
        }

    };

    //消息处理
    exports.onmessage = function (type, message) {

    };

    //page销毁时触发destroy方法
    exports.destroy = function (id, cite) {

    };
});