/**
 * @Authoer: dusong
 * @Description: 应用管理
 * @Date 2018/3/22
 * @Modified By:
 *
 */
define(function (require, exports) {

    exports.ready = function (hashCode, data, cite){

        var vm;
        var queryString = yufp.sessionStorage.get("currentCluster") ? ('applist/?cluster=' + yufp.sessionStorage.get("currentCluster")) : '';
        vm = yufp.custom.vue({
            el: cite.el,
            data:function() {
                var me = this;

                return {
                    applications: {
                        gateWayUrl: "",
                        currentRow: null,
                        data: null,
                        total: null,
                        dataUrl: backend.dashboardService+'/api/instancemanager/' + queryString,
                        height: yufp.custom.viewSize().height ,
                        tableColumns: [
                            { label: '服务名称', prop: 'name',  resizable: true },
                            { label: '数量', prop: 'instances',  resizable: true,formatter:function(row){
                                var upCount = 0;

                                 for(var i=0; i < row.instances.length; i++){

                                     if (row.instances[i].status === "UP"){
                                         upCount++;
                                     }
                                 }
                                 return upCount + "/" + row.instances.length;
                                }
                            },
                            // { label: '性能KPI', prop: 'KPI',  resizable: true },
                            {
                                label: '接口信息',
                                prop: 'client',
                                resizable: true,
                                template: function () {
                                    return '<template scope="scope">\
                                    <a style="text-decoration:underline;cursor:pointer;" @click="_$event(\'show-api\', scope)">{{scope.row.name}}接口查看</a>\
                                </template>';
                                }
                            }
                        ]
                    }
                }
            },
            mounted: function () {
                var me = this;
                this.loadGateWayUrl();
            },
            methods: {
                loadGateWayUrl: function() {
                    var me = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/instancemanager/instancelist?name="+backend.gateWayName,
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                if (response.data.length > 0)
                                {
                                    var data0 = response.data[0];
                                    me.gateWayUrl = data0.url;
                                }
                            }
                        }
                    })
                },
                rowClickFn: function (row, index) {
                    this.applications.currentRow = this.$refs.applications.selections[0];
                },
                queryMainGridFn: function () {
                    var me = this;
                    me.$refs.applications.remoteData();
                },
                applicationsStart: function () {
                    if (this.applications.currentRow === null) {
                        this.$message("请选择一条应用!");
                        return;
                    }
                    var row = this.applications.currentRow;
                    var me = this;
                    me.$confirm('此操作将启动该服务,是否继续？','提示',{
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function(){
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/applicationmanager/start',
                            data: row.name,
                            callback: function (code, message, response) {
                                var data = response.data;
                                if (code === 0 && response.code === 0){
                                    me.$message({message: '操作成功', type: 'success'});
                                } else {
                                    me.$message({message: data.messgae, type: data.level});
                                }
                            }
                        });
                    }).catch(function(){
                        return;
                    });
                },
                applicationsStop: function () {
                    if (this.applications.currentRow === null) {
                        this.$message("请选择一条应用!");
                        return;
                    }

                    var row = this.applications.currentRow;
                    var me = this;
                    me.$confirm('此操作将停止该服务,是否继续？','提示',{
                        confirmButtonText:'确定',
                        cancelButtonText:'取消',
                        type:'warning'
                    }).then(function(){
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/applicationmanager/shutdown',
                            data: row.name,
                            callback: function (code, message, response) {
                                var data = response.data;
                                if (code === 0 && response.code === 0){
                                    me.$message({message: '操作成功', type: 'success'});
                                } else {
                                    me.$message({message: data.messgae, type: data.level});
                                }
                            }
                        });
                    }).catch(function(){
                       return;
                    });
                },
                applicationsUpdate: function () {
                    var vue = this;
                    if (this.applications.currentRow == null) {
                        this.$message({message: '请先选择一条记录', type: 'warning'});
                        return;
                    }
                    var row = this.applications.currentRow;

                    //打开菜单页签
                    yufp.frame.addTab({
                        id: 'applicationInstall',//FUNC_ID(业务功能编号)
                        title: '集群部署['+row.name +']', //MENU_NAME(菜单名称)
                        key: row.name, //UP_MENU_ID(上级菜单编号)
                        data:row //给打开的页面传参
                    });
                },
                applicationsCancelUpdate: function () {
                    this.applicationsUpdate();
                },
                applicationsRemove: function () {
                    this.applicationsUpdate();
                },
                //查看API,需要当前WEB系统已登录网关
                showApi: function (scope) {
                    var me = this;
                    var data = {
                        username: 'admin',
                        password: 'admin',
                        grant_type: "password",
                        sysId:"1cab27def8fb4c0f9486dcf844b783c0"
                    };
                    var headers = {
                        "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
                        "Authorization": "Basic d2ViX2FwcDo="
                    };

                    yufp.core.ajax({
                        url: me.gateWayUrl + backend.uaaService+'/oauth/token',
                        type: 'post',
                        headers: headers,
                        async:true,
                        data: data,
                        error: function(xhr,textStatus){
                            console.log('错误')
                            console.log(xhr)
                            console.log(textStatus)
                        },
                        success: function (data, status, xhr) {
                            if (data) {
                                var dataObj = JSON.parse(data)
                                var accessToken = dataObj.access_token;

                                var url = me.gateWayUrl + "/swagger-ui2.html?jhi-authenticationtoken="+accessToken + "&name=" + scope.row.name;
                                //var apiwindow = window.open(url, "apiwindow", "height=800, width=800, toolbar =no, menubar=yes,scrollbars=yes, resizable=no, location=no, status=no");

                                var  swaggerConfig = {
                                    swaggerConfig:{
                                        html: 'pages/content/dashboard/swaggerConfig/swaggerConfig.html',
                                        js:	'pages/content/dashboard/swaggerConfig/swaggerConfig.js'
                                    }
                                };

                                yufp.router.addRouteTable(swaggerConfig);

                                yufp.frame.addTab({
                                    id: 'swaggerConfig',//FUNC_ID(业务功能编号)
                                    title: '接口['+ scope.row.name +']', //MENU_NAME(菜单名称)
                                    key: scope.row.name, //UP_MENU_ID(上级菜单编号)
                                    data: url //给打开的页面传参
                                });
                            } else {
                                var msg = '跳转失败，请联系系统管理员！';
                                $('#msg').text(msg).show();
                            }
                        }
                    });
                },
                refreshTab:function(){
                    yufp.frame.refreshTab();
                }
            }
        });
    };

    //消息处理
    exports.onmessage = function (type, message) {

    };

    //page销毁时触发destroy方法
    exports.destroy = function (id, cite) {

    };
});