/**
 * @Authoer: dusong
 * @Description: 应用部署
 * @Date 2018/3/29
 * @Modified By:
 *
 */
define(function (require, exports) {

    exports.ready = function (hashCode, data, cite) {
        var appInfoDataUrl;

        var selectedName = '';
        // 业务域条件查询字符串拼接
        var queryString = yufp.sessionStorage.get("currentCluster") ? ('/' + yufp.sessionStorage.get("currentCluster")) : '';
        if (data != null && typeof data['name'] != "undefined") {
            appInfoDataUrl = backend.dashboardService + '/api/service/basic/version' +  '/' + data.name;
            selectedName =  data.name;
        } else {
            appInfoDataUrl = backend.dashboardService + '/api/service/basic/version' + queryString;
            selectedName = "";
        }

        var vm;
        vm = yufp.custom.vue({
            el: cite.el,
            data:function() {
                var me = this;

                return {
                    appInfo: {
                        mySelectUrl: "/api/service/basic/namelist" + (yufp.sessionStorage.get("currentCluster") ? ("?clusterId=" + yufp.sessionStorage.get("currentCluster")) : ''),
                        currentRow: null,
                        selectedName:selectedName,
                        data: null,
                        total: null,
                        dataUrl: appInfoDataUrl,
                        height: yufp.custom.viewSize().height -36*2 - 30 ,
                        tableColumns: [
                            { label: '服务名称', prop: 'name',  resizable: true,width:220  },
                            { label: '版本', prop: 'version',  resizable: true,width:120  },
                            { label: '文件名称', prop: 'fileName',  resizable: true }
                        ]
                    },
                    instanceInfo: {
                        currentRow: null,
                        data: null,
                        total: null,
                        hostList:null,
                        dataUrl: backend.dashboardService+'/api/instancemanager/instancelist' +
                        '?name=null',
                        height: yufp.custom.viewSize().height -36*2 - 30 ,
                        tableColumns: [
                            { label: 'IP', prop: 'ip',  resizable: true ,width:120},
                            { label: '端口', prop: 'port',  resizable: true,width:80 },
                            { label: '状态', prop: 'status',  resizable: true,width:80, template: function () {
                                return '<template scope="scope">\
                                    <span v-if="scope.row.status == \'UP\'" style="color: #00AA00;font-weight: bold;">{{scope.row.status}}</span>\
                                    <span v-if="scope.row.status == \'OFFLINE\'||scope.row.status == \'OUT_OF_SERVICE\'" style="color: #000000;font-weight: bold;">{{scope.row.status}}</span>\
                                    <span v-if="scope.row.status == \'DOWN\'" style="color: #DD0000;font-weight: bold;">{{scope.row.status}}</span>\
                                    <span v-if="scope.row.status == \'UNKNOWN\'" style="color: #FF8800;font-weight: bold;">{{scope.row.status}}</span>\
                                    <span v-if="scope.row.status == \'STARTING\'" style="color: #3497DA;font-weight: bold;">{{scope.row.status}}</span>\
                            </template>';
                            }},
                            { label: '版本', prop: 'version',  resizable: true,  template: function () {
                                    return '<template scope="scope">\
                                <el-tag :type="scope.row.type === \'success\' ? \'success\' : \'danger\'">{{ scope.row.version}}</el-tag>\
                            </template>';
                                }
                            }
                        ]
                    },
                    newInstance: {
                        selections:[],
                        visible: false,
                        title: "增加实例",
                        url: backend.dashboardService + "/api/applicationinstall/hostlist",//"/api/service/expand/host",
                        params: {},
                        columns: [{
                            label: "主机名",
                            prop: "hostName"
                        }, {
                            label: "IP",
                            prop: "ip"
                        },/*{
                            label: "状态",
                            prop: "hostState"
                        },*/ {
                            label: "用户名称",
                            prop: "userName"
                        }/*, {
                            label: "监控",
                            prop: "hardwareInfos",
                            formatter: function(row, column) {
                                var infos = row[column.property];
                                return JSON.stringify(infos);
                            }
                        }*/]
                    },
                    history: {
                        selections:[],
                        visible: false,
                        title: "部署历史",
                        url: backend.dashboardService + "/api/applicationinstall/history",
                        params: {},
                        columns: [{
                            label: "IP",
                            prop: "ip"
                        },{
                            label: "应用名称",
                            prop: "appName"
                        },{
                            label: "版本",
                            prop: "version"
                        },{
                            label: "日期",
                            prop: "updateTime"
                        },{
                            label: "操作类型",
                            prop: "updateType"
                        },{
                            label: "日志查看",
                            prop: "logFile",
                            template: function () {
                                return '<template scope="scope">\
                                    <a style="text-decoration:underline;cursor:pointer;" @click="_$event(\'show-console\', scope.row)">日志查看</a>\
                                </template>';
                            }
                        }]
                    },

                    deploy: {
                        time: null,
                        selections:[],
                        status: "1",
                        visible: false,
                        title: "部署监控",
                        url: backend.dashboardService + "/api/applicationinstall/deploy",
                        intervalId: 0,
                        params: {},
                        columns: [{
                            label: "名称",
                            prop: "name"
                        },{
                            label: "IP",
                            prop: "ip"
                        },{
                            label: "版本",
                            prop: "version"
                        },{
                            label: "操作时间",
                            type: "date",
                            prop: "opDate"
                        },{
                            label: "状态",
                            prop: "deployNo",
                            width: "450",
                            template: function(a,b,c){

                                return '<template scope="scope">\
                                <el-steps :active=scope.row.deployNo >\
                                    <el-step title="开始" icon="yx-play3"></el-step>\
                                    <el-step title="检查" icon="yx-zoom-in"></el-step>\
                                    <el-step title="上传" icon="yx-folder-upload"></el-step>\
                                    <el-step title="启动" icon="yx-spinner3"></el-step>\
                                    <el-step title="正常" icon="yx-checkmark2"></el-step>\
                                    </el-steps>\
                                </template>'
                            }
                        },{
                            label: "部署结果",
                            prop: "deployResult"
                        },{
                            label: "日志查看",
                            prop: "logFile",
                            template: function () {
                                return '<template scope="scope">\
                                    <a style="text-decoration:underline;cursor:pointer;" @click="_$event(\'show-console\', scope.row)">日志查看</a>\
                                </template>';
                            }
                        }]
                    },
                    gray: {
                        selections:[],
                        status: "1",
                        visible: false,
                        title: "灰度发布",
                        url: "",
                        intervalId: 0,
                        params: {},
                        columns: [
                            { label: 'IP', prop: 'ip',  resizable: true ,width:120},
                            { label: '端口', prop: 'port',  resizable: true,width:80 },
                            { label: '状态', prop: 'status',  resizable: true,width:80 },
                            { label: '标签', prop: 'lable',  resizable: true,width:150 ,template: function () {
                                    return '<template scope="scope">\
                                <el-tag type="success">{{ scope.row.lable}}</el-tag>\
                            </template>';
                                }},
                            { label: '版本', prop: 'version',  resizable: true,  template: function () {
                                    return '<template scope="scope">\
                                <el-tag :type="scope.row.type === \'success\' ? \'success\' : \'danger\'">{{ scope.row.version}}</el-tag>\
                            </template>';
                                }
                            }
                        ]
                    },
                    console: {
                        visible: false,
                        title: "启动日志",
                        data:""
                    }
                }
            },
            mounted: function () {
                var me = this;
                this.queryHostList();

                //默认加载版本信息
                if (this.appInfo.dataUrl != null && this.appInfo.dataUrl != "") {
                    this.$refs.appInfo.remoteData();
                }
            },
            methods: {
                showAppInfo: function (a, b, c) {
                    var name = this.$refs.mySelect.selectedVal;
                    this.appInfo.dataUrl = backend.dashboardService + '/api/service/basic/version' + '/' + name;
                    //this.$refs.appInfo.remoteData();
                },
                rowAppClickFn: function (row, index) {

                    if (this.$refs.appInfo.selections[0] != null ) {
                        this.appInfo.currentRow = this.$refs.appInfo.selections[0];
                        this.queryHostGridFn();
                    }

                },
                rowHostClickFn: function (row, index) {
                    this.instanceInfo.currentRow = this.$refs.instanceInfo.selections[0];
                },
                queryAppGridFn: function () {
                    var me = this;
                    me.$refs.appInfo.remoteData();
                },
                queryHostGridFn: function () {
                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return;
                    }
                    var me = this;
                    me.instanceInfo.dataUrl = backend.dashboardService+'/api/instancemanager/instancelist' +
                        '?name='+this.appInfo.currentRow.name;
                    //me.$refs.instanceInfo.remoteData();

                    yufp.service.request({
                        method: 'GET',
                        url: me.instanceInfo.dataUrl,
                        data: null,
                        callback: function (code, message, response) {
                            var data = response;
                            if (code == 0 && response.code === 0) {
                                var data = [];
                                if (response.data != null) {
                                    data = me.updateVersionType(response.data, me);
                                }
                               me.$refs.instanceInfo.data = data;
                            }
                        }
                    });
                },
                updateVersionType: function(list,me) {
                    var data = [];
                    for(var i = 0 ; i < list.length ; i++) {
                        var tmp =  list[i];
                        if (tmp.version == me.appInfo.currentRow.version) {
                            tmp['type'] = 'success';
                        }else {
                            tmp['type'] = '';
                        }

                        if (tmp.version > me.appInfo.currentRow.version) {
                            tmp.version = "↑" + tmp.version;
                        } else if (tmp.version < me.appInfo.currentRow.version)  {
                            tmp.version = "↓" + tmp.version;
                        }
                        data.push(tmp);
                    }
                    return data;
                },
                installApp: function() {
                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return;
                    }

                    if (this.$refs.newInstanceTab.selections.length === 0) {
                        this.$message("请选择至少一台主机!");
                        return;
                    }
                    var me = this;
                    var commit = {
                        versionInfo:  this.appInfo.currentRow,
                        hostInfoList:  this.$refs.newInstanceTab.selections
                    };


                    yufp.service.request({
                        method: 'POST',
                        timeout: 6000000,
                        url: backend.dashboardService + '/api/applicationinstall/install',
                        data: commit,
                        callback: function (code, message, response) {
                            var data = response;
                            if (code == 0 && response.code === 0) {
                                //me.$message({message: '成功提交，后台部署中', type: 'success'});
                                //me.queryAppGridFn();
                                //me.queryHostGridFn();
                                //me.newInstance.visible = false;
                            } else {
                                //me.$message({message: data.message, type: "error"});
                            }
                        }
                    });

                    this.deploy.time = setTimeout(function(){
                        me.$confirm('继续等待或退出','提示',{
                            confirmButtonText:'继续等待',
                            cancelButtonText: '退出',
                            type: 'warning',
                            callback: function(action){
                                if(action==='confirm'){

                                }else{
                                    me.deploy.visible=false;
                                }
                            }

                        });
                    }, 30000);

                    me.newInstance.visible = false;
                    this.showDeploy();


                },
                showInstance: function() {

                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return;
                    }

                    var row = this.appInfo.currentRow;
                    var params = {
                        name: row.name,
                        // 增加集群参数
                        cluster: yufp.sessionStorage.get("currentCluster") ? (yufp.sessionStorage.get("currentCluster")) : ''
                    };
                    this.newInstance.params = params;

                    this.newInstance.visible = true;
                    this.$nextTick(function() {
                        this.$refs.newInstanceTab.remoteData(params);
                    });
                },
                instanceClose: function() {
                    this.newInstance.visible = false;
                },
                queryHostList: function() {
                    var me = this;
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + "/api/host/infos",
                        data: null,
                        callback: function (code, message, response) {
                            var data = response.data;
                            if (code == 0 && response.code === 0) {
                                me.instanceInfo.hostList = data;
                            } else {
                                me.$message({message: data.message, type: "error"});
                            }
                        }
                    });
                },
                refreshApp: function() {
                    var me = this;
                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return;
                    }
                    if (this.$refs.instanceInfo.selections === null) {
                        this.$message("请选择至少一台主机!");
                        return;
                    }

                    var hostList = [];
                    for (var i=0; i< this.$refs.instanceInfo.selections.length; i++) {
                        var instance = this.$refs.instanceInfo.selections[i];

                        if (instance.status === "UNKNOWN") {
                            this.$message("实例["+instance.id+"]UNKNOWN状态，无法重新部署!");
                            return;
                        }
                        for (var j=0; j< this.instanceInfo.hostList.length; j++) {
                            var host = this.instanceInfo.hostList[j];
                            if (host.ip === instance.ip){
                                hostList.push(host);
                            }
                        }
                    }

                    if (hostList.length === 0) {
                        this.$message({message: "加载主机配置信息失败，请检查主机配置!", type:"warning"});
                        return;
                    }

                    var commit = {
                        versionInfo:  this.appInfo.currentRow,
                        instanceList:  this.$refs.instanceInfo.selections
                    };


                    yufp.service.request({
                        method: 'POST',
                        timeout: 6000000,
                        url: backend.dashboardService + '/api/applicationinstall/reinstall',
                        data: commit,
                        callback: function (code, message, response) {
                            var data = response;
                            if (code == 0 && response.code === 0) {
                                me.$message({message: '请查看部署监控', type: 'success'});
                                me.showDeploy();
                                // me.queryAppGridFn();
                                // me.queryHostGridFn();
                            } else {
                                me.$message({message: data.message, type: "error"});
                            }
                        }
                    });
                },
                showHistory: function() {
                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要查看历史的程序!");
                        return;
                    }

                    var row = this.appInfo.currentRow;
                    var params = {
                        serviceName: row.name
                    };
                    this.history.params = params;

                    this.history.visible = true;
                    this.$nextTick(function() {
                        this.$refs.historyTab.remoteData(params);
                    });
                },
                historyClose: function() {
                    this.history.visible = false;
                },
                showConsole: function(row) {
                    var me = this;
                    var param = {
                        hostName:  row.hostName,
                        serviceName:  row.name,
                        logFile: row.logFile
                    };

                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/applicationinstall/log',
                        data: param,
                        callback: function (code, message, response) {
                            var data = response;
                            if (code == 0 && response.code === 0) {
                                me.console.visible = true;
                                me.console.data = response.data;
                            } else {
                                me.$message({message: data.message, type: "error"});
                            }
                        }
                    });
                },
                consoleClose: function() {
                    this.console.visible = false;
                },
                refreshTab:function(){
                    yufp.frame.refreshTab();
                },
                showDeploy: function() {
                    var me = this;
                    this.deploy.visible = true;
                    this.deploy.status = "1";
                    this.queryDeploy();
                    this.deploy.intervalId = setInterval(function(){me.refreshDeploy()}, 2000);
                },
                statusChg: function() {
                    var me = this;
                    clearInterval(this.deploy.intervalId);
                    this.queryDeploy();

                    if (this.deploy.status == "1"){
                        this.deploy.intervalId = setInterval(function(){me.refreshDeploy()}, 2000);
                    }
                },
                refreshDeploy: function(){
                    this.queryDeploy();
                },
                queryDeploy: function(){
                    var params = {
                        status: this.deploy.status
                    };
                    this.deploy.params = params;

                    this.$nextTick(function() {
                        this.$refs.deployTab.remoteData(params);
                    });
                },
                deployClose: function() {
                    clearInterval(this.deploy.intervalId);
                    this.deploy.visible = false;
                    clearTimeout(this.deploy.time);
                    this.rowAppClickFn();
                },
                removeInstance: function(){
                    var me = this;

                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return false;
                    }

                    if (this.$refs.instanceInfo.selections.length === 0) {  //判断当前行是否选择了一条记录
                        this.$message("请选择至少一台主机!");
                        return  false;
                    }

                    var commit = {
                        instanceList:  this.$refs.instanceInfo.selections
                    };

                    me.$confirm('确认移除实例?', '提示', {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning'
                    }).then(function () {
                        yufp.service.request({
                            method: 'POST',
                            url: backend.dashboardService + '/api/applicationinstall/remove',
                            data: commit,
                            callback: function (code, message, response) {
                                var data = response;
                                if (code == 0 && response.code === 0) {
                                    me.$message({message: '成功移除实例', type: 'success'});
                                    me.rowAppClickFn();
                                } else {
                                    me.$message({message: data.message, type: "error"});
                                }
                            }
                        });
                    }).catch(function(){
                        return;
                    });
                },
                grayShow: function() {
                    var me = this;

                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return;
                    }

                    this.gray.visible = true;
                    this.gray.url = backend.dashboardService + "/api/instancemanager/lableinstancelist?name="+ this.appInfo.currentRow.name;
                    yufp.service.request({
                        method: 'GET',
                        url: me.gray.url,
                        data: null,
                        callback: function (code, message, response) {
                            var data = response;
                            if (code == 0 && response.code === 0) {
                                var data = [];
                                if (response.data != null) {
                                    data = me.updateVersionType(response.data, me);
                                }
                                me.$refs.grayTab.data = data;
                            }
                        }
                    });
                },
                grayDeploy: function() {
                    var me = this;
                    if (this.appInfo.currentRow === null ) {
                        this.$message("请选择需要部署的程序!");
                        return;
                    }
                    if (this.$refs.grayTab.selections === null) {
                        this.$message("请选择至少一个实例");
                        return;
                    }

                    var hostList = [];
                    for (var i=0; i< this.$refs.grayTab.selections.length; i++) {
                        var instance = this.$refs.grayTab.selections[i];

                        if (instance.status === "UNKNOWN") {
                            this.$message("实例["+instance.id+"]UNKNOWN状态，无法重新部署!");
                            return;
                        }
                        for (var j=0; j< this.instanceInfo.hostList.length; j++) {
                            var host = this.instanceInfo.hostList[j];
                            if (host.ip === instance.ip){
                                hostList.push(host);
                            }
                        }
                    }

                    if (hostList.length === 0) {
                        this.$message({message: "加载主机配置信息失败，请检查主机配置!", type:"warning"});
                        return;
                    }

                    var commit = {
                        versionInfo:  this.appInfo.currentRow,
                        instanceList:  this.$refs.grayTab.selections
                    };

                    yufp.service.request({
                        method: 'POST',
                        timeout: 6000000,
                        url: backend.dashboardService + '/api/applicationinstall/reinstall',
                        data: commit,
                        callback: function (code, message, response) {
                            var data = response;
                            if (code == 0 && response.code === 0) {
                                me.$message({message: '请查看部署监控', type: 'success'});
                                me.showDeploy();
                                me.gray.visible = false;
                                // me.showDeploy();
                                // me.queryAppGridFn();
                                // me.queryHostGridFn();
                            } else {
                                me.$message({message: data.message, type: "error"});
                            }
                        }
                    });

                },
                grayClose: function() {
                    this.gray.visible = false;
                },
            }
        });
    };

    //消息处理
    exports.onmessage = function (type, message) {

    };

    //page销毁时触发destroy方法
    exports.destroy = function (id, cite) {

    };
});