/**
 * @created by wangyin 2018-01-04
 * @updated by
 * @description 系统主页面-左侧竖向菜单模式
 */
yufp.require.require([
  './libs/swiper/idangerous.swiper.css',
  './themes/common/tree-menu.css'
]);
define([
  "jquery",
  "./libs/swiper/idangerous.swiper.min.js",
  "./pages/common/frame/tree-menu.js"
], function (require, exports) {
    var intervalId;
    /**
     * 页面加载完成时触发
     * @param hashCode 路由ID
     * @param data 传递数据对象
     * @param cite 页面站点信息
     */
    exports.ready = function (hashCode, data, cite) {

        // 登录用户的所属业务域
        //var userBusinessDomains = yufp.sessionStorage.get("userInfo").businessDomains ? yufp.sessionStorage.get("userInfo").businessDomains : null;
        // 登录用户所属集群
        var clusters = yufp.sessionStorage.get("userInfo").clusters ? yufp.sessionStorage.get("userInfo").clusters : null;

        // 初始化用户当前所处集群下拉框
        var vm =  yufp.custom.vue({
            el: '#clusters',
            data: function () {
                return {
                    options: [],
                    value: ''
                };
            },
            methods: {
                // 集群选择，当集群切换时设置currentCluster参数,做主机查询时需要带上这个参数
                // 切换集群->并刷新首页的展示效果
                change: function (val) {
                    console.log("onchangge===============" + val);
                    yufp.sessionStorage.put("currentCluster", val);
                    // 焦点到首页
                    yufp.frame.focusTab(0);
                    // 移除其他页签
                    yufp.frame.removeAllTab();
                    // 刷新首页
                    yufp.frame.refreshTab(0);
                },
                // 加载集群数据下拉框
                loadCluster: function() {
                    var _this = this;
                    yufp.service.request({
                        url: backend.dashboardService + "/api/cluster/list",
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                var data = response.data;
                                var list = [];
                                for(var i=0; i < data.length; i++){
                                    for(var j=0; j <clusters.length; j++) {
                                        if(data[i].id == clusters[j]) {
                                            var tmpObj ={
                                                key: data[i].id,
                                                value: data[i].clusterName
                                            };

                                            list.push(tmpObj);

                                        }
                                    }
                                }
                                yufp.lookup.lookupMgr["CLUSTER"] = list ;
                                _this.options = list;
                                _this.value = _this.options[0].key;
                            }
                        }
                    })
                },
                // 加载集群数据，根据集群数据填充切换集群下拉框选项
                loadBusinessDomain : function (){
                    var _this = this;

                    yufp.service.request({
                        url: backend.dashboardService + "/api/businessdomain/list",
                        methods: "get",
                        callback: function (code, message, response) {
                            if (response != null && response.data != null) {
                                var data = response.data;
                                var list = [];
                                for(var i=0,j = 0; i < data.length; i++){
                                    if(data[i].id == userBusinessDomains[j]) {
                                        list[j] ={
                                            key: data[i].id,
                                            value: data[i].name
                                        };
                                        //_this.businessDomainMap[data[i].id]=data[i].name;
                                        j++;
                                    }
                                }
                                yufp.lookup.lookupMgr["BUSINESS_DOMAIN"] = list ;
                                _this.options = list;
                                _this.value = _this.options[0].key;
                            }
                        }
                    })
                }

            },
            // 自动优先执行的方法
            mounted: function () {
                if(clusters){
                    this.loadCluster();
                }
            }
        });

        var treeMenu = yufp.require.require("./pages/common/frame/tree-menu.js");//获取tree-menu
        var indexRouter = [];       //首页路由
        // 创建菜单
        function createMenu(menus) {
            var domStr = "";
            for (var i = 0; i < menus.length; i++) {
                var menu = menus[i];//获取menu
                var defaultIcon = 'el-icon-yx-file-text2';
                //判断是否有子菜单
                if (menu.children && menu.children.length > 0) {
                    domStr += '<li><a href="javascript:void(0);"><i class=' + (menu.mIcon ? menu.mIcon : defaultIcon) + '></i><span class="title">' + menu.mText + '</span><span class="arrow"></span></a>';
                    var subStr = createMenu(menu.children);//创建子菜单
                    domStr += '<ul class="sub-menu">';
                    domStr += subStr;
                    domStr += '</ul></li>';
                } else {
                    if (menu.isIndex) {
                        var indexDateKey = '0';
                        indexRouter.push(menu.routeId, menu.mText, indexDateKey);
                        domStr += '<li class="active"><a href="javascript:void(0);" class="yu-isMenu" data-mId="' + menu.mId + '" data-path="' + menu.routeUrl + '" data-url="' + menu.routeId + '" data-key="' + indexDateKey + '"><i class="' + (menu.mIcon ? menu.mIcon : defaultIcon) + '"></i><span class="title">' + menu.mText + '</span></a></li>';
                    } else {
                        domStr += '<li><a href="javascript:void(0);" class="yu-isMenu" data-mId="' + menu.mId + '" data-path="' + menu.routeUrl + '"  data-url="' + menu.routeId + '"><i class="' + (menu.mIcon ? menu.mIcon : defaultIcon) + '"></i><span>' + menu.mText + '</span></a></li>';
                    }
                }
            }
            return domStr;
        };

        //初始化菜单
        function initMenu() {
            $("#_my_menu").html(createMenu(yufp.session.getMenuTree()));
            //菜单swiper相关调用
            $('.yu-idxMenuSwiper').height($('.yu-idxBody').height());
            $(window).resize(function () {
                $('.yu-idxMenuSwiper').height($('.yu-idxBody').height());
            });
            yufp.frame.idxMenuSwiper = $('.yu-idxMenuSwiper').swiper({
                mode: 'vertical',
                simulateTouch: false,
                slidesPerView: 'auto',
                spaceBetween: 0,
                mousewheelControl: true,
                scrollContainer: true,
                resizeReInit: true,
                scrollbar: {
                    container: '.yu-idxMenuScrollbar',
                    draggable: true
                }
            });
            treeMenu.init(yufp.frame.idxMenuSwiper);//菜单组件调用
            console.log("============" +indexRouter[0] + "   " + indexRouter[1] + '   ' + indexRouter[2] );
            yufp.frame.addTab({id: indexRouter[0], title: indexRouter[1], key: indexRouter[2]});//首页页签初始化
            yufp.frame.menuClick($('a.yu-isMenu')); //菜单事件绑定
        };
        initMenu();
        yufp.frame.init();

        // TODO BEGIN add for console
        var localId ;
        /*
        初始化日志面板
         */
        function setSilderPanel() {
            $('#yu-silderPanelbtn,#yu-closeSilderPanel').click(function() {
                $('#yu-silderPanelbtn').toggleClass('show');
            });

            $('#yu-refreshSilderPanel').bind("click",function(event,a){
                if (a != undefined) {
                    localId = a;
                }else if ($('#yu-refreshSilderPanel').attr("mid") != undefined) {
                    localId = $('#yu-refreshSilderPanel').attr("mid");
                }

                refreshSilderPanel();
            });
        }

        /*
        每隔5秒刷新一次日志
         */
        //intervalId = setInterval(function(){refreshSilderPanel()}, 5000);
        /*
        刷新日志信息
         */
        function refreshSilderPanel() {
            if (localId == undefined) {
                return ;
            }

            yufp.service.request({
                url: backend.dashboardService+'/api/operationlog/' + localId,
                method: 'GET',
                data: null,
                callback: function (code, message, response) {

                    if (code == 0 && response.code == 0) {
                        var data = response.data;
                        var text = "";
                        for(var i = 0; i < data.length; i++){
                            text += '<p><b class="' + data[i].level+'">' + data[i].level + '</b>'+
                                    data[i].opTime +'  '    + data[i].threadId + '<br/> ' +
                                    data[i].opNote + '</p>';
                        }
                        text += "----[END]----";

                        $('#yu-operationLog')[0].innerHTML = text;
                    } else {
                        $('#yu-operationLog')[0].innerHTML = response.message;
                    }

                    $('#yu-operationLog')[0].scrollTop = $('#yu-operationLog')[0].scrollHeight;
                }
            });
        }
        setSilderPanel();
        //autoRefresh();
        // End add for console
    };

    exports.destroy = function (id, cite) {
        //clearInterval(intervalId);
    }
});