/**
 * @created by danyb
 * @updated by danyb
 * @description 普通用户新首页
 */
define(function (require, exports) {

    exports.ready = function (hashCode, data, cite) {

        var vm =  yufp.custom.vue({
            el: cite.el,
            data: function () {
                return {
                    outline:{
                        hostCount:0,
                        registryCount:0,
                        appCount:0,
                        instanceCount:0
                    },
                    pjtInfo:{
                        'pjtNm': '测试集群',
                        'pjtCde': 888888,
                        'pjtExpcStaDt': '20180704',
                        'pjtExpcFinDt': '20180830',
                        'pjtSts': '执行',
                        'pjtDvpNm': '师旭大神',
                        'pjtTestNm': '测艳艳'

                    },
                    pjtAttach:[],
                    downloadUrl: backend.adminService + "/api/ymitinfo/downloadfile?fileId="
                };
            },
            methods: {
                // 根据模拟菜单demoMenus的索引号打开相应菜单
                openMenu: function(index) {
                    yufp.frame.addTab({
                        id: demoMenus[index].funcId,
                        title: demoMenus[index].menuName,
                        key: 'menu_' + demoMenus[index].menuId
                    });
                },
                //文件下载 faset服务器
                downloadFile: function (filePath) {
                        yufp.util.download(this.downloadUrl + filePath);
                },
                initData:function(){
                    this.loadOutlineData();
                    // this.loadPjtInfo();
                    //this.loadPjtAttach();
                },
                loadOutlineData:function(){
                    var _this = this;
                    // 由于frame.js里设置currentCluster触发较晚，首页这里必须加上延迟，不然currentCluster取不到，导致错误逻辑
                    setTimeout(function(){
                        var queryString = yufp.sessionStorage.get("currentCluster") ? ('?cluster=' + yufp.sessionStorage.get("currentCluster")) : '';
                        yufp.service.request({
                            method:"GET",
                            url:"/api/cluster/outline" + queryString,
                            callback:function(code, message, response){
                                if(response.code == 0){
                                    _this.outline = response.data;
                                }
                            }
                        });
                    }, 20);

                },
                loadPjtInfo:function(){
                    var _this = this;
                    yufp.service.request({
                        method:"GET",
                        url:"/api/ymitinfo/pjtInfo?pjtCde="+yufp.session.project.pjtCde,
                        callback:function(code, message, response){
                            if(response.code==0){
                                _this.pjtInfo = response.data;
                                if(_this.pjtInfo == null){
                                    _this.pjtInfo={};
                                }
                            }
                        }
                    });
                },
                loadPjtAttach:function(){
                    var _this = this;
                    yufp.service.request({
                        method:"GET",
                        url:"/api/pjtattach/getattach",
                        data:{
                            page:1,
                            size:6
                        },
                        callback:function(code, message, response){
                            if(response.code == 0){
                                _this.pjtAttach = response.data;
                            }
                        }
                    });
                },
                loadSwiper:function(){
                	var mySwiper = new Swiper('.myswiper',{ 
              		visibilityFullFit: true,
              		slidesPerView : 'auto'
                	})
                	$('.left-arrow').click(function(){
						mySwiper.swipePrev(); 
					})
					$('.right-arrow').click(function(){
						mySwiper.swipeNext(); 
					})
                },
                loadSwiper1: function() {
					var mySwiper = $('.myswiper1').swiper({
							pagination : '.my-pagination',
							paginationClickable :true
					});
				}
            },
            computed:{
                'pjtSts':function(){
                    switch(this.pjtInfo.pjtSts){
                        case "1":
                            return "准备";
                        case "2":
                            return "设计";
                        case "3":
                            return "执行";
                        case "4":
                            return "结束";
                        default:
                            return "准备";
                    }
                }
            },
            mounted: function() {
				this.loadSwiper();
				this.loadSwiper1();
				this.initData();
			}
        });
    };

    exports.onmessage = function (type, message) {
    };

    exports.destroy = function (id, cite) {
    }

});