define(['jsplumb', 'echarts','jquery'], function (require, exports) {
    exports.ready = function (hashCode, data, cite) {
        var reg = /\d{1,3}(?=(\d{3})+(\.\d*)?$)/g;
        var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var me = this;
                return {
                    date: [],
                    timeList:[
                        {key:15,value:'最近15分钟'},
                        {key:60,value:'最近1小时'},
                        {key:4,value:'最近4小时'},
                        {key:24,value:'最近24小时'},
                        {key:7,value:'最近7天'}
                    ],
                    rotate:0,
                    loadChart: null,
                    loadData: [],
                    resTimeChart: null,
                    resTimeData: [],
                    errorsChart: null,
                    errorsData: [],
                    nodeInfoData: [],
                    serviceInfo: [],
                    scoreData: [],
                    rankData: [],
                    nodeDataList: [],
                    nodeJsonData: [],
                    connJsonData: [],
                    apmData: [],
                    totalUp: 0,
                    totalDown: 0,
                    totalWarn: 0,
                    apmErrors: 0,
                    transactions: 0,
                    loadNum: 0,
                    loadNumAvg: 0,
                    resTime: 0,
                    resTimeAvg: 0,
                    errorsNum: 0,
                    errorNumAvg: 0,
                    intervalTime:10,
                    intervalType:'m',
                    timeUnit:'min'
                }
            },
            methods: {
                //鼠标移入，显示时间选择框
                mouseoverFn:function(){
                    $('#yu-sysList').fadeIn('fast');
                },
                //点击事件，不显示时间选择框
                seenFn:function(){
                    $('#yu-sysList').fadeOut('fast');
                },
                //时间选择
                timePickFn:function(a){
                    if(a!=""&&a!=undefined){
                        var me = this;
                        me.intervalTime = a;
                        me.date = [];
                        var now = new Date();
                        if(me.intervalTime==4||me.intervalTime==24){
                            me.intervalType = 'h';
                            me.timeUnit = 'hour';
                            if(me.intervalTime==4){
                                me.rotate = 30;
                            }else{
                                me.rotate = 0;
                            }
                            for (var n = 0; n < me.intervalTime; n++) {
                                var lastDate = new Date(now - n * 3600000);
                                var hours = lastDate.getHours();
                                if(hours.toString().length==1){
                                    hours = 0+""+hours;
                                }
                                var minutes = lastDate.getMinutes();
                                if(minutes.toString().length==1){
                                    minutes = 0+""+minutes;
                                }
                                me.date.unshift(hours + ":" + minutes);
                            }
                        }else if(me.intervalTime==7){
                            me.rotate = 30;
                            me.intervalType = 'd';
                            me.timeUnit = 'day';
                        }else{
                            me.rotate = 0;
                            me.intervalType = 'm';
                            me.timeUnit = 'min';
                            me.dateFn(me.intervalTime);
                        }
                        me.nodeDataFn();
                    }
                },
                //请求量
                loadChartFn: function () {
                    this.loadChart.setOption({
                        title: {},
                        tooltip: {
                            trigger: 'axis',
                            position: function (pt) {
                                return [pt[0], '10%'];
                            }
                        },
                        grid: {
                            top: 30,
                            left: 10,
                            right: 10,
                            bottom: 15,
                            containLabel: true
                        },
                        textStyle: {
                            color: '#666'
                        },
                        xAxis: {
                            type: 'category',
                            boundaryGap: false,
                            data: this.date,
                            axisLine: {
                                lineStyle: {
                                    color: '#ddd'
                                }
                            },
                            axisLabel:{
                                rotate:this.rotate
                            }
                        },
                        yAxis: {
                            type: 'value',
                            axisLine: {
                                lineStyle: {
                                    color: '#ddd'
                                }
                            },
                            splitLine: {
                                show: false
                            }
                        },
                        series: [{
                            data: this.loadData,
                            type: 'line',
                            smooth: true,
                            itemStyle: {
                                normal: {
                                    color: "#20a0ff",
                                    lineStyle: {
                                        color: "#20a0ff"
                                    }
                                }
                            },
                            areaStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                        offset: 0,
                                        color: 'rgb(30, 144, 255)'
                                    }, {
                                        offset: 1,
                                        color: 'rgb(30, 144, 255)'
                                    }])
                                }
                            }
                        }]
                    });
                },
                //响应时间
                resTimeChartFn: function () {
                    this.resTimeChart.setOption({
                        title: {},
                        tooltip: {
                            trigger: 'axis',
                            position: function (pt) {
                                return [pt[0], '10%'];
                            }
                        },
                        grid: {
                            top: 30,
                            left: 10,
                            right: 10,
                            bottom: 15,
                            containLabel: true
                        },
                        textStyle: {
                            color: '#666'
                        },
                        xAxis: {
                            type: 'category',
                            boundaryGap: false,
                            data: this.date,
                            axisLine: {
                                lineStyle: {
                                    color: '#ddd'
                                }
                            },
                            axisLabel:{
                                rotate:this.rotate
                            }
                        },
                        yAxis: {
                            type: 'value',
                            axisLine: {
                                lineStyle: {
                                    color: '#ddd'
                                }
                            },
                            splitLine: {
                                show: false
                            }
                        },
                        series: [{
                            data: this.resTimeData,
                            type: 'line',
                            smooth: true,
                            itemStyle: {
                                normal: {
                                    color: "#20a0ff",
                                    lineStyle: {
                                        color: "#20a0ff"
                                    }
                                }
                            },
                            areaStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                        offset: 0,
                                        color: 'rgb(30, 144, 255)'
                                    }, {
                                        offset: 1,
                                        color: 'rgb(30, 144, 255)'
                                    }])
                                }
                            }
                        }]
                    });
                },
                //错误统计
                errorChartFn: function () {
                    this.errorsChart.setOption({
                        title: {},
                        tooltip: {
                            trigger: 'axis',
                            position: function (pt) {
                                return [pt[0], '10%'];
                            }
                        },
                        grid: {
                            top: 30,
                            left: 10,
                            right: 10,
                            bottom: 15,
                            containLabel: true
                        },
                        textStyle: {
                            color: '#666'
                        },
                        xAxis: {
                            type: 'category',
                            boundaryGap: false,
                            data: this.date,
                            axisLine: {
                                lineStyle: {
                                    color: '#ddd'
                                }
                            },
                            axisLabel:{
                                rotate:this.rotate
                            }
                        },
                        yAxis: {
                            type: 'value',
                            axisLine: {
                                lineStyle: {
                                    color: '#ddd'
                                }
                            },
                            splitLine: {
                                show: false
                            }
                        },
                        series: [{
                            data: this.errorsData,
                            type: 'line',
                            smooth: true,
                            itemStyle: {
                                normal: {
                                    color: "#20a0ff",
                                    lineStyle: {
                                        color: "#20a0ff"
                                    }
                                }
                            },
                            areaStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                        offset: 0,
                                        color: 'rgb(30, 144, 255)'
                                    }, {
                                        offset: 1,
                                        color: 'rgb(30, 144, 255)'
                                    }])
                                }
                            }
                        }]
                    });
                },
                //集群概况节点数据
                nodeDataFn: function () {
                    var me = this;
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/instancemanager/',
                        callback: function (code, message, response) {
                            me.serviceInfo = [];
                            if (code == '0' && response.code == 0) {
                                var serviceInfoData = response.data;
                                for (var s in serviceInfoData) {
                                    var instanceInfo = serviceInfoData[s].instances;
                                    var upCount = 0;
                                    var downCount = 0;
                                    var warnCount = 0;
                                    for (var f = 0; f < instanceInfo.length; f++) {
                                        if (instanceInfo[f].status == 'UP') {
                                            upCount++;
                                            me.totalUp++;
                                        } else if (instanceInfo[f].status == 'DOWN') {
                                            downCount++;
                                            me.totalDown++;
                                        } else {
                                            warnCount++;
                                            me.totalWarn++;
                                        }
                                    }
                                    me.serviceInfo.push(
                                        {
                                            service: serviceInfoData[s].name,
                                            insNum: instanceInfo.length,
                                            UP: upCount,
                                            DOWN: downCount,
                                            WARN: warnCount
                                        }
                                    );
                                }
                            }
                        }
                    });
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/service/basic/info',
                        callback: function (code, message, response) {
                            me.nodeInfoData = [];
                            me.nodeJsonData = [];
                            me.connJsonData = [];
                            if (code == 0 && response.code == 0) {
                                var nodeInfo = response.data;
                                for (var t = 0; t < nodeInfo.length; t++) {
                                    me.nodeInfoData.push({
                                        "id": nodeInfo[t].id,
                                        "name": nodeInfo[t].name,
                                        "type": "service",
                                        "dependService": nodeInfo[t].dependService,
                                        "offsetX": nodeInfo[t].offsetX,
                                        "offsetY": nodeInfo[t].offsetY
                                    });
                                    me.nodeJsonData.push(
                                        {
                                            nodeId: nodeInfo[t].id,
                                            nodeName: nodeInfo[t].name,
                                            offsetX: nodeInfo[t].offsetX,
                                            offsetY: nodeInfo[t].offsetY,
                                            type: 'service'
                                        }
                                    );
                                }
                                for (var i = 0; i < me.nodeInfoData.length; i++) {
                                    for (var m in me.nodeInfoData[i].dependService) {
                                        for (var n in me.nodeJsonData) {
                                            if (me.nodeInfoData[i].dependService[m] == me.nodeJsonData[n].nodeName) {
                                                me.connJsonData.push(
                                                    {
                                                        sourceId: me.nodeInfoData[i].id,
                                                        targetId: me.nodeJsonData[n].nodeId,
                                                        label: me.nodeInfoData[i].name
                                                    }
                                                );
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    });
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + 'api/elasticsearchMetrics/APMMetricsWithMinute?intervalType='+me.intervalType+'&intervalMinutes='+me.intervalTime,
                        callback: function (code, message, response) {
                            me.loadData = [];
                            me.resTimeData = [];
                            me.errorsData = [];
                            me.loadNum = 0;
                            me.resTime = 0;
                            me.errorsNum = 0;
                            var responseData = response.aggregations["apm-minute"].buckets;
                            for (var r in responseData) {
                                if(me.intervalType=='d'){
                                    var _reg =/(\d{4})\-(\d{2})\-(\d{2})/;
                                    var day = responseData[r].key_as_string.replace(_reg,"$1/$2/$3");
                                    day = day.substr(5)
                                    me.date.push(day);
                                }
                                me.loadData.push(responseData[r].transactions.value);
                                me.resTimeData.push(Math.ceil(responseData[r].rt.value / 1000));
                                me.errorsData.push(responseData[r].errors.value);
                                me.loadNum = me.loadNum + responseData[r].doc_count;
                                me.resTime = me.resTime + Math.ceil(responseData[r].rt.value / 1000);
                                me.errorsNum = me.errorsNum + responseData[r].errors.value;
                            }
                            me.loadNumAvg = (me.loadNum / me.intervalTime).toFixed(1).toString().replace(reg, '$&,');
                            me.resTimeAvg = (me.resTime / me.intervalTime).toFixed(1).toString().replace(reg, '$&,');
                            me.errorNumAvg = (me.errorsNum / me.intervalTime).toFixed(1).toString().replace(reg, '$&,');
                            me.loadNum = me.loadNum.toString().replace(reg, '$&,');
                            me.resTime = me.resTime.toString().replace(reg, '$&,');
                            me.errorsNum = me.errorsNum.toString().replace(reg, '$&,');
                            me.loadChartFn();
                            me.resTimeChartFn();
                            me.errorChartFn();
                        }
                    });
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/elasticsearchMetrics/APMMetrics?intervalType='+me.intervalType+'&intervalMinutes='+me.intervalTime,
                        callback: function (code, message, response) {
                            me.apmData = [];
                            me.rankData = [];
                            if (code == '0') {
                                var apmResponse = response.aggregations["apm-service"].buckets;
                                me.apmErrors = response.aggregations["apm-cluster-errors"].value;
                                me.transactions = response.aggregations["apm-cluster-transactions"].value;
                                var num = 0;
                                for (var m in apmResponse) {
                                    me.apmData.push(
                                        {
                                            service: apmResponse[m].key,
                                            count: apmResponse[m].doc_count.toString().replace(reg, '$&,'),
                                            errorsNum: apmResponse[m].errors.value.toString().replace(reg, '$&,'),
                                            resTime: Math.ceil(apmResponse[m].rt_stats.avg / 1000).toString().replace(reg, '$&,')
                                        }
                                    );
                                    num++;
                                    if (num <= 5) {
                                        me.rankData.push(
                                            {
                                                rank: num,
                                                service: apmResponse[m].key,
                                                count: apmResponse[m].doc_count.toString().replace(reg, '$&,')
                                            }
                                        );
                                    }
                                }
                            }
                            me.opFlowFn();
                            me.dataCountFn();
                        }
                    });
                },
                //保存集群位置信息
                saveNodeFn: function () {
                    var me = this;
                    var allNodes = jsPlumb.getSelector(".op-noder");
                    var saveNodeData = [];
                    for (var s = 0, len = allNodes.length; s < len; s++) {
                        saveNodeData.push(
                            {
                                nodeId: allNodes[s].id,
                                nodeName: allNodes[s].name,
                                offsetX: allNodes[s].offsetLeft,
                                offsetY: allNodes[s].offsetTop
                            }
                        );
                    }
                    yufp.service.request({
                        method: 'POST',
                        url: backend.dashboardService + '/api/service/basic/savenodeinfo',
                        data: {
                            coordinate: JSON.stringify(saveNodeData)
                        },
                        callback: function (code, message, response) {
                            if (code == '0' && response.code == 0) {
                                me.$message("节点位置保存成功");
                            } else {
                                me.$message("节点位置保存失败");
                            }
                        }
                    });
                },
                //集群概况
                opFlowFn: function () {
                    var me = this;
                    var nodes = document.getElementById('nodeCharts');
                    document.getElementById('nodeChart').removeChild(nodes);
                    var _nodes = document.createElement("div");
                    _nodes.style.position='relative';
                    _nodes.style.height='504px';
                    _nodes.style.width='100%';
                    _nodes.id = 'nodeCharts';
                    document.getElementById('nodeChart').appendChild(_nodes);
                    jsPlumb.ready(function () {
                        var instance = jsPlumb.getInstance({
                            ConnectionOverlays: [
                                ["Arrow", {location: 1, width: 8, length: 8}]
                            ],
                            Connector: ['StateMachine'],
                            //拖动时的演示
                            DragOptions: {cursor: 'pointer', zIndex: 2000},
                            //连接线的样式
                            PaintStyle: {
                                strokeStyle: '#bbb',
                                lineWidth: 1
                            },
                            //连接点的样式
                            EndpointStyle: {radius: 2, fillStyle: '#bbb'},
                            //hover时线样式
                            hoverPaintStyle: {
                                strokeStyle: '#bbb'
                            },
                            //hover时点的样式
                            EndpointHoverStyle: {fillStyle: '#f7ba2a'},
                            ReattachConnections: true,
                            deleteEndpointsOnDetach: false,
                            MaxConnections: -1,
                            Container: "nodeCharts"  //外部容器
                        });

                        var newNodeFn = function (node) {
                            var nodeBox = document.createElement("div");
                            nodeBox.className = "op-noder";
                            nodeBox.id = node.nodeId;
                            nodeBox.name = node.nodeName;
                            // nodeBox.title = node.nodeName;
                            nodeBox.style.left = node.offsetX + "px";
                            nodeBox.style.top = node.offsetY + "px";
                            instance.getContainer().appendChild(nodeBox);
                            instance.draggable(nodeBox.id);
                            //服务节点
                            if (node.type == 'service') {
                                //信息
                                var infoBox = document.createElement('p');
                                for (var r in me.apmData) {
                                    if (me.apmData[r].service.toUpperCase() == node.nodeName.toUpperCase()) {
                                        infoBox.innerHTML = me.apmData[r].count + ' calls/min<br/>' + me.apmData[r].resTime + ' ms<br/>' + me.apmData[r].errorsNum + ' errors/min';
                                        nodeBox.appendChild(infoBox);
                                        break;
                                    }
                                }
                                //饼图
                                var chartBox = document.createElement('div');
                                chartBox.className = 'nodeChartBox';
                                nodeBox.appendChild(chartBox);
                                var pieData = [];
                                var num = 0;
                                for (var p in me.serviceInfo) {
                                    var serviceInfo = me.serviceInfo[p];
                                    if (serviceInfo.service == node.nodeName) {
                                        pieData.push(
                                            {value: serviceInfo.UP, name: '正常'},
                                            {value: serviceInfo.WARN, name: '警告'},
                                            {value: serviceInfo.DOWN, name: '停用'}
                                        );
                                        num = serviceInfo.UP + '/' + serviceInfo.insNum;
                                        break;
                                    }
                                }
                                if (num == 0) {
                                    pieData.push(
                                        {value: 0, name: '正常'},
                                        {value: 0, name: '警告'},
                                        {value: 0, name: '停用'},
                                        {value: 1, name: '未启用'}
                                    );
                                }
                                newPieFn(chartBox, pieData, num);
                                chartBox.onmouseover = function () {
                                    var s = '';
                                    for (var i = 0; i < pieData.length; i++) {
                                        s += '\n' + pieData[i].name + '：' + pieData[i].value;
                                    }
                                    nodeBox.title = node.nodeName + s;
                                }
                            }
                            //中间件节点
                            if (node.type == 'middleware') {
                                var iconBox = document.createElement('i');
                                iconBox.className = 'el-icon-yx-stack';
                                nodeBox.appendChild(iconBox);
                            }
                            //数据库节点
                            if (node.type == 'database') {
                                var iconBox = document.createElement('i');
                                iconBox.className = 'el-icon-yx-database';
                                nodeBox.appendChild(iconBox);
                            }

                            //节点名称
                            var titleBox = document.createElement('span');
                            titleBox.innerHTML = node.nodeName;
                            nodeBox.appendChild(titleBox);
                        }
                        var newPieFn = function (o, pieData, num) {
                            var legendData = ['正常', '警告', '停用', '未启用'];
                            var option = {
                                title: {
                                    text: num,
                                    left: 'center',
                                    bottom: 'center',
                                    textStyle: {
                                        color: '#666',
                                        fontSize: 14,
                                        fontWeight: 'normal'
                                    }
                                },
                                legend: {
                                    show: false,
                                    orient: 'vertical',
                                    x: 'left',
                                    data: legendData
                                },
                                color: ['#13ce66', '#f7ba2a', '#ff4949', '#bbb'],
                                series: [{
                                    name: '服务',
                                    type: 'pie',
                                    radius: ['80%', '100%'],
                                    hoverAnimation: false,
                                    label: {
                                        normal: {
                                            show: false,
                                            position: 'center'
                                        }
                                    },
                                    data: pieData
                                }]
                            };
                            var chartBox = echarts.init(o);
                            chartBox.setOption(option);
                        };
                        instance.batch(function () {
                            for (var n in me.nodeJsonData) {
                                var node = me.nodeJsonData[n]
                                newNodeFn(node);
                            }
                            for (var k = 0; k < me.connJsonData.length; k++) {
                                var opconn = me.connJsonData[k];
                                instance.connect({
                                    source: opconn.sourceId,
                                    target: opconn.targetId,
                                    type: instance.PaintStyle,
                                    anchor: "AutoDefault"
                                    // overlays: [
                                    //     ["Label", {label: opconn.label, location: 0.5, cssClass: "labelClass"}]
                                    // ]
                                });
                            }
                        });
                        instance.unmakeEveryTarget().unmakeEverySource();
                    });
                },
                //数据统计
                dataCountFn: function () {
                    this.scoreData = [];
                    this.nodeDataList = [];
                    var instanceNum = this.totalDown + this.totalWarn + this.totalUp;
                    var transNum = this.apmErrors + this.transactions;
                    var errPer = ((this.apmErrors / transNum) * 100).toFixed(2) + '%';
                    var transPer = ((this.transactions / transNum) * 100).toFixed(2) + '%';
                    this.transactions = this.transactions.toString().replace(reg, '$&,');
                    this.apmErrors = this.apmErrors.toString().replace(reg, '$&,');
                    var scoreDataList = [
                        {status: '正常', percentage: transPer, num: this.transactions},
                        {status: '错误', percentage: errPer, num: this.apmErrors}
                    ];
                    this.scoreData = scoreDataList;

                    this.nodeDataList.push(
                        // {
                        //     title: '节点状态',
                        //     criticalPer: '0',
                        //     warningPer: '0',
                        //     normalPer: '100%',
                        //     criticalNum: 0,
                        //     warningNum: 0,
                        //     normalNum: 3
                        // },
                        {
                            title: '实例状态',
                            criticalPer: (this.totalDown / instanceNum) * 100 + '%',
                            warningPer: (this.totalWarn / instanceNum) * 100 + '%',
                            normalPer: (this.totalUp / instanceNum) * 100 + '%',
                            criticalNum: this.totalDown,
                            warningNum: this.totalWarn,
                            normalNum: this.totalUp
                        },
                        {
                            title: '交易状态',
                            criticalPer: errPer,
                            warningPer: '0',
                            normalPer: transPer,
                            criticalNum: this.apmErrors,
                            warningNum: 0,
                            normalNum: this.transactions
                        }
                    );
                },
                //时间横轴
                dateFn: function (timeRange) {
                    var now = new Date();
                    for (var n = 0; n < timeRange; n++) {
                        var lastDate = new Date(now - n * 60000);
                        var hours = lastDate.getHours();
                        var minutes = lastDate.getMinutes();
                        var timeStr;
                        if (hours > 12) {
                            hours -= 12;
                            timeStr = "PM";
                        } else {
                            timeStr = "AM";
                        }
                        hours = hours < 10 ? hours : hours;
                        minutes = minutes < 10 ? "0" + minutes : minutes;
                        var dates = hours + ":" + minutes + timeStr;
                        this.date.unshift(dates);
                    }
                }
            },
            mounted: function () {
                this.$nextTick(function () {
                    this.nodeDataFn();
                    this.dateFn(10);

                    this.loadChart = echarts.init(document.getElementById('loadChart'));
                    this.loadChartFn();

                    this.resTimeChart = echarts.init(document.getElementById('resTimeChart'));
                    this.resTimeChartFn();

                    this.errorsChart = echarts.init(document.getElementById('errorsChart'));
                    this.errorChartFn();

                });
            }

        });
    };
});