/**
 * 通用页面，用于嵌入iframe
 */
define(function (require, exports) {
    exports.ready = function (hashCode, data, cite) {
        var vm = yufp.custom.vue({
            el: cite.el,
            data: function () {
                var me = this;
                return {
                    commStyle: {
                        height: yufp.frame.size().height - 10 + 'px',
                        overflow: 'auto',
                        overflowX: 'hidden',
                        width: '100%'
                    },
                    pageurl: ''
                }
            },
            mounted: function () {
                var me = this;
                var router = yufp.router.getRoute(hashCode);
                console.log(router);
                var html = router.html;
                if (html.indexOf('?url=http') > 0) {
                    yufp.service.request({
                        method: 'GET',
                        url: backend.dashboardService + '/api/elkurl/info?relMenu=' + hashCode,
                        callback: function (code, message, response) {
                            if (code === 0 && response.code == 0) {
                                me.pageurl = response.data.url;
                            }
                        }
                    });
                }
            }
        });
    };
});