/**
 * 对el-upload进行封装，自定义上传方法
 */
(function(vue, $, name) {
    // 注册yufp-upload组件
    vue.component(name,{
        template:'',
        data:function(){
            return {};
        },
        methods:{
            // 上传方法可供为外部调用
            upload:function(param){
                var me = this;
                var xhr = null;
                if (window.XMLHttpRequest) {
                    xhr = new XMLHttpRequest();
                } else if (window.ActiveXObject) {
                    xhr = new ActiveXObject("Microsoft.XMLHTTP");
                } else {
                    console.log("你的浏览器不支持XMLHttp!");
                    return false;
                }

                var settings = {
                    headers: {
                        'Authorization': yufp.service.getToken()
                    },
                    method: 'post',
                    async: true,
                    data: []
                };

                // 设置上传地址
                if(this.uploadAction!=""){
                    settings.url=this.uploadAction;
                }

                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {

                    }
                };

                xhr.open(settings.method, settings.url, settings.async);

                var _headers = settings.headers;
                for (var key in _headers) {
                    xhr.setRequestHeader(key, _headers[key]);
                }


                xhr.send();
                return xhr;
            }
        }
    });
})(Vue, yufp.$, "yufp-upload");