/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.Impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.LogTradeQueryBo;
import cn.com.yusys.yusp.operation.dao.LogTradeQueryDao;
import cn.com.yusys.yusp.operation.domain.entity.LogTradeQueryEntity;
import cn.com.yusys.yusp.operation.domain.query.LogTradeQueryQuery;
import cn.com.yusys.yusp.operation.service.LogTradeQueryService;
import cn.com.yusys.yusp.operation.vo.LogTradeQueryVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogTradeQueryServiceImpl
implements LogTradeQueryService {
    @Autowired
    private LogTradeQueryDao logTradeQueryDao;

    @Override
    public int create(LogTradeQueryBo logTradeQueryBo) throws Exception {
        LogTradeQueryEntity logTradeQueryEntity = new LogTradeQueryEntity();
        BeanUtils.beanCopy((Object)logTradeQueryBo, (Object)logTradeQueryEntity);
        logTradeQueryEntity.setLogId(StringUtils.getUUID());
        return this.logTradeQueryDao.insert(logTradeQueryEntity);
    }

    @Override
    public LogTradeQueryVo show(LogTradeQueryQuery logTradeQueryQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)logTradeQueryQuery);
        List<LogTradeQueryVo> list = this.list(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ logId=" + logTradeQueryQuery.getLogId() + " ]");
        }
        return list.get(0);
    }

    @Override
    @MyPageAble(returnVo=LogTradeQueryVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<LogTradeQueryEntity> list = this.logTradeQueryDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<LogTradeQueryVo> list(QueryModel model) throws Exception {
        List<LogTradeQueryEntity> list = this.logTradeQueryDao.selectByModel(model);
        List logTradeQueryVos = (List)BeanUtils.beansCopy(list, LogTradeQueryVo.class);
        return logTradeQueryVos;
    }

    @Override
    public int update(LogTradeQueryBo logTradeQueryBo) throws Exception {
        LogTradeQueryEntity logTradeQueryEntity = new LogTradeQueryEntity();
        BeanUtils.beanCopy((Object)logTradeQueryBo, (Object)logTradeQueryEntity);
        return this.logTradeQueryDao.updateByPrimaryKey(logTradeQueryEntity);
    }

    @Override
    public int delete(String logId) throws Exception {
        return this.logTradeQueryDao.deleteByPrimaryKey(logId);
    }
}

