/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookMaintenanceLogBo;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogMonitorDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogPatrolDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogRepairDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogSecDao;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogMonitorEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogPatrolEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogRepairEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogSecEntity;
import cn.com.yusys.yusp.operation.domain.query.BookMaintenanceLogQuery;
import cn.com.yusys.yusp.operation.service.BookMaintenanceLogService;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogMonitorVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogPatrolVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogRepairVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogSecVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookMaintenanceLogServiceImpl
implements BookMaintenanceLogService {
    private static final Logger logger = LoggerFactory.getLogger(BookMaintenanceLogServiceImpl.class);
    @Autowired
    private BookMaintenanceLogDao bookMaintenanceLogDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean create(BookMaintenanceLogBo bookMaintenanceLogBo) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        boolean flag = false;
        try {
            BookMaintenanceLogEntity bookMaintenanceLogEntity = new BookMaintenanceLogEntity();
            BeanUtils.beanCopy((Object)bookMaintenanceLogBo, (Object)bookMaintenanceLogEntity);
            bookMaintenanceLogEntity.setWorkLogId(StringUtils.getUUID());
            this.bookMaintenanceLogDao.insert(bookMaintenanceLogEntity);
            List patrolBoList = bookMaintenanceLogBo.getPatrolList();
            patrolBoList.forEach(patrolBo -> {
                BookMaintenanceLogPatrolEntity entity = (BookMaintenanceLogPatrolEntity)BeanUtils.beanCopy((Object)patrolBo, BookMaintenanceLogPatrolEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setPatrolId(StringUtils.getUUID());
                patrolDao.insert(entity);
            });
            List secBoList = bookMaintenanceLogBo.getSecList();
            secBoList.forEach(secBo -> {
                BookMaintenanceLogSecEntity entity = (BookMaintenanceLogSecEntity)BeanUtils.beanCopy((Object)secBo, BookMaintenanceLogSecEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setSecId(StringUtils.getUUID());
                secDao.insert(entity);
            });
            List monitorBoList = bookMaintenanceLogBo.getMonitorList();
            monitorBoList.forEach(monitorBo -> {
                BookMaintenanceLogMonitorEntity entity = (BookMaintenanceLogMonitorEntity)BeanUtils.beanCopy((Object)monitorBo, BookMaintenanceLogMonitorEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setMonitorId(StringUtils.getUUID());
                monitorDao.insert(entity);
            });
            List repairBoList = bookMaintenanceLogBo.getRepairList();
            repairBoList.forEach(repairBo -> {
                BookMaintenanceLogRepairEntity entity = (BookMaintenanceLogRepairEntity)BeanUtils.beanCopy((Object)repairBo, BookMaintenanceLogRepairEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setRepairId(StringUtils.getUUID());
                repairDao.insert(entity);
            });
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public BookMaintenanceLogVo show(BookMaintenanceLogQuery bookMaintenanceLogQuery) throws Exception {
        BookMaintenanceLogVo vo = new BookMaintenanceLogVo();
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        try {
            QueryModel logModel = new QueryModel();
            logModel.setCondition((Object)bookMaintenanceLogQuery);
            List<BookMaintenanceLogEntity> list = this.bookMaintenanceLogDao.selectByModel(logModel);
            if (list == null || list.size() == 0) {
                throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ workLogId=" + bookMaintenanceLogQuery.getWorkLogId() + " ]");
            }
            BeanUtils.beanCopy((Object)list.get(0), (Object)vo);
            QueryModel monitorModel = new QueryModel();
            BookMaintenanceLogMonitorEntity monitorEntity = new BookMaintenanceLogMonitorEntity();
            monitorEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            monitorModel.setCondition((Object)monitorEntity);
            List<BookMaintenanceLogMonitorEntity> monitorEntities = monitorDao.selectByModel(monitorModel);
            List monitorVos = (List)BeanUtils.beansCopy(monitorEntities, BookMaintenanceLogMonitorVo.class);
            vo.setMonitorList(monitorVos);
            QueryModel secModel = new QueryModel();
            BookMaintenanceLogSecEntity secEntity = new BookMaintenanceLogSecEntity();
            secEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            secModel.setCondition((Object)secEntity);
            List<BookMaintenanceLogSecEntity> secEntities = secDao.selectByModel(secModel);
            List secVos = (List)BeanUtils.beansCopy(secEntities, BookMaintenanceLogSecVo.class);
            vo.setSecList(secVos);
            QueryModel repairModel = new QueryModel();
            BookMaintenanceLogRepairEntity repairEntity = new BookMaintenanceLogRepairEntity();
            repairEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            repairModel.setCondition((Object)repairEntity);
            List<BookMaintenanceLogRepairEntity> repairEntities = repairDao.selectByModel(repairModel);
            List repairVos = (List)BeanUtils.beansCopy(repairEntities, BookMaintenanceLogRepairVo.class);
            vo.setRepairList(repairVos);
            QueryModel patrolModel = new QueryModel();
            BookMaintenanceLogPatrolEntity patrolEntity = new BookMaintenanceLogPatrolEntity();
            patrolEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            patrolModel.setCondition((Object)repairEntity);
            List<BookMaintenanceLogPatrolEntity> patrolEntities = patrolDao.selectByModel(patrolModel);
            List patrolVos = (List)BeanUtils.beansCopy(patrolEntities, BookMaintenanceLogPatrolVo.class);
            vo.setPatrolList(patrolVos);
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return vo;
    }

    @MyPageAble(returnVo=BookMaintenanceLogVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookMaintenanceLogEntity> list = this.bookMaintenanceLogDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookMaintenanceLogVo> list(QueryModel model) throws Exception {
        List<BookMaintenanceLogEntity> list = this.bookMaintenanceLogDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookMaintenanceLogVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(BookMaintenanceLogBo bookMaintenanceLogBo) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        boolean flag = false;
        try {
            BookMaintenanceLogEntity bookMaintenanceLogEntity = new BookMaintenanceLogEntity();
            BeanUtils.beanCopy((Object)bookMaintenanceLogBo, (Object)bookMaintenanceLogEntity);
            this.bookMaintenanceLogDao.updateByPrimaryKey(bookMaintenanceLogEntity);
            patrolDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List patrolBoList = bookMaintenanceLogBo.getPatrolList();
            patrolBoList.forEach(patrolBo -> {
                BookMaintenanceLogPatrolEntity entity = (BookMaintenanceLogPatrolEntity)BeanUtils.beanCopy((Object)patrolBo, BookMaintenanceLogPatrolEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setPatrolId(StringUtils.getUUID());
                patrolDao.insert(entity);
            });
            secDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List secBoList = bookMaintenanceLogBo.getSecList();
            secBoList.forEach(secBo -> {
                BookMaintenanceLogSecEntity entity = (BookMaintenanceLogSecEntity)BeanUtils.beanCopy((Object)secBo, BookMaintenanceLogSecEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setSecId(StringUtils.getUUID());
                secDao.insert(entity);
            });
            monitorDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List monitorBoList = bookMaintenanceLogBo.getMonitorList();
            monitorBoList.forEach(monitorBo -> {
                BookMaintenanceLogMonitorEntity entity = (BookMaintenanceLogMonitorEntity)BeanUtils.beanCopy((Object)monitorBo, BookMaintenanceLogMonitorEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setMonitorId(StringUtils.getUUID());
                monitorDao.insert(entity);
            });
            repairDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List repairBoList = bookMaintenanceLogBo.getRepairList();
            repairBoList.forEach(repairBo -> {
                BookMaintenanceLogRepairEntity entity = (BookMaintenanceLogRepairEntity)BeanUtils.beanCopy((Object)repairBo, BookMaintenanceLogRepairEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setRepairId(StringUtils.getUUID());
                repairDao.insert(entity);
            });
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean delete(String workLogId) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        boolean flag = false;
        try {
            monitorDao.deleteByWorkLogId(workLogId);
            secDao.deleteByWorkLogId(workLogId);
            repairDao.deleteByWorkLogId(workLogId);
            patrolDao.deleteByWorkLogId(workLogId);
            this.bookMaintenanceLogDao.deleteByPrimaryKey(workLogId);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }
}

