/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookLengthFundBo;
import cn.com.yusys.yusp.operation.dao.BookLengthFundDao;
import cn.com.yusys.yusp.operation.domain.entity.BookLengthFundEntity;
import cn.com.yusys.yusp.operation.domain.query.BookLengthFundQuery;
import cn.com.yusys.yusp.operation.service.BookLengthFundService;
import cn.com.yusys.yusp.operation.vo.BookLengthFundVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookLengthFundServiceImpl
implements BookLengthFundService {
    private static final Logger logger = LoggerFactory.getLogger(BookLengthFundServiceImpl.class);
    @Autowired
    private BookLengthFundDao bookLengthFundDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(List<BookLengthFundBo> list) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookLengthFundDao bookLengthFundDao = (BookLengthFundDao)session.getMapper(BookLengthFundDao.class);
        int num = 0;
        try {
            list.forEach(bookLengthFundBo -> {
                BookLengthFundEntity entity = (BookLengthFundEntity)BeanUtils.beanCopy((Object)bookLengthFundBo, BookLengthFundEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                bookLengthFundDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookLengthFundVo show(BookLengthFundQuery bookLengthFundQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookLengthFundQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookLengthFundQuery.getTradeId() + " ]");
        }
        return (BookLengthFundVo)list.get(0);
    }

    @MyPageAble(returnVo=BookLengthFundVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookLengthFundVo> list(QueryModel model) throws Exception {
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookLengthFundVo.class);
        return listVo;
    }

    @Override
    public int update(BookLengthFundBo bookLengthFundBo) throws Exception {
        BookLengthFundEntity bookLengthFundEntity = new BookLengthFundEntity();
        BeanUtils.beanCopy((Object)bookLengthFundBo, (Object)bookLengthFundEntity);
        return this.bookLengthFundDao.updateByPrimaryKey(bookLengthFundEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookLengthFundDao.deleteByPrimaryKey(tradeId);
    }
}

