/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookDeviceMaintainBo;
import cn.com.yusys.yusp.operation.dao.BookDeviceMaintainDao;
import cn.com.yusys.yusp.operation.domain.entity.BookDeviceMaintainEntity;
import cn.com.yusys.yusp.operation.domain.query.BookDeviceMaintainQuery;
import cn.com.yusys.yusp.operation.service.BookDeviceMaintainService;
import cn.com.yusys.yusp.operation.vo.BookDeviceMaintainVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookDeviceMaintainServiceImpl
implements BookDeviceMaintainService {
    private static final Logger logger = LoggerFactory.getLogger(BookDeviceMaintainServiceImpl.class);
    @Autowired
    private BookDeviceMaintainDao bookDeviceMaintainDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(List<BookDeviceMaintainBo> list) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookDeviceMaintainDao bookDeviceMaintainDao = (BookDeviceMaintainDao)session.getMapper(BookDeviceMaintainDao.class);
        int num = 0;
        try {
            list.forEach(bookDeviceMaintainBo -> {
                BookDeviceMaintainEntity entity = (BookDeviceMaintainEntity)BeanUtils.beanCopy((Object)bookDeviceMaintainBo, BookDeviceMaintainEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                bookDeviceMaintainDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookDeviceMaintainVo show(BookDeviceMaintainQuery bookDeviceMaintainQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookDeviceMaintainQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookDeviceMaintainQuery.getTradeId() + " ]");
        }
        return (BookDeviceMaintainVo)list.get(0);
    }

    @MyPageAble(returnVo=BookDeviceMaintainVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookDeviceMaintainEntity> list = this.bookDeviceMaintainDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookDeviceMaintainVo> list(QueryModel model) throws Exception {
        List<BookDeviceMaintainEntity> list = this.bookDeviceMaintainDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookDeviceMaintainVo.class);
        return listVo;
    }

    @Override
    public int update(BookDeviceMaintainBo bookDeviceMaintainBo) throws Exception {
        BookDeviceMaintainEntity bookDeviceMaintainEntity = new BookDeviceMaintainEntity();
        BeanUtils.beanCopy((Object)bookDeviceMaintainBo, (Object)bookDeviceMaintainEntity);
        return this.bookDeviceMaintainDao.updateByPrimaryKey(bookDeviceMaintainEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookDeviceMaintainDao.deleteByPrimaryKey(tradeId);
    }
}

