/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterPropagandaBo;
import cn.com.yusys.yusp.operation.dao.BookCounterPropagandaDao;
import cn.com.yusys.yusp.operation.domain.entity.BookCounterPropagandaEntity;
import cn.com.yusys.yusp.operation.domain.query.BookCounterPropagandaQuery;
import cn.com.yusys.yusp.operation.service.BookCounterPropagandaService;
import cn.com.yusys.yusp.operation.vo.BookCounterPropagandaVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCounterPropagandaServiceImpl
implements BookCounterPropagandaService {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterPropagandaServiceImpl.class);
    @Autowired
    private BookCounterPropagandaDao bookCounterPropagandaDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(List<BookCounterPropagandaBo> list) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookCounterPropagandaDao bookCounterPropagandaDao = (BookCounterPropagandaDao)session.getMapper(BookCounterPropagandaDao.class);
        int num = 0;
        try {
            list.forEach(bookCounterPropagandaBo -> {
                BookCounterPropagandaEntity entity = (BookCounterPropagandaEntity)BeanUtils.beanCopy((Object)bookCounterPropagandaBo, BookCounterPropagandaEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                bookCounterPropagandaDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookCounterPropagandaVo show(BookCounterPropagandaQuery bookCounterPropagandaQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCounterPropagandaQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookCounterPropagandaQuery.getTradeId() + " ]");
        }
        return (BookCounterPropagandaVo)list.get(0);
    }

    @MyPageAble(returnVo=BookCounterPropagandaVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCounterPropagandaVo> list(QueryModel model) throws Exception {
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookCounterPropagandaVo.class);
        return listVo;
    }

    @Override
    public int update(BookCounterPropagandaBo bookCounterPropagandaBo) throws Exception {
        BookCounterPropagandaEntity bookCounterPropagandaEntity = new BookCounterPropagandaEntity();
        BeanUtils.beanCopy((Object)bookCounterPropagandaBo, (Object)bookCounterPropagandaEntity);
        return this.bookCounterPropagandaDao.updateByPrimaryKey(bookCounterPropagandaEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCounterPropagandaDao.deleteByPrimaryKey(tradeId);
    }
}

