/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookCardTradeBo;
import cn.com.yusys.yusp.operation.dao.BookCardTradeDao;
import cn.com.yusys.yusp.operation.domain.entity.BookCardTradeEntity;
import cn.com.yusys.yusp.operation.domain.query.BookCardTradeQuery;
import cn.com.yusys.yusp.operation.service.BookCardTradeService;
import cn.com.yusys.yusp.operation.vo.BookCardTradeVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCardTradeServiceImpl
implements BookCardTradeService {
    @Autowired
    private BookCardTradeDao bookCardTradeDao;

    @Override
    public int create(BookCardTradeBo bookCardTradeBo) throws Exception {
        BookCardTradeEntity bookCardTradeEntity = new BookCardTradeEntity();
        BeanUtils.beanCopy((Object)bookCardTradeBo, (Object)bookCardTradeEntity);
        bookCardTradeEntity.setTradeId(StringUtils.getUUID());
        return this.bookCardTradeDao.insert(bookCardTradeEntity);
    }

    @Override
    public BookCardTradeVo show(BookCardTradeQuery bookCardTradeQuery) throws Exception {
        BookCardTradeEntity bookCardTradeEntity = new BookCardTradeEntity();
        BeanUtils.beanCopy((Object)bookCardTradeQuery, (Object)bookCardTradeEntity);
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCardTradeEntity);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] logId=" + bookCardTradeEntity.getTradeId() + " ]");
        }
        return (BookCardTradeVo)list.get(0);
    }

    @MyPageAble(returnVo=BookCardTradeVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookCardTradeEntity> list = this.bookCardTradeDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCardTradeVo> list(QueryModel model) throws Exception {
        List<BookCardTradeEntity> list = this.bookCardTradeDao.selectByModel(model);
        List bookCardTradeVos = (List)BeanUtils.beansCopy(list, BookCardTradeVo.class);
        return bookCardTradeVos;
    }

    @Override
    public int update(BookCardTradeBo bookCardTradeBo) throws Exception {
        BookCardTradeEntity bookCardTradeEntity = new BookCardTradeEntity();
        BeanUtils.beanCopy((Object)bookCardTradeBo, (Object)bookCardTradeEntity);
        return this.bookCardTradeDao.updateByPrimaryKey(bookCardTradeEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCardTradeDao.deleteByPrimaryKey(tradeId);
    }
}

