/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.auth.service.Impl;

import cn.com.yusys.yusp.auth.bo.AuthParamOrgTradeSwitchBo;
import cn.com.yusys.yusp.auth.dao.AuthParamOrgTradeSwitchDao;
import cn.com.yusys.yusp.auth.domain.dto.OrgTradeDto;
import cn.com.yusys.yusp.auth.domain.entity.AuthParamOrgTradeSwitchEntity;
import cn.com.yusys.yusp.auth.domain.query.AuthParamOrgTradeSwitchQuery;
import cn.com.yusys.yusp.auth.service.AuthParamOrgTradeSwitchService;
import cn.com.yusys.yusp.auth.vo.AuthParamOrgTradeSwitchVo;
import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class AuthParamOrgTradeSwitchServiceImpl
implements AuthParamOrgTradeSwitchService {
    private static final Logger logger = LoggerFactory.getLogger(AuthParamOrgTradeSwitchServiceImpl.class);
    @Autowired
    private AuthParamOrgTradeSwitchDao authParamOrgTradeSwitchDao;

    @Override
    public int create(AuthParamOrgTradeSwitchBo authParamOrgTradeSwitchBo) throws Exception {
        AuthParamOrgTradeSwitchEntity authParamOrgTradeSwitchEntity = new AuthParamOrgTradeSwitchEntity();
        BeanUtils.beanCopy((Object)authParamOrgTradeSwitchBo, (Object)authParamOrgTradeSwitchEntity);
        authParamOrgTradeSwitchEntity.setParamId(StringUtils.getUUID());
        authParamOrgTradeSwitchEntity.setLastChgUser(SessionUtils.getUserId());
        authParamOrgTradeSwitchEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamOrgTradeSwitchDao.insert(authParamOrgTradeSwitchEntity);
    }

    @Override
    public AuthParamOrgTradeSwitchVo show(AuthParamOrgTradeSwitchQuery authParamOrgTradeSwitchQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamOrgTradeSwitchQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] logId=" + authParamOrgTradeSwitchQuery.getParamId() + " ]");
        }
        return (AuthParamOrgTradeSwitchVo)list.get(0);
    }

    @MyPageAble(returnVo=OrgTradeDto.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<OrgTradeDto> list = this.authParamOrgTradeSwitchDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<AuthParamOrgTradeSwitchVo> list(QueryModel model) throws Exception {
        List<OrgTradeDto> list = this.authParamOrgTradeSwitchDao.selectByModel(model);
        List authParamOrgTradeSwitchVos = (List)BeanUtils.beansCopy(list, AuthParamOrgTradeSwitchVo.class);
        return authParamOrgTradeSwitchVos;
    }

    @Override
    public int update(AuthParamOrgTradeSwitchBo authParamOrgTradeSwitchBo) throws Exception {
        AuthParamOrgTradeSwitchEntity authParamOrgTradeSwitchEntity = new AuthParamOrgTradeSwitchEntity();
        BeanUtils.beanCopy((Object)authParamOrgTradeSwitchBo, (Object)authParamOrgTradeSwitchEntity);
        authParamOrgTradeSwitchEntity.setLastChgUser(SessionUtils.getUserId());
        authParamOrgTradeSwitchEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamOrgTradeSwitchDao.updateByPrimaryKey(authParamOrgTradeSwitchEntity);
    }

    @Override
    public int delete(String paramId) throws Exception {
        return this.authParamOrgTradeSwitchDao.deleteByPrimaryKey(paramId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<OrgTradeDto> orgTradeDtoList = this.authParamOrgTradeSwitchDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cMenuCodeTitle = rowTitle.createCell(0);
        cMenuCodeTitle.setCellValue("\u4ea4\u6613\u7801");
        Cell cMenuNameTitle = rowTitle.createCell(1);
        cMenuNameTitle.setCellValue("\u4ea4\u6613\u540d");
        Cell cOrgIdTitle = rowTitle.createCell(2);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cOrgNameTitle = rowTitle.createCell(3);
        cOrgNameTitle.setCellValue("\u673a\u6784\u540d");
        Cell cAuthTypeTitle = rowTitle.createCell(4);
        cAuthTypeTitle.setCellValue("\u6388\u6743\u7c7b\u578b");
        int num = 1;
        for (OrgTradeDto orgTradeDto : orgTradeDtoList) {
            HSSFRow row = sheet.createRow(num++);
            Cell cMenuCode = row.createCell(0);
            cMenuCode.setCellValue(orgTradeDto.getMenuCode());
            Cell cTradeName = row.createCell(1);
            cTradeName.setCellValue(orgTradeDto.getTradeName());
            Cell cOrgId = row.createCell(2);
            cOrgId.setCellValue(orgTradeDto.getOrgId());
            Cell cOrgName = row.createCell(3);
            cOrgName.setCellValue(orgTradeDto.getOrgName());
            Cell cAuthType = row.createCell(4);
            cAuthType.setCellValue(orgTradeDto.getAuthType());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"OrgTrade_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @Override
    public int upload(MultipartFile file) throws Exception {
        String sheetName = "Sheet0";
        FileInputStream fileInputStream = (FileInputStream)file.getInputStream();
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fileInputStream);
        HSSFSheet sheet = workbook.getSheet(sheetName);
        ArrayList<AuthParamOrgTradeSwitchEntity> entities = new ArrayList<AuthParamOrgTradeSwitchEntity>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            AuthParamOrgTradeSwitchEntity entity = new AuthParamOrgTradeSwitchEntity();
            entity.setParamId(StringUtils.getUUID());
            entity.setMenuCode(sheet.getRow(i).getCell(0).toString());
            entity.setTradeName(sheet.getRow(i).getCell(1).toString());
            entity.setOrgId(sheet.getRow(i).getCell(2).toString());
            QueryModel model = new QueryModel();
            model.setCondition((Object)entity);
            List<OrgTradeDto> dtoList = this.authParamOrgTradeSwitchDao.selectByModel(model);
            if (dtoList.size() == 1) continue;
            entity.setLastChgUser(SessionUtils.getUserId());
            entity.setLastChgDt(DateUtils.formatDateByDef());
            entities.add(entity);
        }
        int count = 0;
        for (AuthParamOrgTradeSwitchEntity entity : entities) {
            this.authParamOrgTradeSwitchDao.insert(entity);
            ++count;
        }
        return count;
    }
}

