/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mq.guard.config;

import cn.com.yusys.yusp.commons.util.JsonUtils;
import cn.com.yusys.yusp.mq.guard.MQRecordGuardContext;
import cn.com.yusys.yusp.mq.guard.entity.MqRecord;
import cn.com.yusys.yusp.mq.guard.service.IMqRecordService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMQTemplateGuard
extends RabbitTemplate {
    private String applicationName;
    private IMqRecordService mqSendRecordService;

    public RabbitMQTemplateGuard(String applicationName, IMqRecordService mqSendRecordService) {
        this.mqSendRecordService = mqSendRecordService;
        this.applicationName = applicationName;
    }

    public void send(@NotNull String exchange, @NotNull String routingKey, @NotNull Message message, CorrelationData correlationData) throws AmqpException {
        String recordId = (String)MQRecordGuardContext.get("recordId");
        if (StringUtils.isEmpty((CharSequence)recordId)) {
            MqRecord mqRecord = new MqRecord();
            recordId = UUID.randomUUID().toString();
            mqRecord.setRecordId(recordId);
            mqRecord.setApplicationName(this.applicationName);
            mqRecord.setMqExchange(exchange);
            mqRecord.setRoutingKey(routingKey);
            mqRecord.setMsgProperties(JsonUtils.toJson((Object)message.getMessageProperties()));
            mqRecord.setMsgBody(new String(message.getBody(), StandardCharsets.UTF_8));
            mqRecord.setState("0");
            mqRecord.setDoAction("0");
            mqRecord.setRetryTime(0);
            mqRecord.setCreateTime(LocalDateTime.now());
            this.mqSendRecordService.createMqRecord(mqRecord);
        }
        try {
            super.send(exchange, routingKey, message, correlationData);
            this.updateRecordState(recordId, "1");
        }
        catch (AmqpException e) {
            this.updateRecordState(recordId, "2");
            throw e;
        }
    }

    private void updateRecordState(String recordId, String state) {
        MqRecord updateMqRecordState = new MqRecord();
        updateMqRecordState.setRecordId(recordId);
        updateMqRecordState.setState(state);
        this.mqSendRecordService.updateMqRecord(updateMqRecordState);
    }
}

