/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.mq.guard;

import cn.com.yusys.yusp.commons.util.JsonUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.mq.guard.MQRecordGuardContext;
import cn.com.yusys.yusp.mq.guard.entity.MqRecord;
import cn.com.yusys.yusp.mq.guard.service.IMqRecordService;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.stereotype.Component;

@Component
public class MQRecordSomeJob {
    private static final Logger log = LoggerFactory.getLogger(MQRecordSomeJob.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    IMqRecordService mqRecordService;
    @Autowired
    private Tracer tracer;
    private SpanNamer spanNamer = new DefaultSpanNamer();

    @XxlJob(value="MQRecordSomeJob.mqRecordHandle")
    public void mqRecordHandle() {
        new TraceRunnable(this.tracer, this.spanNamer, this::doMqRecordHandle).run();
    }

    private void doMqRecordHandle() {
        log.info("\u5f00\u59cb\u8fdb\u884cMQ\u6d88\u606f\u8bb0\u5f55\u7684\u91cd\u65b0\u6295\u9012");
        List<MqRecord> mqRecordList = this.mqRecordService.queryNeedReDeliveryRecord();
        if (CollectionUtils.isEmpty(mqRecordList)) {
            log.info("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u8bb0\u5f55");
            return;
        }
        for (MqRecord mqRecord : mqRecordList) {
            String recordId = mqRecord.getRecordId();
            String mqExchange = mqRecord.getMqExchange();
            String routingKey = mqRecord.getRoutingKey();
            String queue = mqRecord.getQueue();
            String msgProperties = mqRecord.getMsgProperties();
            String msgBody = mqRecord.getMsgBody();
            MqRecord updateRedelivery = new MqRecord();
            updateRedelivery.setRecordId(recordId);
            updateRedelivery.setState("3");
            boolean success = this.mqRecordService.updateMqRecordExpHandle(updateRedelivery);
            if (!success) {
                log.info("\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u5728\u91cd\u65b0\u5904\u7406\u4e2d {}", (Object)recordId);
                continue;
            }
            try {
                MQRecordGuardContext.set("recordId", recordId);
                MessageProperties messageProperties = (MessageProperties)JsonUtils.parse((String)msgProperties, MessageProperties.class);
                Message message = null != messageProperties ? new Message(msgBody.getBytes(StandardCharsets.UTF_8), messageProperties) : new Message(msgBody.getBytes(StandardCharsets.UTF_8));
                if (StringUtils.isNotEmpty((CharSequence)routingKey)) {
                    this.rabbitTemplate.convertAndSend(mqExchange, routingKey, (Object)message);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)queue)) {
                    this.rabbitTemplate.convertAndSend(mqExchange, queue, (Object)message);
                    continue;
                }
                log.info("\u65e0\u6548\u7684\u8bb0\u5f55\u6570\u636e(\u65e0\u6cd5\u91cd\u65b0\u6295\u9012) {}", (Object)mqRecord.getRecordId());
            }
            catch (Exception e) {
                log.error("\u6d88\u606f [{}] \u91cd\u53d1\u5f02\u5e38", (Object)recordId, (Object)e);
            }
        }
        MQRecordGuardContext.clear();
        log.info("\u91cd\u65b0\u6295\u9012\u5904\u7406\u5b8c\u6210");
    }

    @XxlJob(value="MQRecordSomeJob.mqRecordClean")
    public void mqRecordClean() {
        log.info("\u5f00\u59cb\u6e05\u7406\u6d88\u606f\u961f\u5217\u8bb0\u5f55\u8868\u4e2d\u7684\u6570\u636e");
        this.mqRecordService.removeMqRecord();
        log.info("\u6e05\u7406\u5b8c\u6210");
    }
}

