/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.cglib;

import cn.com.yusys.yusp.commons.validation.cglib.BeanValidator;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorDescription;
import cn.com.yusys.yusp.commons.validation.cglib.BeanValidatorFieldType;
import java.util.HashSet;
import java.util.function.Consumer;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.Type;

public class BeanMemberValidatorSupport {
    private static final String MEMBER_VALIDATOR_SUFFIX = "MemberValidator";
    private static final Type BEAN_MEMBER_SUPPORT = TypeUtils.parseType((String)BeanMemberValidatorSupport.class.getName());
    private static final Signature METHOD_VALIDATE_MEMBER = new Signature("validateMember", Type.VOID_TYPE, new Type[]{BeanValidator.BEAN_VALIDATOR, Constants.TYPE_OBJECT, BeanValidator.TYPE_DESC, Constants.TYPE_CLASS_ARRAY});

    static boolean apply(Class<?> fieldClazz) {
        return fieldClazz.isMemberClass() || !BeanMemberValidatorSupport.isSimpleClass(fieldClazz);
    }

    private static boolean isSimpleClass(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum() || clazz.getName().startsWith("java");
    }

    static void generatorStatic(CodeEmitter staticEmitter, BeanValidatorFieldType fieldType, String memberName) {
        String staticName = memberName + MEMBER_VALIDATOR_SUFFIX;
        staticEmitter.getClassEmitter().declare_field(26, staticName, BeanValidator.BEAN_VALIDATOR, null);
        if (fieldType.isCollection()) {
            staticEmitter.visitLdcInsn((Object)Type.getType(fieldType.getItemClazz()));
            Object[] genKey = BeanValidator.createGenericInfo(fieldType.getItemClazz(), fieldType.getItemGenericType(), null);
            EmitUtils.push_array((CodeEmitter)staticEmitter, (Object[])genKey);
        } else {
            staticEmitter.visitLdcInsn((Object)Type.getType(fieldType.getFieldClazz()));
            Object[] genKey = BeanValidator.createGenericInfo(fieldType.getFieldClazz(), fieldType.getFieldGenericType(), null);
            EmitUtils.push_array((CodeEmitter)staticEmitter, (Object[])genKey);
        }
        staticEmitter.invoke_static(BeanValidator.BEAN_VALIDATOR, BeanValidator.METHOD_CREATE_GENERIC);
        staticEmitter.putstatic(staticEmitter.getClassEmitter().getClassType(), staticName, BeanValidator.BEAN_VALIDATOR);
    }

    static void generator(CodeEmitter ce, String memberName, Consumer<CodeEmitter> valueCodeEmitter) {
        ce.getstatic(ce.getClassEmitter().getClassType(), memberName + MEMBER_VALIDATOR_SUFFIX, BeanValidator.BEAN_VALIDATOR);
        valueCodeEmitter.accept(ce);
        ce.load_arg(2);
        ce.load_arg(3);
        ce.invoke_static(BEAN_MEMBER_SUPPORT, METHOD_VALIDATE_MEMBER);
    }

    public static void validateMember(BeanValidator validator, Object memberValue, BeanValidatorDescription desc, Class<?> ... groups) {
        if (memberValue == null) {
            return;
        }
        validator.validate(memberValue, desc.getFieldPath().concat("."), new HashSet(), groups);
    }

    private BeanMemberValidatorSupport() {
    }
}

