/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.annoation;

import cn.com.yusys.yusp.commons.validation.util.CheckUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigDecimal;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Checker.class})
@Documented
public @interface NumberRange {
    public String message() default "{cn.com.yusys.yusp.commons.validation.annoation.NumberRange.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public long lt() default 0x7FFFFFFFFFFFFFFFL;

    public long gt() default -9223372036854775808L;

    public long le() default 0x7FFFFFFFFFFFFFFFL;

    public long ge() default -9223372036854775808L;

    public static class Checker
    implements ConstraintValidator<NumberRange, Object> {
        Long lt = 0L;
        Long gt = 0L;
        Long le = 0L;
        Long ge = 0L;

        public void initialize(NumberRange ann) {
            this.lt = ann.lt();
            this.gt = ann.gt();
            this.le = ann.le();
            this.ge = ann.ge();
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            if (null == value) {
                return true;
            }
            if (!CheckUtils.isNumberType(value)) {
                return false;
            }
            BigDecimal currentValue = new BigDecimal(value.toString());
            BigDecimal ltValue = new BigDecimal(this.lt.toString());
            BigDecimal gtValue = new BigDecimal(this.gt.toString());
            BigDecimal leValue = new BigDecimal(this.le.toString());
            BigDecimal geValue = new BigDecimal(this.ge.toString());
            return currentValue.compareTo(ltValue) < 0 && currentValue.compareTo(gtValue) > 0 && currentValue.compareTo(leValue) <= 0 && currentValue.compareTo(geValue) >= 0;
        }
    }
}

