/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.validation.annoation;

import cn.com.yusys.yusp.commons.validation.util.CheckUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Checker.class})
@Documented
public @interface Compare {
    public String message() default "{cn.com.yusys.yusp.commons.validation.annoation.Compare.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String ltField() default "";

    public String eqField() default "";

    public String gtField() default "";

    public static class Checker
    implements ConstraintValidator<Compare, Object> {
        String ltField = null;
        String gtField = null;
        String eqField = null;

        public void initialize(Compare ann) {
            this.ltField = ann.ltField();
            this.gtField = ann.gtField();
            this.eqField = ann.eqField();
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            Object currentBean = CheckUtils.getCurrentBean(context);
            if (null == value) {
                return true;
            }
            String valueT = value.toString();
            ArrayList<Boolean> result = new ArrayList<Boolean>();
            if (StringUtils.isNotBlank((CharSequence)this.ltField)) {
                Object ltFieldValue = CheckUtils.getFieldValue(this.ltField, currentBean);
                if (null == ltFieldValue) {
                    result.add(false);
                } else {
                    result.add(valueT.compareTo(ltFieldValue.toString()) < 0);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.gtField)) {
                Object gtFieldValue = CheckUtils.getFieldValue(this.gtField, currentBean);
                if (null == gtFieldValue) {
                    result.add(false);
                } else {
                    result.add(valueT.compareTo(gtFieldValue.toString()) > 0);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.eqField)) {
                Object eqFieldValue = CheckUtils.getFieldValue(this.eqField, currentBean);
                if (null == eqFieldValue) {
                    result.add(false);
                } else {
                    result.add(valueT.compareTo(eqFieldValue.toString()) == 0);
                }
            }
            return !result.contains(false);
        }
    }
}

