/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt.crypto;

import cn.com.yusys.yusp.commons.util.encrypt.crypto.ECKeyUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.KeyUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.PemUtils;
import cn.com.yusys.yusp.commons.util.encrypt.crypto.SecureUtils;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;

public class BCUtils {
    public static byte[] encodeECPrivateKey(PrivateKey privateKey) {
        return ((BCECPrivateKey)privateKey).getD().toByteArray();
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(true);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return BCUtils.decodeECPoint(SecureUtils.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByName((String)curveName);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint point = EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)curve.decodePoint(encodeByte));
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, x9ECParameters.getG(), x9ECParameters.getN());
        return KeyUtils.generatePublicKey("EC", new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
    }

    public static ECDomainParameters toDomainParams(org.bouncycastle.jce.spec.ECParameterSpec parameterSpec) {
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return BCUtils.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static AsymmetricKeyParameter toParams(Key key) {
        return ECKeyUtils.toParams(key);
    }

    public static ECPrivateKeyParameters toSm2Params(String d) {
        return ECKeyUtils.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(String dHex, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPrivateParams(dHex, domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(byte[] d) {
        return ECKeyUtils.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(byte[] d, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPrivateParams(d, domainParameters);
    }

    public static ECPrivateKeyParameters toSm2Params(BigInteger d) {
        return ECKeyUtils.toSm2PrivateParams(d);
    }

    public static ECPrivateKeyParameters toParams(BigInteger d, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPrivateParams(d, domainParameters);
    }

    public static ECPublicKeyParameters toParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPublicParams(x, y, domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(String xHex, String yHex) {
        return ECKeyUtils.toSm2PublicParams(xHex, yHex);
    }

    public static ECPublicKeyParameters toParams(String xHex, String yHex, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPublicParams(xHex, yHex, domainParameters);
    }

    public static ECPublicKeyParameters toSm2Params(byte[] xBytes, byte[] yBytes) {
        return ECKeyUtils.toSm2PublicParams(xBytes, yBytes);
    }

    public static ECPublicKeyParameters toParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        return ECKeyUtils.toPublicParams(xBytes, yBytes, domainParameters);
    }

    public static ECPublicKeyParameters toParams(PublicKey publicKey) {
        return ECKeyUtils.toPublicParams(publicKey);
    }

    public static ECPrivateKeyParameters toParams(PrivateKey privateKey) {
        return ECKeyUtils.toPrivateParams(privateKey);
    }

    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return PemUtils.readPemPrivateKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return PemUtils.readPemPublicKey(pemStream);
    }
}

