/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdUtils {
    private static Logger log;
    public static final String CLOCK_MOVED_BACKWARDS_REFUSING_GENERATE_ID = "Clock moved backwards.  Refusing to generate id for %d milliseconds";
    private static Snowflake SNOWFLAKE;
    private static String randomString;

    public static long nextId() {
        return SNOWFLAKE.nextId();
    }

    public static Snowflake getDefaultSnowflake() {
        return SNOWFLAKE;
    }

    public static Snowflake getSnowflake(long workerId, long dataCenterId) {
        return new Snowflake(workerId, dataCenterId);
    }

    public static String getId() {
        long idValue = SNOWFLAKE.nextId();
        String id = Long.toString(idValue);
        StringBuffer sb = new StringBuffer();
        if (id.startsWith("-")) {
            sb.append("Z").append(randomString).append(id.substring(1));
        } else {
            sb.append("A").append(randomString).append(id);
        }
        return sb.toString();
    }

    public static String getNumberId() {
        long idValue = SNOWFLAKE.nextId();
        String id = Long.toString(idValue);
        StringBuffer sb = new StringBuffer();
        if (id.startsWith("-")) {
            sb.append("9").append(randomString).append(id.substring(1));
        } else {
            sb.append("1").append(randomString).append(id);
        }
        return sb.toString();
    }

    private static long longIp(String strIp) {
        String[] ip = strIp.split("\\.");
        return (Long.parseLong(ip[0]) << 24) + (Long.parseLong(ip[1]) << 16) + (Long.parseLong(ip[2]) << 8) + Long.parseLong(ip[3]);
    }

    protected static String toIp(long longIp) {
        return StringUtils.concat(ListUtils.newArrayList(String.valueOf(longIp >>> 24), String.valueOf((longIp & 0xFFFFFFL) >>> 16), String.valueOf((longIp & 0xFFFFL) >>> 8), String.valueOf(longIp & 0xFFL)), ".");
    }

    private static String getLocalMac() throws Exception {
        return IdUtils.getLocalMac(InetAddress.getLocalHost());
    }

    private static String getLocalMac(InetAddress ia) throws Exception {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0").append(str);
                continue;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    static {
        String ip;
        log = LoggerFactory.getLogger(IdUtils.class);
        SNOWFLAKE = new Snowflake();
        randomString = "";
        long macAddress = 0L;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
            macAddress = Long.parseLong(IdUtils.getLocalMac().replace("-", ""), 16) % 31L;
        }
        catch (Exception e) {
            log.debug("getHostAddress err, deal with 'ip = \"127.0.0.1\"'; message:{}", (Object)e.getMessage());
            ip = "127.0.0.1";
        }
        long randomValue = IdUtils.longIp(ip);
        int randomNum = ThreadLocalRandom.current().nextInt(1000);
        randomValue = (long)randomNum + randomValue;
        randomValue += macAddress;
        randomString = String.valueOf(randomValue += (long)ThreadLocalRandom.current().nextInt(1000));
    }

    public static class Snowflake {
        private static final Logger logger = LoggerFactory.getLogger(Snowflake.class);
        private static final long TWEPOCH = 1609430400000L;
        private static final long WORKERIDBITS = 5L;
        private static final long DATACENTERIDBITS = 5L;
        private static final long MAXWORKERID = 31L;
        private static final long MAXDATACENTERID = 31L;
        private static final long SEQUENCEBITS = 12L;
        private static final long WORKERIDSHIFT = 12L;
        private static final long DATACENTERIDSHIFT = 17L;
        private static final long TIMESTAMPLEFTSHIFT = 22L;
        private static final long SEQUENCEMASK = 4095L;
        private long workerId;
        private long datacenterId;
        private long sequence = 0L;
        private long lastTimestamp = -1L;

        public Snowflake() {
            this.datacenterId = Snowflake.getDataCenterId(31L);
            this.workerId = Snowflake.getMaxWorkerId(this.datacenterId, 31L);
        }

        public Snowflake(long workerId, long dataCenterId) {
            if (workerId > 31L || workerId < 0L) {
                throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
            }
            if (dataCenterId > 31L || dataCenterId < 0L) {
                throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
            }
            this.workerId = workerId;
            this.datacenterId = dataCenterId;
        }

        public synchronized long nextId() {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                throw new UtilRuntimeException(String.format(IdUtils.CLOCK_MOVED_BACKWARDS_REFUSING_GENERATE_ID, this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.tiNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - 1609430400000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }

        protected long tiNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }

        protected static long getDataCenterId(long maxDatacenterId) {
            long id = 0L;
            try {
                InetAddress ip = InetAddress.getLocalHost();
                NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                if (network == null) {
                    id = 1L;
                } else {
                    byte[] mac = network.getHardwareAddress();
                    if (null != mac) {
                        id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                        id %= maxDatacenterId + 1L;
                    }
                }
            }
            catch (Exception e) {
                logger.warn(" getDataCenterId: {}", (Object)e.getMessage(), (Object)e);
            }
            return id;
        }

        protected static long getMaxWorkerId(long dataCenterId, long maxWorkerId) {
            StringBuilder mpid = new StringBuilder();
            mpid.append(dataCenterId);
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (!StringUtils.isBlank(name)) {
                mpid.append(name.split("@")[0]);
            }
            return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
        }
    }
}

