/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.util;

import cn.com.yusys.yusp.commons.data.model.PageInfo;
import cn.com.yusys.yusp.commons.data.query.Pageable;
import cn.com.yusys.yusp.commons.mapper.constant.SqlStatusEnum;
import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import cn.com.yusys.yusp.commons.mapper.sql.SqlHelper;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.Example;

public class MapperUtils {
    private static final Logger log = LoggerFactory.getLogger(MapperUtils.class);
    private static final Map<String, SqlStatusEnum> SQL_STATUS_MAP = new ConcurrentHashMap<String, SqlStatusEnum>(64);
    private static final Set<String> TO_INITIAL_ENTITY_SET = new CopyOnWriteArraySet<String>();
    private static final AtomicBoolean INITIALIZATION = new AtomicBoolean(false);
    private static SqlHelper helper;
    private static SqlExecutor executor;

    public static void init(SqlHelper sqlHelper, SqlExecutor sqlExecutor) {
        Asserts.nonNull((Object)sqlHelper, (Object[])new Object[]{"Sql helper object must not null!"});
        Asserts.nonNull((Object)sqlExecutor, (Object[])new Object[]{"Sql executor object must not null!"});
        if (INITIALIZATION.compareAndSet(false, true)) {
            helper = sqlHelper;
            executor = sqlExecutor;
            MapperUtils.asyncInitEntity();
        }
    }

    private static void asyncInitEntity() {
        CompletableFuture.runAsync(() -> TO_INITIAL_ENTITY_SET.forEach(name -> {
            try {
                helper.initEntityTable(Class.forName(name));
                log.debug("init entity class:{} complete", name);
            }
            catch (ClassNotFoundException e) {
                log.warn("init class:{} failure:{}", name, (Object)e);
            }
        }));
    }

    public static <T> T selectById(Class<T> entityClass, Serializable id) throws YuMapperException {
        MapperUtils.checkEntityClass(entityClass);
        String method = "selectById";
        MapperUtils.checkSqlStatus(entityClass, method);
        return MapperUtils.execSelectById(MapperUtils.getSqlId(entityClass, method), id);
    }

    public static <T> int selectCount(T record) throws YuMapperException {
        if (Objects.isNull(record)) {
            log.warn("Current query condition is null!");
            return 0;
        }
        return MapperUtils.selectCount(record.getClass(), record);
    }

    public static <T> int selectCount(Class<T> entityClass, Object record) throws YuMapperException {
        MapperUtils.checkEntityClass(entityClass);
        return MapperUtils.execSelectCount(entityClass, "selectCount", record);
    }

    public static int selectCount(Example example) throws YuMapperException {
        return MapperUtils.execSelectCount(example.getEntityClass(), "selectCountByExample", example);
    }

    public static <T> List<T> select(T record) throws YuMapperException {
        return MapperUtils.select(record.getClass(), record);
    }

    public static <T> List<T> select(Class<T> entityClass, Object record) throws YuMapperException {
        MapperUtils.checkEntityClass(entityClass);
        String method = "select";
        MapperUtils.checkSqlStatus(entityClass, method);
        return MapperUtils.execSelect(MapperUtils.getSqlId(entityClass, method), record);
    }

    public static <T> List<T> select(Example example) {
        String method = "selectByExample";
        MapperUtils.checkSqlStatus(example.getEntityClass(), method);
        return MapperUtils.execSelect(MapperUtils.getSqlId(example.getEntityClass(), method), example);
    }

    public static <T> PageInfo<T> page(T record, Pageable page) throws YuMapperException {
        return MapperUtils.page(record.getClass(), record, page);
    }

    public static <T> PageInfo<T> page(Class<T> entityClass, Object record, Pageable page) throws YuMapperException {
        return MapperUtils.page(entityClass, record, page, "select");
    }

    public static <T> PageInfo<T> page(Example example, Pageable page) throws YuMapperException {
        return MapperUtils.page(example.getEntityClass(), example, page, "selectByExample");
    }

    public static <T> int insert(T record) throws YuMapperException {
        return MapperUtils.insert(record.getClass(), record);
    }

    public static <T> int insert(Class<T> entityClass, Object record) throws YuMapperException {
        return MapperUtils.execInsert(entityClass, "insert", record);
    }

    public static <T, E> int insertBatch(Class<T> entityClass, List<E> recordList) {
        return MapperUtils.insertBatch(entityClass, recordList, false);
    }

    public static <T, E> int insertBatch(Class<T> entityClass, List<E> recordList, boolean transaction) {
        return MapperUtils.execInsertBatch(entityClass, "insert", recordList, transaction);
    }

    public static <T, E> int insertSelectiveBatch(Class<T> entityClass, List<E> recordList) {
        return MapperUtils.insertSelectiveBatch(entityClass, recordList, false);
    }

    public static <T, E> int insertSelectiveBatch(Class<T> entityClass, List<E> recordList, boolean transaction) {
        return MapperUtils.execInsertBatch(entityClass, "insertSelective", recordList, transaction);
    }

    public static <T> int insertSelective(T record) throws YuMapperException {
        return MapperUtils.insertSelective(record.getClass(), record);
    }

    public static <T> int insertSelective(Class<T> entityClass, Object record) throws YuMapperException {
        return MapperUtils.execInsert(entityClass, "insertSelective", record);
    }

    public static <T> int updateById(T record) throws YuMapperException {
        return MapperUtils.updateById(record.getClass(), record);
    }

    public static <T> int updateById(Class<T> entityClass, Object record) throws YuMapperException {
        return MapperUtils.execUpdate(entityClass, "updateById", record, null);
    }

    public static <T> int updateByIdSelective(T record) throws YuMapperException {
        return MapperUtils.updateByIdSelective(record.getClass(), record);
    }

    public static <T> int updateByIdSelective(Class<T> entityClass, Object record) throws YuMapperException {
        return MapperUtils.execUpdate(entityClass, "updateByIdSelective", record, null);
    }

    public static int update(Object record, Example example) throws YuMapperException {
        return MapperUtils.execUpdate(example.getEntityClass(), "updateByExample", record, example);
    }

    public static <T> int deleteById(Class<T> entityClass, Serializable id) throws YuMapperException {
        return MapperUtils.execDelete(entityClass, "deleteById", id);
    }

    public static <T> int deleteByIds(Class<T> entityClass, List<? extends Serializable> idList) throws YuMapperException {
        if (CollectionUtils.isEmpty(idList)) {
            log.warn("The primary key set to be deleted is empty!");
            return 0;
        }
        return MapperUtils.execDelete(entityClass, "deleteByIds", idList);
    }

    public static <T> int delete(T record) throws YuMapperException {
        if (Objects.isNull(record)) {
            log.warn("The current condition that needs to be deleted is null!");
            return 0;
        }
        return MapperUtils.delete(record.getClass(), record);
    }

    public static <T> int delete(Class<T> entityClass, Object record) throws YuMapperException {
        return MapperUtils.execDelete(entityClass, "delete", record);
    }

    public static int delete(Example example) throws YuMapperException {
        return MapperUtils.execDelete(example.getEntityClass(), "deleteByExample", example);
    }

    private static <T> T execSelectById(String sqlId, Serializable id) {
        return executor.selectById(sqlId, id);
    }

    private static int execSelectCount(Class<?> entityClass, String method, Object record) {
        MapperUtils.checkEntityClass(entityClass);
        MapperUtils.checkSqlStatus(entityClass, method);
        return executor.selectCount(MapperUtils.getSqlId(entityClass, method), record);
    }

    private static <T> List<T> execSelect(String sqlId, Object record) {
        return executor.select(sqlId, record);
    }

    private static <T> PageInfo<T> page(Class<T> entityClass, Object record, Pageable page, String method) throws YuMapperException {
        MapperUtils.checkEntityClass(entityClass);
        MapperUtils.checkSqlStatus(entityClass, method);
        return MapperUtils.execPage(MapperUtils.getSqlId(entityClass, method), record, page);
    }

    private static <T> PageInfo<T> execPage(String sqlId, Object record, Pageable page) {
        return executor.page(sqlId, record, page);
    }

    private static int execInsert(Class<?> entityClass, String method, Object record) {
        if (Objects.isNull(record)) {
            log.warn("The record to be added is null!");
            return 0;
        }
        MapperUtils.checkEntityClass(entityClass);
        MapperUtils.checkSqlStatus(entityClass, method);
        return executor.insert(MapperUtils.getSqlId(entityClass, method), record);
    }

    private static <T> int execInsertBatch(Class<?> entityClass, String method, List<T> recordList, boolean transaction) {
        if (CollectionUtils.isEmpty(recordList)) {
            log.warn("Current insert record list is empty!");
            return 0;
        }
        MapperUtils.checkEntityClass(entityClass);
        MapperUtils.checkSqlStatus(entityClass, method);
        return executor.insertBatch(MapperUtils.getSqlId(entityClass, method), recordList, transaction);
    }

    private static int execUpdate(Class<?> entityClass, String method, Object record, Example example) {
        MapperUtils.checkEntityClass(entityClass);
        MapperUtils.checkSqlStatus(entityClass, method);
        if (example != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("record", record);
            params.put("example", example);
            return executor.update(MapperUtils.getSqlId(example.getEntityClass(), method), params);
        }
        return executor.update(MapperUtils.getSqlId(entityClass, method), record);
    }

    private static int execDelete(Class<?> entityClass, String method, Object record) {
        if (Objects.isNull(record)) {
            log.warn("The incoming delete condition is null!");
            return 0;
        }
        MapperUtils.checkEntityClass(entityClass);
        MapperUtils.checkSqlStatus(entityClass, method);
        return executor.delete(MapperUtils.getSqlId(entityClass, method), record);
    }

    private static void checkSqlStatus(Class<?> entityClass, String method) throws YuMapperException {
        long startTime = System.currentTimeMillis();
        SqlStatusEnum status = MapperUtils.sqlStatus(entityClass, method);
        if (null == status || SqlStatusEnum.NONE.equals((Object)status)) {
            try {
                MapperUtils.injectMethod(entityClass, method);
            }
            catch (YuMapperException e) {
                log.error("generate MappedStatement failure", (Throwable)e);
                SQL_STATUS_MAP.put(MapperUtils.getSqlId(entityClass, method), SqlStatusEnum.EXCEPTION);
                throw e;
            }
            SQL_STATUS_MAP.put(MapperUtils.getSqlId(entityClass, method), SqlStatusEnum.SUCCESS);
        } else if (SqlStatusEnum.EXCEPTION.equals((Object)status)) {
            throw new YuMapperException("generate " + MapperUtils.getSqlId(entityClass, method) + " MappedStatement already failure");
        }
        log.debug("\u751f\u6210sql\u8017\u65f6:{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    private static <T> SqlStatusEnum sqlStatus(Class<T> entityClass, String method) {
        String sqlId = MapperUtils.getSqlId(entityClass, method);
        return SQL_STATUS_MAP.get(sqlId);
    }

    private static void injectMethod(Class<?> entityClass, String method) throws YuMapperException {
        helper.injectMethod(entityClass, method);
    }

    public static String getSqlId(Class<?> entityClass, String method) {
        return entityClass.getName() + "." + method;
    }

    public static void addEntity(String className) {
        TO_INITIAL_ENTITY_SET.add(className);
    }

    private static void checkEntityClass(Class<?> entityClass) {
        Asserts.nonNull(entityClass, (Object[])new Object[]{"Entity class must not null!"});
    }
}

