/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.page;

import cn.com.yusys.yusp.commons.data.model.PageInfo;
import cn.com.yusys.yusp.commons.mapper.page.PageResultConverter;
import com.github.pagehelper.Page;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageResultInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(PageResultInterceptor.class);
    private PageResultConverter<?> converter;

    public PageResultInterceptor(PageResultConverter<?> converter) {
        this.converter = converter;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        log.debug("exec PageResultInterceptor!");
        Object result = invocation.proceed();
        if (result instanceof Page && PageInfo.class.isAssignableFrom(invocation.getMethod().getReturnType()) && this.converter != null) {
            result = this.converter.convert((Page)result);
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

