/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.executor;

import cn.com.yusys.yusp.commons.data.model.PageResult;
import cn.com.yusys.yusp.commons.data.query.Pageable;
import cn.com.yusys.yusp.commons.data.query.Sort;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ClassUtils;

public class SqlSessionExecutor
implements SqlExecutor {
    private final Logger log = LoggerFactory.getLogger(SqlSessionExecutor.class);
    private static final String TRANSACTION_CLASS_NAME = "org.springframework.transaction.support.TransactionSynchronizationManager";
    private final boolean transactionPresent = ClassUtils.isPresent((String)"org.springframework.transaction.support.TransactionSynchronizationManager", null);
    private final SqlSession sqlSessionProxy;
    private SqlSessionFactory sqlSessionFactory;
    private int batchSize = 1000;

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public SqlSessionExecutor(SqlSession sqlSessionProxy) {
        this.sqlSessionProxy = sqlSessionProxy;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @Override
    public <T> List<T> select(String statement, Object record) {
        return this.sqlSessionProxy.selectList(statement, record);
    }

    public <T> PageResult<T> page(String statement, Object record, Pageable pageable) {
        List<T> result;
        if (pageable != null) {
            if (null != pageable.getSort() && !Objects.equals(pageable.getSort(), Sort.unSorted())) {
                PageHelper.startPage((int)pageable.getPage(), (int)pageable.getSize(), (String)pageable.getSort().getOrderBy());
            } else {
                PageHelper.startPage((int)pageable.getPage(), (int)pageable.getSize());
            }
        }
        if ((result = this.select(statement, record)) instanceof Page) {
            return new PageResult(((Page)result).getTotal(), ((Page)result).getPages(), ((Page)result).getResult());
        }
        return new PageResult<T>(result);
    }

    @Override
    public <T> int insert(String statement, Object record) {
        return this.sqlSessionProxy.insert(statement, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int insertBatch(String statement, List<T> recordList, boolean batchCommitUseSegmentedTransactions) {
        int i = 0;
        try (SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);){
            for (T record : recordList) {
                session.insert(statement, record);
                if (i != 0 && i % this.batchSize == 0 || i == recordList.size() - 1) {
                    session.flushStatements();
                    session.clearCache();
                }
                ++i;
            }
            if (batchCommitUseSegmentedTransactions || !this.transactionPresent || !TransactionSynchronizationManager.isSynchronizationActive()) {
                this.log.debug("Execute batch statement [{}] with useSegmentedTransactions : {},TransactionSynchronizationManager is present: {} , existing transaction : {} , commit operation!", new Object[]{statement, batchCommitUseSegmentedTransactions, this.transactionPresent, TransactionSynchronizationManager.isSynchronizationActive()});
                session.commit();
            }
        }
        return i;
    }

    @Override
    public <T> int update(String statement, Object record) {
        return this.sqlSessionProxy.update(statement, record);
    }

    @Override
    public <T> int delete(String statement, Object record) {
        return this.sqlSessionProxy.delete(statement, record);
    }

    @Override
    public <T> T selectById(String statement, Serializable id) {
        return (T)this.sqlSessionProxy.selectOne(statement, (Object)id);
    }

    @Override
    public int selectCount(String statement, Object record) {
        return (Integer)this.sqlSessionProxy.selectOne(statement, record);
    }
}

