/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.test.spring;

import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;

public class TestApplicationContext
implements ConfigurableApplicationContext {
    private static final Map<String, Object> beanMaps = new ConcurrentHashMap<String, Object>(8);

    public String getId() {
        return "TestApplicationContext";
    }

    public String getApplicationName() {
        return "YuspCommonsTest";
    }

    public String getDisplayName() {
        return this.getApplicationName();
    }

    public long getStartupDate() {
        return DateUtils.getCurrDate().getTime();
    }

    public ApplicationContext getParent() {
        throw new UnsupportedOperationException();
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public BeanFactory getParentBeanFactory() {
        throw new UnsupportedOperationException();
    }

    public boolean containsLocalBean(String name) {
        return beanMaps.containsKey(name);
    }

    public boolean containsBeanDefinition(String beanName) {
        return beanMaps.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanDefinitionNames() {
        return (String[])ArrayUtils.toArray(beanMaps.keySet(), String.class);
    }

    public String[] getBeanNamesForType(ResolvableType type) {
        throw new UnsupportedOperationException();
    }

    public String[] getBeanNamesForType(ResolvableType type, boolean includeNonSingletons, boolean allowEagerInit) {
        return new String[0];
    }

    public String[] getBeanNamesForType(Class<?> type) {
        LinkedList<String> beanNameList = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : beanMaps.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getClass())) continue;
            beanNameList.add(entry.getKey());
        }
        return (String[])ArrayUtils.toArray(beanNameList, String.class);
    }

    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.getBeanNamesForType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : beanMaps.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getClass())) continue;
            maps.put(entry.getKey(), entry.getValue());
        }
        return maps;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.getBeansOfType(type);
    }

    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        Map<String, Object> maps = this.getBeansWithAnnotation(annotationType);
        return (String[])ArrayUtils.toArray(maps.keySet(), String.class);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : beanMaps.entrySet()) {
            Annotation annotation = entry.getValue().getClass().getAnnotation(annotationType);
            if (!Objects.nonNull(annotation)) continue;
            maps.put(entry.getKey(), entry.getValue());
        }
        return maps;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        if (!beanMaps.containsKey(beanName)) {
            throw new NoSuchBeanDefinitionException("Bean name " + beanName + " not exist!");
        }
        Object object = beanMaps.get(beanName);
        return object.getClass().getAnnotation(annotationType);
    }

    public Object getBean(String name) throws BeansException {
        if (!beanMaps.containsKey(name)) {
            throw new BeanCreationException("Bean name " + name + " not exist!");
        }
        return beanMaps.get(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        if (!beanMaps.containsKey(name)) {
            throw new BeanCreationException("Bean name " + name + " not exist!");
        }
        Object obj = beanMaps.get(name);
        return (T)(requiredType.isAssignableFrom(obj.getClass()) ? obj : null);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.getBean(name);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        Asserts.nonNull(requiredType, (Object[])new Object[]{"Required type cannot be empty!"});
        for (Map.Entry<String, Object> entry : beanMaps.entrySet()) {
            if (!requiredType.isAssignableFrom(entry.getValue().getClass())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return this.getBean(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        return new TestObjectProvider(this.getBean(requiredType));
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        throw new UnsupportedOperationException();
    }

    public boolean containsBean(String name) {
        return beanMaps.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        Object object = this.getBean(name);
        return Objects.nonNull(object) ? object.getClass() : null;
    }

    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return null;
    }

    public String[] getAliases(String name) {
        throw new UnsupportedOperationException();
    }

    public void publishEvent(Object event) {
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new UnsupportedOperationException();
    }

    public void setId(String id) {
    }

    public void setParent(ApplicationContext parent) {
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
    }

    public ConfigurableEnvironment getEnvironment() {
        throw new UnsupportedOperationException();
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor postProcessor) {
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
    }

    public void setClassLoader(ClassLoader classLoader) {
    }

    public void addProtocolResolver(ProtocolResolver resolver) {
    }

    public void refresh() throws BeansException, IllegalStateException {
    }

    public void registerShutdownHook() {
    }

    public void close() {
    }

    public boolean isActive() {
        return false;
    }

    public ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException {
        return null;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(String location) {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader();
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    public void register(String beanName, Object bean) {
        Asserts.nonNull((Object)bean, (Object[])new Object[]{"Registered bean must not null!"});
        if (StringUtils.isEmpty((CharSequence)beanName)) {
            beanName = StringUtils.initialLetterLowercase((String)bean.getClass().getSimpleName());
        }
        beanMaps.put(beanName, bean);
    }

    private static class TestObjectProvider
    implements ObjectProvider {
        private List<Object> objects;

        public TestObjectProvider(Object ... objects) {
            this.objects = Collections.unmodifiableList(Arrays.asList(objects));
        }

        public Object getObject(Object ... args) throws BeansException {
            return null;
        }

        public Object getIfAvailable() throws BeansException {
            return CommonUtils.nonNullOrEmpty(this.objects) ? this.objects.get(0) : null;
        }

        public Object getIfUnique() throws BeansException {
            return this.getIfAvailable();
        }

        public Object getObject() throws BeansException {
            return this.getIfAvailable();
        }
    }
}

