/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.test.spring;

import cn.com.yusys.yusp.commons.test.spring.TestApplicationContext;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import org.springframework.context.ApplicationContext;

public class SpringFactory {
    private static final TestApplicationContext applicationContext = new TestApplicationContext();

    private SpringFactory() {
    }

    public static SpringFactory instance() {
        return SpringFactoryHandle.FACTORY;
    }

    public SpringFactory register(String beanName, Object bean) {
        applicationContext.register(beanName, bean);
        return this;
    }

    public SpringFactory register(Object bean) {
        Asserts.nonNull((Object)bean, (Object[])new Object[]{"Registered bean must not null!"});
        return this.register(bean.getClass().getSimpleName(), bean);
    }

    public ApplicationContext applicationContext() {
        return applicationContext;
    }

    public void initialize() {
        if (SpringContextUtils.getApplicationContext() == null) {
            new SpringContextUtils().setApplicationContext((ApplicationContext)applicationContext);
        }
    }

    private static final class SpringFactoryHandle {
        private static final SpringFactory FACTORY = new SpringFactory();

        private SpringFactoryHandle() {
        }
    }
}

